/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import tim.prune.config.Config;
import tim.prune.data.TrackInfo;

public abstract class PointColourer {
    private static final Color _defaultColour = Color.BLUE;
    private final Color _startColour;
    private final Color _endColour;
    private final int _maxColours;
    private final boolean _wideHues;

    public PointColourer(Color color, Color color2, int n, boolean bl) {
        this._startColour = color;
        this._endColour = color2;
        this._maxColours = n;
        this._wideHues = bl;
    }

    public PointColourer(Color color, Color color2, boolean bl) {
        this(color, color2, -1, bl);
    }

    public abstract void calculateColours(TrackInfo var1, Config var2);

    public Color getColour(int n) {
        return _defaultColour;
    }

    protected Color getDefaultColour() {
        return _defaultColour;
    }

    protected Color getStartColour() {
        return this._startColour == null ? this.getDefaultColour() : this._startColour;
    }

    protected Color getEndColour() {
        return this._endColour == null ? this.getDefaultColour() : this._endColour;
    }

    protected int getMaxColours() {
        return this._maxColours;
    }

    boolean isWideHueScaling() {
        return this._wideHues;
    }

    boolean isDiscrete() {
        return this._maxColours >= 0;
    }

    protected Color mixColour(float f) {
        if (this._startColour == null && this._endColour == null) {
            return this.getDefaultColour();
        }
        if (this._startColour == null) {
            return this._endColour;
        }
        if (this._endColour == null || (double)f < 0.0 || (double)f > 1.0) {
            return this._startColour;
        }
        float[] fArray = Color.RGBtoHSB(this._startColour.getRed(), this._startColour.getGreen(), this._startColour.getBlue(), null);
        float[] fArray2 = Color.RGBtoHSB(this._endColour.getRed(), this._endColour.getGreen(), this._endColour.getBlue(), null);
        float f2 = (double)fArray[1] == 0.0 ? fArray2[0] : fArray[0];
        float f3 = (double)fArray2[1] == 0.0 ? fArray[0] : fArray2[0];
        float f4 = PointColourer.calculateHue(f2, f3, f, this._wideHues);
        return Color.getHSBColor(f4, fArray[1] + (fArray2[1] - fArray[1]) * f, fArray[2] + (fArray2[2] - fArray[2]) * f);
    }

    private static float calculateHue(float f, float f2, float f3, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = (double)Math.abs(f2 - f) > 0.5;
        if (bl == bl2) {
            return PointColourer.interpolate(f, f2, f3);
        }
        if (f <= f2) {
            return PointColourer.interpolate(f + 1.0f, f2, f3);
        }
        return PointColourer.interpolate(f, f2 + 1.0f, f3);
    }

    private static float interpolate(float f, float f2, float f3) {
        return f + (f2 - f) * f3;
    }
}

