/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.juife.OkCancelDialog;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.task.Global;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;
import org.linuxsampler.lscp.Instrument;
import org.linuxsampler.lscp.MidiInstrumentInfo;
import org.linuxsampler.lscp.SamplerEngine;

public class JSEditMidiInstrumentDlg
extends OkCancelDialog {
    private final JLabel lName = new JLabel(StdI18n.i18n.getLabel("JSEditMidiInstrumentDlg.lName"));
    private final JLabel lFilename = new JLabel(StdI18n.i18n.getLabel("JSEditMidiInstrumentDlg.lFilename"));
    private final JLabel lIndex = new JLabel(StdI18n.i18n.getLabel("JSEditMidiInstrumentDlg.lIndex"));
    private final JLabel lEngine = new JLabel(StdI18n.i18n.getLabel("JSEditMidiInstrumentDlg.lEngine"));
    private final JLabel lLoadMode = new JLabel(StdI18n.i18n.getLabel("JSEditMidiInstrumentDlg.lLoadMode"));
    private final JLabel lVolume = new JLabel(StdI18n.i18n.getLabel("JSEditMidiInstrumentDlg.lVolume"));
    private final JTextField tfName = new JTextField();
    private final JComboBox cbFilename = new JComboBox();
    private final JComboBox cbIndex = new JComboBox();
    private final JComboBox cbEngine = new JComboBox();
    private final JComboBox cbLoadMode = new JComboBox();
    private final JSlider slVolume = StdUtils.createVolumeSlider();
    private final MidiInstrumentInfo instrument;
    private boolean init = true;
    private final Handler eventHandler = new Handler();

    public JSEditMidiInstrumentDlg(MidiInstrumentInfo midiInstrumentInfo) {
        super((Frame)CC.getMainFrame(), StdI18n.i18n.getLabel("JSEditMidiInstrumentDlg.title"));
        String[] stringArray;
        this.instrument = midiInstrumentInfo;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lName, gridBagConstraints);
        jPanel.add(this.lName);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.lFilename, gridBagConstraints);
        jPanel.add(this.lFilename);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.lIndex, gridBagConstraints);
        jPanel.add(this.lIndex);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(12, 3, 3, 3);
        gridBagLayout.setConstraints(this.lEngine, gridBagConstraints);
        jPanel.add(this.lEngine);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.lLoadMode, gridBagConstraints);
        jPanel.add(this.lLoadMode);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.lVolume, gridBagConstraints);
        jPanel.add(this.lVolume);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 12, 3, 3);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.tfName, gridBagConstraints);
        jPanel.add(this.tfName);
        this.cbFilename.setEditable(true);
        String[] object = stringArray = this.preferences().getStringListProperty("recentInstrumentFiles");
        int n = object.length;
        for (int i = 0; i < n; ++i) {
            String string = object[i];
            this.cbFilename.addItem(string);
        }
        this.cbFilename.setSelectedItem(null);
        Dimension dimension = this.cbFilename.getPreferredSize();
        dimension.width = 250;
        this.cbFilename.setPreferredSize(dimension);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.cbFilename, gridBagConstraints);
        jPanel.add(this.cbFilename);
        for (n = 0; n < 101; ++n) {
            this.cbIndex.addItem(n);
        }
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.cbIndex, gridBagConstraints);
        jPanel.add(this.cbIndex);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(12, 12, 3, 64);
        gridBagLayout.setConstraints(this.cbEngine, gridBagConstraints);
        jPanel.add(this.cbEngine);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(3, 12, 3, 64);
        gridBagLayout.setConstraints(this.cbLoadMode, gridBagConstraints);
        jPanel.add(this.cbLoadMode);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagLayout.setConstraints(this.slVolume, gridBagConstraints);
        jPanel.add(this.slVolume);
        this.setMainPane(jPanel);
        this.cbFilename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JSEditMidiInstrumentDlg.this.updateState();
                JSEditMidiInstrumentDlg.this.updateFileInstruments();
            }
        });
        this.tfName.setText(midiInstrumentInfo.getName());
        this.cbFilename.setSelectedItem(midiInstrumentInfo.getFilePath());
        this.cbIndex.setSelectedIndex(midiInstrumentInfo.getInstrumentIndex());
        this.slVolume.setValue((int)(midiInstrumentInfo.getVolume() * 100.0));
        for (SamplerEngine samplerEngine : CC.getSamplerModel().getEngines()) {
            this.cbEngine.addItem(samplerEngine);
            if (!samplerEngine.getName().equals(midiInstrumentInfo.getEngine())) continue;
            this.cbEngine.setSelectedItem(samplerEngine);
        }
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.DEFAULT);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.ON_DEMAND);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.ON_DEMAND_HOLD);
        this.cbLoadMode.addItem(MidiInstrumentInfo.LoadMode.PERSISTENT);
        this.cbLoadMode.setSelectedItem((Object)midiInstrumentInfo.getLoadMode());
        this.tfName.getDocument().addDocumentListener(this.getHandler());
    }

    protected JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public MidiInstrumentInfo getInstrument() {
        return this.instrument;
    }

    @Override
    public void onOk() {
        this.instrument.setName(this.tfName.getText());
        this.instrument.setFilePath(this.cbFilename.getSelectedItem().toString());
        this.instrument.setInstrumentIndex(this.cbIndex.getSelectedIndex());
        String string = ((SamplerEngine)this.cbEngine.getSelectedItem()).getName();
        this.instrument.setEngine(string);
        this.instrument.setLoadMode((MidiInstrumentInfo.LoadMode)((Object)this.cbLoadMode.getSelectedItem()));
        float f = this.slVolume.getValue();
        this.instrument.setVolume(f /= 100.0f);
        this.setCancelled(false);
        this.setVisible(false);
    }

    @Override
    public void onCancel() {
        this.setVisible(false);
    }

    private void updateState() {
        Object object;
        boolean bl;
        boolean bl2 = bl = this.tfName.getText().length() != 0;
        if (this.cbFilename.getSelectedItem() == null) {
            bl = false;
        }
        if ((object = this.cbIndex.getSelectedItem()) == null || object.toString().length() == 0) {
            bl = false;
        }
        this.btnOk.setEnabled(bl);
    }

    private void updateFileInstruments() {
        Object object = this.cbFilename.getSelectedItem();
        if (object == null) {
            return;
        }
        String string = object.toString();
        final Global.GetFileInstruments getFileInstruments = new Global.GetFileInstruments(string);
        getFileInstruments.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                int n;
                Instrument[] instrumentArray = (Instrument[])getFileInstruments.getResult();
                if (instrumentArray == null) {
                    JSEditMidiInstrumentDlg.this.cbIndex.removeAllItems();
                    for (int i = 0; i < 101; ++i) {
                        JSEditMidiInstrumentDlg.this.cbIndex.addItem(i);
                    }
                    return;
                }
                JSEditMidiInstrumentDlg.this.cbIndex.removeAllItems();
                for (n = 0; n < instrumentArray.length; ++n) {
                    JSEditMidiInstrumentDlg.this.cbIndex.addItem(n + " - " + instrumentArray[n].getName());
                }
                if (JSEditMidiInstrumentDlg.this.init) {
                    n = JSEditMidiInstrumentDlg.this.getInstrument().getInstrumentIndex();
                    JSEditMidiInstrumentDlg.this.cbIndex.setSelectedIndex(n);
                    JSEditMidiInstrumentDlg.this.init = false;
                }
            }
        });
        CC.getTaskQueue().add(getFileInstruments);
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements DocumentListener {
        private Handler() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            JSEditMidiInstrumentDlg.this.updateState();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            JSEditMidiInstrumentDlg.this.updateState();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            JSEditMidiInstrumentDlg.this.updateState();
        }
    }
}

