/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.HashMap;
import kafka.log.LogManager;
import kafka.server.BrokerReconfigurable;
import kafka.server.DynamicLogConfig$;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.server.config.ServerLogConfigs;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.UnifiedLog;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Map;
import scala.collection.Set;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0015<Q\u0001D\u0007\t\u0002I1Q\u0001F\u0007\t\u0002UAQ\u0001H\u0001\u0005\u0002uAqAH\u0001C\u0002\u0013\u0005q\u0004\u0003\u00042\u0003\u0001\u0006I\u0001\t\u0004\u0005)5\u0001!\u0007\u0003\u0005=\u000b\t\u0005\t\u0015!\u0003>\u0011\u0015aR\u0001\"\u0001D\u0011\u00151U\u0001\"\u0011 \u0011\u00159U\u0001\"\u0011I\u0011\u0015\tV\u0001\"\u0003S\u0011\u0015\u0001W\u0001\"\u0011b\u0003A!\u0015P\\1nS\u000edunZ\"p]\u001aLwM\u0003\u0002\u000f\u001f\u000511/\u001a:wKJT\u0011\u0001E\u0001\u0006W\u000647.Y\u0002\u0001!\t\u0019\u0012!D\u0001\u000e\u0005A!\u0015P\\1nS\u000edunZ\"p]\u001aLwm\u0005\u0002\u0002-A\u0011qCG\u0007\u00021)\t\u0011$A\u0003tG\u0006d\u0017-\u0003\u0002\u001c1\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\n\u0002+I+7m\u001c8gS\u001e,(/\u00192mK\u000e{gNZ5hgV\t\u0001\u0005E\u0002\"I\u0019j\u0011A\t\u0006\u0003Ga\t!bY8mY\u0016\u001cG/[8o\u0013\t)#EA\u0002TKR\u0004\"a\n\u0018\u000f\u0005!b\u0003CA\u0015\u0019\u001b\u0005Q#BA\u0016\u0012\u0003\u0019a$o\\8u}%\u0011Q\u0006G\u0001\u0007!J,G-\u001a4\n\u0005=\u0002$AB*ue&twM\u0003\u0002.1\u00051\"+Z2p]\u001aLw-\u001e:bE2,7i\u001c8gS\u001e\u001c\be\u0005\u0003\u0006-M2\u0004CA\n5\u0013\t)TB\u0001\u000bCe>\\WM\u001d*fG>tg-[4ve\u0006\u0014G.\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003s=\tQ!\u001e;jYNL!a\u000f\u001d\u0003\u000f1{wmZ5oO\u0006QAn\\4NC:\fw-\u001a:\u0011\u0005y\nU\"A \u000b\u0005\u0001{\u0011a\u00017pO&\u0011!i\u0010\u0002\u000b\u0019><W*\u00198bO\u0016\u0014HC\u0001#F!\t\u0019R\u0001C\u0003=\u000f\u0001\u0007Q(A\u000bsK\u000e|gNZ5hkJ\f'\r\\3D_:4\u0017nZ:\u0002/Y\fG.\u001b3bi\u0016\u0014VmY8oM&<WO]1uS>tGCA%M!\t9\"*\u0003\u0002L1\t!QK\\5u\u0011\u0015i\u0015\u00021\u0001O\u0003%qWm^\"p]\u001aLw\r\u0005\u0002\u0014\u001f&\u0011\u0001+\u0004\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\tva\u0012\fG/\u001a'pON\u001cuN\u001c4jOR\u0011\u0011j\u0015\u0005\u0006)*\u0001\r!V\u0001\u0012]\u0016<(I]8lKJ$UMZ1vYR\u001c\b\u0003B\u0011WMaK!a\u0016\u0012\u0003\u00075\u000b\u0007\u000f\u0005\u0002Z=6\t!L\u0003\u0002\\9\u0006!A.\u00198h\u0015\u0005i\u0016\u0001\u00026bm\u0006L!a\u0018.\u0003\r=\u0013'.Z2u\u0003-\u0011XmY8oM&<WO]3\u0015\u0007%\u0013G\rC\u0003d\u0017\u0001\u0007a*A\u0005pY\u0012\u001cuN\u001c4jO\")Qj\u0003a\u0001\u001d\u0002")
public class DynamicLogConfig
implements BrokerReconfigurable,
Logging {
    private final LogManager logManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Set<String> ReconfigurableConfigs() {
        return DynamicLogConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Set<String> reconfigurableConfigs() {
        return DynamicLogConfig$.MODULE$.ReconfigurableConfigs();
    }

    @Override
    public void validateReconfiguration(KafkaConfig newConfig) {
        DynamicLogConfig.validateLogLocalRetentionMs$1(newConfig);
        DynamicLogConfig.validateLogLocalRetentionBytes$1(newConfig);
    }

    private void updateLogsConfig(Map<String, Object> newBrokerDefaults) {
        this.logManager.brokerConfigUpdated();
        this.logManager.allLogs().foreach((Function1 & Serializable)log -> {
            scala.collection.mutable.Map props = (scala.collection.mutable.Map)Map$.MODULE$.empty();
            props.$plus$plus$eq((IterableOnce)newBrokerDefaults);
            props.$plus$plus$eq((IterableOnce)CollectionConverters$.MODULE$.MapHasAsScala(log.config().originals()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DynamicLogConfig.$anonfun$updateLogsConfig$2(log, x0$1))));
            LogConfig logConfig = new LogConfig(CollectionConverters$.MODULE$.MutableMapHasAsJava(props).asJava(), log.config().overriddenConfigs);
            return log.updateConfig(logConfig);
        });
    }

    @Override
    public void reconfigure(KafkaConfig oldConfig, KafkaConfig newConfig) {
        HashMap<String, Object> newBrokerDefaults = new HashMap<String, Object>(newConfig.extractLogConfigMap());
        this.logManager.reconfigureDefaultLogConfig(new LogConfig(newBrokerDefaults));
        this.updateLogsConfig((Map<String, Object>)CollectionConverters$.MODULE$.MapHasAsScala(newBrokerDefaults).asScala());
    }

    private static final void validateLogLocalRetentionMs$1(KafkaConfig newConfig$4) {
        long logRetentionMs = newConfig$4.logRetentionTimeMillis();
        long l = newConfig$4.remoteLogManagerConfig().logLocalRetentionMs();
        Long logLocalRetentionMs = Predef$.MODULE$.long2Long(l);
        if (logRetentionMs != -1L && !BoxesRunTime.equalsNumObject((Number)logLocalRetentionMs, (Object)BoxesRunTime.boxToLong((long)-2L))) {
            if (BoxesRunTime.equalsNumObject((Number)logLocalRetentionMs, (Object)BoxesRunTime.boxToLong((long)-1L))) {
                throw new ConfigException("log.local.retention.ms", (Object)logLocalRetentionMs, "Value must not be -1 as " + ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG + " value is set as " + logRetentionMs + ".");
            }
            if (l > logRetentionMs) {
                throw new ConfigException("log.local.retention.ms", (Object)logLocalRetentionMs, "Value must not be more than " + ServerLogConfigs.LOG_RETENTION_TIME_MILLIS_CONFIG + " property value: " + logRetentionMs);
            }
            return;
        }
    }

    private static final void validateLogLocalRetentionBytes$1(KafkaConfig newConfig$4) {
        Long logRetentionBytes = newConfig$4.logRetentionBytes();
        long l = newConfig$4.remoteLogManagerConfig().logLocalRetentionBytes();
        Long logLocalRetentionBytes = Predef$.MODULE$.long2Long(l);
        if (Predef$.MODULE$.Long2long(logRetentionBytes) > -1L && !BoxesRunTime.equalsNumObject((Number)logLocalRetentionBytes, (Object)BoxesRunTime.boxToInteger((int)-2))) {
            if (BoxesRunTime.equalsNumObject((Number)logLocalRetentionBytes, (Object)BoxesRunTime.boxToInteger((int)-1))) {
                throw new ConfigException("log.local.retention.bytes", (Object)logLocalRetentionBytes, "Value must not be -1 as " + ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG + " value is set as " + logRetentionBytes + ".");
            }
            if (l > Predef$.MODULE$.Long2long(logRetentionBytes)) {
                throw new ConfigException("log.local.retention.bytes", (Object)logLocalRetentionBytes, "Value must not be more than " + ServerLogConfigs.LOG_RETENTION_BYTES_CONFIG + " property value: " + logRetentionBytes);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateLogsConfig$2(UnifiedLog log$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            String k = (String)x0$1._1();
            return log$1.config().overriddenConfigs.contains(k);
        }
        throw new MatchError(null);
    }

    public DynamicLogConfig(LogManager logManager) {
        this.logManager = logManager;
    }
}

