/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import org.infinispan.container.offheap.OffHeapMemory;

class OffHeapLruNode {
    private static final OffHeapMemory MEMORY = OffHeapMemory.INSTANCE;
    private static final int ADDRESS_SIZE = 8;
    private static final int PREVIOUS_NODE_OFFSET = 0;
    private static final int NEXT_NODE_OFFSET = 8;

    private OffHeapLruNode() {
    }

    static long getNext(long lruNodeAddress) {
        return MEMORY.getLong(lruNodeAddress, 8L);
    }

    static void setNext(long lruNodeAddress, long nextAddress) {
        MEMORY.putLong(lruNodeAddress, 8L, nextAddress);
    }

    static long getPrevious(long lruNodeAddress) {
        return MEMORY.getLong(lruNodeAddress, 0L);
    }

    static void setPrevious(long lruNodeAddress, long previousAddress) {
        MEMORY.putLong(lruNodeAddress, 0L, previousAddress);
    }

    static String debugString(long address) {
        return String.format("0x%016x <-- entry 0x%016x --> 0x%016x", OffHeapLruNode.getPrevious(address), address, OffHeapLruNode.getNext(address));
    }
}

