/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.conditional;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.AuthenticationFlowContext;
import org.keycloak.authentication.AuthenticatorUtil;
import org.keycloak.authentication.authenticators.conditional.ConditionalAuthenticator;
import org.keycloak.models.Constants;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;

public class ConditionalCredentialAuthenticator
implements ConditionalAuthenticator {
    protected static final ConditionalCredentialAuthenticator SINGLETON = new ConditionalCredentialAuthenticator();
    private static final Logger logger = Logger.getLogger(ConditionalCredentialAuthenticator.class);

    @Override
    public boolean matchCondition(AuthenticationFlowContext context) {
        Map config = context.getAuthenticatorConfig() != null ? context.getAuthenticatorConfig().getConfig() : Collections.emptyMap();
        HashSet<String> credentials = new HashSet<String>(Arrays.asList(Constants.CFG_DELIMITER_PATTERN.split(config.getOrDefault("credentials", ""))));
        boolean included = Boolean.parseBoolean((String)config.get("included"));
        List<String> authCredentials = AuthenticatorUtil.getAuthnCredentials(context.getAuthenticationSession());
        if (authCredentials.isEmpty()) {
            authCredentials = Collections.singletonList("none");
        }
        if (logger.isTraceEnabled()) {
            logger.tracef("Checking if any authentication credential '%s' is %s in %s", authCredentials, (Object)(included ? "included" : "not included"), credentials);
        }
        credentials.retainAll(authCredentials);
        return included ? !credentials.isEmpty() : credentials.isEmpty();
    }

    public void action(AuthenticationFlowContext context) {
    }

    public boolean requiresUser() {
        return true;
    }

    public void setRequiredActions(KeycloakSession session, RealmModel realm, UserModel user) {
    }

    public void close() {
    }
}

