/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ad.rest;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.ad.indices.ADIndex;
import org.opensearch.ad.settings.ADEnabledSetting;
import org.opensearch.ad.transport.GetAnomalyDetectorAction;
import org.opensearch.core.action.ActionListener;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.timeseries.transport.GetConfigRequest;
import org.opensearch.timeseries.util.RestHandlerUtils;
import org.opensearch.transport.client.node.NodeClient;

public class RestGetAnomalyDetectorAction
extends BaseRestHandler {
    private static final String GET_ANOMALY_DETECTOR_ACTION = "get_anomaly_detector";
    private static final Logger logger = LogManager.getLogger(RestGetAnomalyDetectorAction.class);

    public String getName() {
        return GET_ANOMALY_DETECTOR_ACTION;
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!ADEnabledSetting.isADEnabled()) {
            throw new IllegalStateException("AD functionality is disabled. To enable update plugins.anomaly_detection.enabled to true");
        }
        String detectorId = request.param("detectorID");
        String typesStr = request.param("type");
        String rawPath = request.rawPath();
        boolean returnJob = request.paramAsBoolean("job", false);
        boolean returnTask = request.paramAsBoolean("task", false);
        boolean all = request.paramAsBoolean("_all", false);
        GetConfigRequest getConfigRequest = new GetConfigRequest(detectorId, ADIndex.CONFIG.getIndexName(), RestActions.parseVersion((RestRequest)request), returnJob, returnTask, typesStr, rawPath, all, RestHandlerUtils.buildEntity(request, detectorId));
        return channel -> client.execute((ActionType)GetAnomalyDetectorAction.INSTANCE, (ActionRequest)getConfigRequest, (ActionListener)new RestToXContentListener(channel));
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "_profile")), (Object)new RestHandler.Route(RestRequest.Method.POST, String.format(Locale.ROOT, "%s/{%s}/%s/{%s}", "/_plugins/_anomaly_detection/detectors", "detectorID", "_profile", "type")));
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        String path = String.format(Locale.ROOT, "%s/{%s}", "/_opendistro/_anomaly_detection/detectors", "detectorID");
        String newPath = String.format(Locale.ROOT, "%s/{%s}", "/_plugins/_anomaly_detection/detectors", "detectorID");
        return ImmutableList.of((Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, newPath, RestRequest.Method.GET, path), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.HEAD, newPath, RestRequest.Method.HEAD, path), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}/%s", "/_plugins/_anomaly_detection/detectors", "detectorID", "_profile"), RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}/%s", "/_opendistro/_anomaly_detection/detectors", "detectorID", "_profile")), (Object)new RestHandler.ReplacedRoute(RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}/%s/{%s}", "/_plugins/_anomaly_detection/detectors", "detectorID", "_profile", "type"), RestRequest.Method.GET, String.format(Locale.ROOT, "%s/{%s}/%s/{%s}", "/_opendistro/_anomaly_detection/detectors", "detectorID", "_profile", "type")));
    }
}

