/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.ml;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SingleStreamModelIdMapper {
    protected static final String CONFIG_ID_PATTERN = "(.*)_model_.+";
    protected static final String RCF_MODEL_ID_PATTERN = "%s_model_rcf_%d";
    protected static final String THRESHOLD_MODEL_ID_PATTERN = "%s_model_threshold";
    protected static final String CASTER_MODEL_ID_PATTERN = "%s_model_caster";

    public static String getRcfModelId(String detectorId, int partitionNumber) {
        return String.format(Locale.ROOT, RCF_MODEL_ID_PATTERN, detectorId, partitionNumber);
    }

    public static String getThresholdModelId(String detectorId) {
        return String.format(Locale.ROOT, THRESHOLD_MODEL_ID_PATTERN, detectorId);
    }

    public static String getCasterModelId(String forecasterId) {
        return String.format(Locale.ROOT, CASTER_MODEL_ID_PATTERN, forecasterId);
    }

    public static String getConfigIdForModelId(String modelId) {
        Matcher matcher = Pattern.compile(CONFIG_ID_PATTERN).matcher(modelId);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("Invalid model id " + modelId);
    }

    public static String getThresholdModelIdFromRCFModelId(String rcfModelId) {
        String detectorId = SingleStreamModelIdMapper.getConfigIdForModelId(rcfModelId);
        return SingleStreamModelIdMapper.getThresholdModelId(detectorId);
    }
}

