"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MockStateAdapter = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

// Mock StateAdapter implementation
class MockStateAdapter {
  constructor(initialState) {
    _defineProperty(this, "state", void 0);
    _defineProperty(this, "listeners", []);
    this.state = initialState;
  }
  getState() {
    return this.state;
  }
  setState(updater) {
    this.state = updater(this.state);
    this.listeners.forEach(listener => listener(this.state));
  }
  subscribe(listener) {
    this.listeners.push(listener);
    return () => {
      this.listeners = this.listeners.filter(l => l !== listener);
    };
  }
}
exports.MockStateAdapter = MockStateAdapter;