/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.processor.collapse;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.lucene.search.FieldDoc;
import org.opensearch.neuralsearch.processor.CompoundTopDocs;
import org.opensearch.neuralsearch.processor.collapse.CollapseDTO;
import org.opensearch.neuralsearch.processor.collapse.CollapseDataCollector;
import org.opensearch.neuralsearch.processor.collapse.CollapseResultUpdater;

public abstract class CollapseStrategy {
    protected int totalCollapsedDocsCount = 0;

    public abstract void executeCollapse(CollapseDTO var1);

    protected <T> void executeCollapseGeneric(CollapseDTO collapseDTO, CollapseDataCollector<T> collapseDataCollector) {
        collapseDataCollector.collectCollapseData(collapseDTO);
        List<Map.Entry<T, FieldDoc>> sortedCollapseEntries = collapseDataCollector.getSortedCollapseEntries();
        Map<Integer, List<Map.Entry>> shardToCollapseEntriesMap = sortedCollapseEntries.stream().collect(Collectors.groupingBy(entry -> collapseDataCollector.getCollapseShardIndex(entry.getKey())));
        CollapseResultUpdater collapseResultUpdater = new CollapseResultUpdater();
        for (int shardIndex = 0; shardIndex < collapseDTO.getCollapseQuerySearchResults().size(); ++shardIndex) {
            CompoundTopDocs updatedCollapseTopDocs = collapseDTO.getCollapseQueryTopDocs().get(shardIndex);
            List relevantCollapseEntries = shardToCollapseEntriesMap.getOrDefault(shardIndex, Collections.emptyList());
            collapseDTO.updateForShard(relevantCollapseEntries, collapseDataCollector.getCollapseField(), updatedCollapseTopDocs, shardIndex);
            collapseResultUpdater.updateCollapseResults(collapseDTO);
            this.totalCollapsedDocsCount += collapseResultUpdater.getProcessedCollapsedDocsCount().intValue();
        }
    }

    public static CollapseStrategy createKeywordStrategy() {
        return new KeywordCollapseStrategy();
    }

    public static CollapseStrategy createNumericStrategy() {
        return new NumericCollapseStrategy();
    }

    @Generated
    public int getTotalCollapsedDocsCount() {
        return this.totalCollapsedDocsCount;
    }

    private static class KeywordCollapseStrategy
    extends CollapseStrategy {
        private KeywordCollapseStrategy() {
        }

        @Override
        public void executeCollapse(CollapseDTO collapseDTO) {
            CollapseDataCollector collapseDataCollector = new CollapseDataCollector(collapseDTO);
            this.executeCollapseGeneric(collapseDTO, collapseDataCollector);
        }
    }

    private static class NumericCollapseStrategy
    extends CollapseStrategy {
        private NumericCollapseStrategy() {
        }

        @Override
        public void executeCollapse(CollapseDTO collapseDTO) {
            CollapseDataCollector collapseDataCollector = new CollapseDataCollector(collapseDTO);
            this.executeCollapseGeneric(collapseDTO, collapseDataCollector);
        }
    }
}

