/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.codec;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.opensearch.common.Nullable;
import org.opensearch.neuralsearch.sparse.cache.CacheKey;
import org.opensearch.neuralsearch.sparse.codec.SparseBinaryDocValuesPassThrough;
import org.opensearch.neuralsearch.sparse.codec.SparseDocValuesReader;
import org.opensearch.neuralsearch.sparse.codec.SparsePostingsEnum;
import org.opensearch.neuralsearch.sparse.codec.SparseTerms;
import org.opensearch.neuralsearch.sparse.common.MergeStateFacade;
import org.opensearch.neuralsearch.sparse.common.ValueEncoder;
import org.opensearch.neuralsearch.sparse.data.DocWeight;
import org.opensearch.neuralsearch.sparse.mapper.SparseVectorField;
import org.opensearch.neuralsearch.sparse.quantization.ByteQuantizationUtil;
import org.opensearch.neuralsearch.sparse.quantization.ByteQuantizer;

public class MergeHelper {
    @Generated
    private static final Logger log = LogManager.getLogger(MergeHelper.class);

    public void clearCacheData(@NonNull MergeStateFacade mergeStateFacade, @Nullable FieldInfo fieldInfo, @NonNull Consumer<CacheKey> consumer) throws IOException {
        Objects.requireNonNull(mergeStateFacade, "mergeStateFacade is marked non-null but is null");
        Objects.requireNonNull(consumer, "consumer is marked non-null but is null");
        for (DocValuesProducer producer : mergeStateFacade.getDocValuesProducers()) {
            for (FieldInfo field : mergeStateFacade.getMergeFieldInfos()) {
                BinaryDocValues binaryDocValues;
                boolean fieldInfoMisMatched;
                boolean isNotSparse = !SparseVectorField.isSparseField(field);
                boolean bl = fieldInfoMisMatched = fieldInfo != null && field != fieldInfo;
                if (isNotSparse || fieldInfoMisMatched || !((binaryDocValues = producer.getBinary(field)) instanceof SparseBinaryDocValuesPassThrough)) continue;
                SparseBinaryDocValuesPassThrough binaryDocValuesPassThrough = (SparseBinaryDocValuesPassThrough)binaryDocValues;
                CacheKey key = new CacheKey(binaryDocValuesPassThrough.getSegmentInfo(), field);
                consumer.accept(key);
            }
        }
    }

    public List<DocWeight> getMergedPostingForATerm(MergeStateFacade mergeStateFacade, BytesRef term, FieldInfo fieldInfo, int[] newIdToFieldProducerIndex, int[] newIdToOldId) throws IOException {
        ArrayList<DocWeight> docWeights = new ArrayList<DocWeight>();
        ByteQuantizer byteQuantizer = ByteQuantizationUtil.getByteQuantizerIngest(fieldInfo);
        for (int i = 0; i < mergeStateFacade.getFieldsProducers().length; ++i) {
            PostingsEnum postings;
            TermsEnum termsEnum;
            FieldsProducer fieldsProducer;
            Terms terms;
            BinaryDocValues binaryDocValues = mergeStateFacade.getDocValuesProducers()[i].getBinary(fieldInfo);
            if (!(binaryDocValues instanceof SparseBinaryDocValuesPassThrough) || (terms = (fieldsProducer = mergeStateFacade.getFieldsProducers()[i]).terms(fieldInfo.getName())) == null || (termsEnum = terms.iterator()) == null || !termsEnum.seekExact(term) || (postings = termsEnum.postings(null)) == null) continue;
            boolean isSparsePostings = postings instanceof SparsePostingsEnum;
            int docId = postings.nextDoc();
            while (docId != Integer.MAX_VALUE) {
                int newDocId;
                if (docId != -1 && (newDocId = mergeStateFacade.getDocMaps()[i].get(docId)) != -1) {
                    if (newDocId >= newIdToFieldProducerIndex.length) {
                        throw new IndexOutOfBoundsException("newDocId is larger than array size!");
                    }
                    newIdToFieldProducerIndex[newDocId] = i;
                    newIdToOldId[newDocId] = docId;
                    int freq = postings.freq();
                    byte freqByte = 0;
                    freqByte = isSparsePostings ? (byte)freq : byteQuantizer.quantize(ValueEncoder.decodeFeatureValue(freq));
                    docWeights.add(new DocWeight(newDocId, freqByte));
                }
                docId = postings.nextDoc();
            }
        }
        return docWeights;
    }

    public Set<BytesRef> getAllTerms(MergeStateFacade mergeStateFacade, FieldInfo fieldInfo) throws IOException {
        HashSet<BytesRef> allTerms = new HashSet<BytesRef>();
        for (int i = 0; i < mergeStateFacade.getFieldsProducers().length; ++i) {
            BytesRef term;
            FieldsProducer fieldsProducer = mergeStateFacade.getFieldsProducers()[i];
            BinaryDocValues binaryDocValues = mergeStateFacade.getDocValuesProducers()[i].getBinary(fieldInfo);
            if (!(binaryDocValues instanceof SparseBinaryDocValuesPassThrough)) continue;
            Terms terms = fieldsProducer.terms(fieldInfo.getName());
            if (terms instanceof SparseTerms) {
                SparseTerms sparseTerms = (SparseTerms)terms;
                allTerms.addAll(sparseTerms.getReader().getTerms());
                continue;
            }
            TermsEnum termsEnum = terms.iterator();
            while ((term = termsEnum.next()) != null) {
                allTerms.add(BytesRef.deepCopyOf((BytesRef)term));
            }
        }
        return allTerms;
    }

    public MergeStateFacade convertToMergeStateFacade(MergeState mergeState) {
        return new MergeStateFacade(mergeState);
    }

    public SparseDocValuesReader newSparseDocValuesReader(MergeStateFacade mergeStateFacade) {
        return new SparseDocValuesReader(mergeStateFacade);
    }

    @Generated
    public MergeHelper() {
    }
}

