from typing import Final

from pymeeus.Angle import Angle
from pymeeus.Epoch import Epoch

VSOP87_L: Final[list[list[list[float]]]]
VSOP87_B: Final[list[list[list[float]]]]
VSOP87_R: Final[list[list[list[float]]]]
ORBITAL_ELEM: Final[list[list[float]]]
ORBITAL_ELEM_J2000: Final[list[list[float]]]

class Saturn:
    @staticmethod
    def geometric_heliocentric_position(epoch: Epoch, tofk5: bool = True) -> tuple[Angle, Angle, float]: ...
    @staticmethod
    def apparent_heliocentric_position(epoch: Epoch) -> tuple[Angle, Angle, float]: ...
    @staticmethod
    def orbital_elements_mean_equinox(epoch: Epoch) -> tuple[Angle, float, float, Angle, Angle, Angle]: ...
    @staticmethod
    def orbital_elements_j2000(epoch: Epoch) -> tuple[Angle, float, float, Angle, Angle, Angle]: ...
    @staticmethod
    def geocentric_position(epoch: Epoch) -> tuple[Angle, Angle, Angle]: ...
    @staticmethod
    def conjunction(epoch: Epoch) -> Epoch: ...
    @staticmethod
    def opposition(epoch: Epoch) -> Epoch: ...
    @staticmethod
    def station_longitude_1(epoch: Epoch) -> Epoch: ...
    @staticmethod
    def station_longitude_2(epoch: Epoch) -> Epoch: ...
    @staticmethod
    def perihelion_aphelion(epoch: Epoch, perihelion: bool | None = True) -> Epoch: ...
    @staticmethod
    def passage_nodes(epoch: Epoch, ascending: bool = True) -> tuple[Epoch, float]: ...
    @staticmethod
    def magnitude(sun_dist: float, earth_dist: float, delta_U: float | Angle, B: float | Angle) -> float: ...
    @staticmethod
    def ring_inclination(epoch: Epoch) -> Angle: ...
    @staticmethod
    def ring_logitude_ascending_node(epoch: Epoch) -> Angle: ...
    @staticmethod
    def ring_parameters(epoch: Epoch) -> tuple[Angle, Angle, Angle, Angle, float, float]: ...

def main() -> None: ...
