/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateFormatCache {
    public static final char MSEC_PATTERN = '#';
    private final String format;
    private final int cacheSize;
    private final Cache cache;

    private String tidyFormat(String string) {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (bl || c != 'S') {
                stringBuilder.append(c);
            } else {
                stringBuilder.append('#');
            }
            if (c != '\'') continue;
            bl = !bl;
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateFormatCache(int n, String string, DateFormatCache dateFormatCache) {
        this.cacheSize = n;
        this.format = this.tidyFormat(string);
        Cache cache = null;
        if (dateFormatCache != null) {
            DateFormatCache dateFormatCache2 = dateFormatCache;
            synchronized (dateFormatCache2) {
                cache = dateFormatCache.cache;
            }
        }
        this.cache = new Cache(cache);
    }

    public String getFormat(long l) {
        return this.cache.getFormat(l);
    }

    public String getTimeFormat() {
        return this.format;
    }

    private class Cache {
        private long previousSeconds = Long.MIN_VALUE;
        private String previousFormat = "";
        private long first = Long.MIN_VALUE;
        private long last = Long.MIN_VALUE;
        private int offset = 0;
        private final Date currentDate = new Date();
        private final String[] cache;
        private final SimpleDateFormat formatter;
        private final Cache parent;

        private Cache(Cache cache) {
            this.cache = new String[DateFormatCache.this.cacheSize];
            this.formatter = new SimpleDateFormat(DateFormatCache.this.format, Locale.US);
            this.formatter.setTimeZone(TimeZone.getDefault());
            this.parent = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String getFormat(long l) {
            int n;
            long l2 = l / 1000L;
            if (l2 == this.previousSeconds) {
                return this.previousFormat;
            }
            this.previousSeconds = l2;
            int n2 = (this.offset + (int)(l2 - this.first)) % DateFormatCache.this.cacheSize;
            if (n2 < 0) {
                n2 += DateFormatCache.this.cacheSize;
            }
            if (l2 >= this.first && l2 <= this.last) {
                if (this.cache[n2] != null) {
                    this.previousFormat = this.cache[n2];
                    return this.previousFormat;
                }
            } else if (l2 >= this.last + (long)DateFormatCache.this.cacheSize || l2 <= this.first - (long)DateFormatCache.this.cacheSize) {
                this.first = l2;
                this.last = this.first + (long)DateFormatCache.this.cacheSize - 1L;
                n2 = 0;
                this.offset = 0;
                for (n = 1; n < DateFormatCache.this.cacheSize; ++n) {
                    this.cache[n] = null;
                }
            } else if (l2 > this.last) {
                n = 1;
                while ((long)n < l2 - this.last) {
                    this.cache[(n2 + ((DateFormatCache)DateFormatCache.this).cacheSize - n) % ((DateFormatCache)DateFormatCache.this).cacheSize] = null;
                    ++n;
                }
                this.first = l2 - (long)(DateFormatCache.this.cacheSize - 1);
                this.last = l2;
                this.offset = (n2 + 1) % DateFormatCache.this.cacheSize;
            } else {
                n = 1;
                while ((long)n < this.first - l2) {
                    this.cache[(n2 + n) % ((DateFormatCache)DateFormatCache.this).cacheSize] = null;
                    ++n;
                }
                this.first = l2;
                this.last = l2 + (long)(DateFormatCache.this.cacheSize - 1);
                this.offset = n2;
            }
            if (this.parent != null) {
                Cache cache = this.parent;
                synchronized (cache) {
                    this.previousFormat = this.parent.getFormat(l);
                }
            } else {
                this.currentDate.setTime(l);
                this.previousFormat = this.formatter.format(this.currentDate);
            }
            this.cache[n2] = this.previousFormat;
            return this.previousFormat;
        }
    }
}

