/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.alert;

import org.parosproxy.paros.common.AbstractParam;

public class AlertParam
extends AbstractParam {
    private static final String PARAM_BASE_KEY = "alert";
    private static final String PARAM_MERGE_RELATED_ISSUES = "alert.mergeissues";
    private static final String PARAM_MAXIMUM_INSTANCES = "alert.maxInstances";
    private static final String PARAM_OVERRIDES_FILENAME = "alert.overridesFilename";
    private static final String PARAM_SYSTEMIC_LIMIT = "alert.systemicLimit";
    private static final int DEFAULT_MAXIMUM_INSTANCES = 20;
    private static final int DEFAULT_SYSTEMIC_LIMIT = 5;
    private int maximumInstances = 20;
    private int systemicLimit = 5;
    private boolean mergeRelatedIssues = true;
    private String overridesFilename;

    @Override
    protected void parse() {
        this.maximumInstances = this.getInt(PARAM_MAXIMUM_INSTANCES, 20);
        this.systemicLimit = this.getInt(PARAM_SYSTEMIC_LIMIT, 5);
        this.mergeRelatedIssues = this.getBoolean(PARAM_MERGE_RELATED_ISSUES, true);
        this.overridesFilename = this.getString(PARAM_OVERRIDES_FILENAME, "");
    }

    public void setMaximumInstances(int maximumInstances) {
        int newValue;
        int n = newValue = maximumInstances < 0 ? 0 : maximumInstances;
        if (this.maximumInstances != newValue) {
            this.maximumInstances = newValue;
            this.getConfig().setProperty(PARAM_MAXIMUM_INSTANCES, (Object)this.maximumInstances);
        }
    }

    public int getMaximumInstances() {
        return this.maximumInstances;
    }

    public int getSystemicLimit() {
        return this.systemicLimit;
    }

    public void setSystemicLimit(int systemicLimit) {
        int newValue = Math.max(0, systemicLimit);
        if (this.systemicLimit != newValue) {
            this.systemicLimit = newValue;
            this.getConfig().setProperty(PARAM_SYSTEMIC_LIMIT, (Object)this.systemicLimit);
        }
    }

    public boolean isMergeRelatedIssues() {
        return this.mergeRelatedIssues;
    }

    public void setMergeRelatedIssues(boolean mergeRelatedIssues) {
        if (this.mergeRelatedIssues != mergeRelatedIssues) {
            this.mergeRelatedIssues = mergeRelatedIssues;
            this.getConfig().setProperty(PARAM_MERGE_RELATED_ISSUES, (Object)mergeRelatedIssues);
        }
    }

    public String getOverridesFilename() {
        return this.overridesFilename;
    }

    public void setOverridesFilename(String overridesFilename) {
        this.overridesFilename = overridesFilename;
        this.getConfig().setProperty(PARAM_OVERRIDES_FILENAME, (Object)overridesFilename);
    }
}

