/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration.Configuration;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.extension.Extension;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.SessionChangedListener;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.alert.ExtensionAlert;
import org.zaproxy.zap.extension.pscan.PassiveController;
import org.zaproxy.zap.extension.pscan.PassiveScanParam;
import org.zaproxy.zap.extension.pscan.PassiveScanRuleManager;
import org.zaproxy.zap.extension.pscan.PassiveScanTask;
import org.zaproxy.zap.extension.pscan.PassiveScanner;
import org.zaproxy.zap.extension.pscan.PassiveScannerList;
import org.zaproxy.zap.extension.pscan.PluginPassiveScanner;
import org.zaproxy.zap.extension.pscan.PolicyPassiveScanPanel;
import org.zaproxy.zap.view.ScanStatus;

public class ExtensionPassiveScan
extends ExtensionAdaptor
implements SessionChangedListener {
    public static final String NAME = "ExtensionPassiveScan";
    @Deprecated(forRemoval=true, since="2.16.0")
    public static final String SCRIPT_TYPE_PASSIVE = "passive";
    @Deprecated(forRemoval=true, since="2.16.0")
    public static final int PROXY_LISTENER_ORDER = 5001;
    private static final PassiveScanRuleManager NOOP_PASSIVE_SCAN_RULE_MANAGER = new PassiveScanRuleManager(){

        @Override
        public boolean add(PassiveScanner scanRule) {
            return false;
        }

        @Override
        public PassiveScanner getScanRule(int id) {
            return null;
        }

        @Override
        public List<PassiveScanner> getScanRules() {
            return null;
        }

        @Override
        public List<PluginPassiveScanner> getPluginScanRules() {
            return null;
        }

        @Override
        public boolean remove(PassiveScanner scanRule) {
            return false;
        }

        @Override
        public boolean remove(String className) {
            return false;
        }
    };
    private static final PassiveController NOOP_PASSIVE_CONTROLLER = new PassiveController(){

        @Override
        public int getRecordsToScan() {
            return 0;
        }

        @Override
        public void clearQueue() {
        }
    };
    private static final List<Class<? extends Extension>> DEPENDENCIES;
    private PassiveScanRuleManager scanRuleManager = NOOP_PASSIVE_SCAN_RULE_MANAGER;
    private PassiveController controller = NOOP_PASSIVE_CONTROLLER;

    public ExtensionPassiveScan() {
        this.setOrder(26);
        this.setName(NAME);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("pscan.name");
    }

    @Override
    public List<String> getActiveActions() {
        int recordsToScan = this.getRecordsToScan();
        if (recordsToScan == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> activeActions = new ArrayList<String>(1);
        activeActions.add(Constant.messages.getString("pscan.activeAction", recordsToScan));
        return activeActions;
    }

    public boolean removePassiveScanner(String className) {
        return this.scanRuleManager.remove(className);
    }

    public boolean addPassiveScanner(PassiveScanner passiveScanner) {
        return this.scanRuleManager.add(passiveScanner);
    }

    public boolean removePassiveScanner(PassiveScanner passiveScanner) {
        if (passiveScanner == null) {
            throw new IllegalArgumentException("Parameter passiveScanner must not be null.");
        }
        return this.removePassiveScanner(passiveScanner.getClass().getName());
    }

    public boolean addPluginPassiveScanner(PluginPassiveScanner pluginPassiveScanner) {
        return this.scanRuleManager.add(pluginPassiveScanner);
    }

    public boolean removePluginPassiveScanner(PluginPassiveScanner pluginPassiveScanner) {
        return this.scanRuleManager.remove(pluginPassiveScanner);
    }

    public void setPassiveScanRuleManager(PassiveScanRuleManager scanRuleManager) {
        this.scanRuleManager = scanRuleManager == null ? NOOP_PASSIVE_SCAN_RULE_MANAGER : scanRuleManager;
    }

    protected PassiveScanRuleManager getScanRuleManager() {
        return this.scanRuleManager;
    }

    protected PassiveScannerList getPassiveScannerList() {
        return new PassiveScannerList();
    }

    public List<PluginPassiveScanner> getPluginPassiveScanners() {
        return this.scanRuleManager.getPluginScanRules();
    }

    void setAllPluginPassiveScannersEnabled(boolean enabled) {
        for (PluginPassiveScanner scanner : this.getPluginPassiveScanners()) {
            scanner.setEnabled(enabled);
            scanner.save();
        }
    }

    void setPluginPassiveScannerEnabled(int pluginId, boolean enabled) {
        PluginPassiveScanner scanner = this.getPluginPassiveScanner(pluginId);
        if (scanner != null) {
            scanner.setEnabled(enabled);
            scanner.save();
        }
    }

    public PluginPassiveScanner getPluginPassiveScanner(int id) {
        for (PluginPassiveScanner scanner : this.getPluginPassiveScanners()) {
            if (id != scanner.getPluginId()) continue;
            return scanner;
        }
        return null;
    }

    boolean hasPluginPassiveScanner(int pluginId) {
        return this.getPluginPassiveScanner(pluginId) != null;
    }

    void setPluginPassiveScannerAlertThreshold(int pluginId, Plugin.AlertThreshold alertThreshold) {
        PluginPassiveScanner scanner = this.getPluginPassiveScanner(pluginId);
        if (scanner != null) {
            scanner.setAlertThreshold(alertThreshold);
            scanner.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)alertThreshold));
            scanner.save();
        }
    }

    public void setAllScannerThreshold(Plugin.AlertThreshold at) {
        for (PluginPassiveScanner test : this.getPluginPassiveScanners()) {
            test.setAlertThreshold(at);
            test.setEnabled(!Plugin.AlertThreshold.OFF.equals((Object)at));
            test.save();
        }
    }

    public Plugin.AlertThreshold getAllScannerThreshold() {
        Plugin.AlertThreshold at = null;
        for (PluginPassiveScanner test : this.getPluginPassiveScanners()) {
            if (at == null) {
                at = test.getAlertThreshold();
                continue;
            }
            if (at.equals((Object)test.getAlertThreshold())) continue;
            return null;
        }
        return at;
    }

    protected PolicyPassiveScanPanel getPolicyPanel() {
        return new PolicyPassiveScanPanel();
    }

    public void setPassiveController(PassiveController controller) {
        this.controller = controller == null ? NOOP_PASSIVE_CONTROLLER : controller;
    }

    @Deprecated(forRemoval=true, since="2.16.0")
    public int getRecordsToScan() {
        return this.controller.getRecordsToScan();
    }

    @Deprecated(forRemoval=true, since="2.16.0")
    public void clearQueue() {
        this.controller.clearQueue();
    }

    PassiveScanParam getPassiveScanParam() {
        return this.getModel().getOptionsParam().getParamSet(PassiveScanParam.class);
    }

    @Override
    public void sessionAboutToChange(Session session) {
    }

    @Override
    public void sessionChanged(Session session) {
    }

    @Deprecated
    public String getCurrentRuleName() {
        return null;
    }

    @Deprecated
    public String getCurrentUrl() {
        return null;
    }

    @Deprecated
    public long getCurrentRuleStartTime() {
        return 0L;
    }

    public PassiveScanTask getOldestRunningTask() {
        return null;
    }

    public List<PassiveScanTask> getRunningTasks() {
        return null;
    }

    @Override
    public List<Class<? extends Extension>> getDependencies() {
        return DEPENDENCIES;
    }

    @Override
    public void sessionScopeChanged(Session session) {
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    @Override
    public String getDescription() {
        return Constant.messages.getString("pscan.desc");
    }

    @Override
    public void sessionModeChanged(Control.Mode mode) {
    }

    @Deprecated(forRemoval=true, since="2.16.0")
    public void saveTo(Configuration conf) {
    }

    @Deprecated(forRemoval=true, since="2.16.0")
    public void loadFrom(Configuration conf) {
    }

    @Deprecated(forRemoval=true, since="2.16.0")
    protected ScanStatus getScanStatus() {
        return null;
    }

    @Override
    public boolean supportsLowMemory() {
        return true;
    }

    @Override
    public boolean supportsDb(String type) {
        return true;
    }

    static {
        ArrayList<Class<ExtensionAlert>> dep = new ArrayList<Class<ExtensionAlert>>(1);
        dep.add(ExtensionAlert.class);
        DEPENDENCIES = Collections.unmodifiableList(dep);
    }
}

