/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap;

import com.sun.xml.internal.bind.api.BridgeContext;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ContentType;
import com.sun.xml.internal.messaging.saaj.packaging.mime.internet.ParseException;
import com.sun.xml.internal.messaging.saaj.util.ByteInputStream;
import com.sun.xml.internal.ws.client.dispatch.DispatchContext;
import com.sun.xml.internal.ws.client.dispatch.impl.encoding.DispatchUtil;
import com.sun.xml.internal.ws.encoding.JAXWSAttachmentUnmarshaller;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.internal.ws.encoding.jaxb.RpcLitPayloadSerializer;
import com.sun.xml.internal.ws.encoding.soap.SOAPConstants;
import com.sun.xml.internal.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.BodyBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.encoding.soap.message.SOAPFaultInfo;
import com.sun.xml.internal.ws.handler.HandlerChainCaller;
import com.sun.xml.internal.ws.handler.HandlerContext;
import com.sun.xml.internal.ws.model.soap.SOAPRuntimeModel;
import com.sun.xml.internal.ws.pept.encoding.Decoder;
import com.sun.xml.internal.ws.pept.ept.MessageInfo;
import com.sun.xml.internal.ws.server.RuntimeContext;
import com.sun.xml.internal.ws.streaming.SourceReaderFactory;
import com.sun.xml.internal.ws.streaming.XMLReaderException;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderException;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.util.FastInfosetReflection;
import com.sun.xml.internal.ws.util.MessageInfoUtil;
import com.sun.xml.internal.ws.util.SOAPUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SOAPDecoder
implements Decoder {
    public static final String NOT_UNDERSTOOD_HEADERS = "not-understood soap headers";
    protected static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.soap.decoder");
    protected static final String MUST_UNDERSTAND_FAULT_MESSAGE_STRING = "SOAP must understand error";
    private static final String DUPLICATE_HEADER = "Duplicate Header in the message:";
    protected DispatchUtil dispatchUtil = new DispatchUtil();

    @Override
    public void decode(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void receiveAndDecode(MessageInfo messageInfo) {
        throw new UnsupportedOperationException();
    }

    public InternalMessage toInternalMessage(SOAPMessage sOAPMessage, MessageInfo messageInfo) {
        return null;
    }

    public Set<String> getRequiredRoles() {
        return new HashSet<String>();
    }

    public InternalMessage toInternalMessage(SOAPMessage sOAPMessage, InternalMessage internalMessage, MessageInfo messageInfo) {
        return null;
    }

    public SOAPMessage toSOAPMessage(MessageInfo messageInfo) {
        return null;
    }

    public void toMessageInfo(InternalMessage internalMessage, MessageInfo messageInfo) {
    }

    protected QName getEnvelopeTag() {
        return SOAPConstants.QNAME_SOAP_ENVELOPE;
    }

    protected QName getBodyTag() {
        return SOAPConstants.QNAME_SOAP_BODY;
    }

    protected QName getHeaderTag() {
        return SOAPConstants.QNAME_SOAP_HEADER;
    }

    protected QName getMUAttrQName() {
        return SOAPConstants.QNAME_MUSTUNDERSTAND;
    }

    protected QName getRoleAttrQName() {
        return SOAPConstants.QNAME_ROLE;
    }

    protected QName getFaultTag() {
        return SOAPConstants.QNAME_SOAP_FAULT;
    }

    protected QName getFaultDetailTag() {
        return SOAPConstants.QNAME_SOAP_FAULT_DETAIL;
    }

    protected void skipBody(XMLStreamReader xMLStreamReader) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getBodyTag());
        XMLStreamReaderUtil.skipElement(xMLStreamReader);
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
    }

    protected void skipHeader(XMLStreamReader xMLStreamReader, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        if (!this.isDispatch(messageInfo)) {
            return;
        }
        if (!"Header".equals(xMLStreamReader.getLocalName())) {
            return;
        }
        this.dispatchUtil.collectPrefixes(xMLStreamReader);
        XMLStreamReaderUtil.skipElement(xMLStreamReader);
        try {
            xMLStreamReader.next();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected boolean skipHeader(MessageInfo messageInfo) {
        return messageInfo.getMetaData("com.sun.xml.internal.ws.rt.client.dispatch.mode") == Service.Mode.PAYLOAD;
    }

    protected void decodeEnvelope(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, boolean bl, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        if (this.skipHeader(messageInfo)) {
            this.skipHeader(xMLStreamReader, messageInfo);
        } else {
            this.decodeHeader(xMLStreamReader, messageInfo, internalMessage);
        }
        if (bl) {
            this.skipBody(xMLStreamReader);
        } else {
            this.decodeBody(xMLStreamReader, internalMessage, messageInfo);
        }
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 8);
    }

    protected void decodeHeader(XMLStreamReader xMLStreamReader, MessageInfo messageInfo, InternalMessage internalMessage) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        if (!"Header".equals(xMLStreamReader.getLocalName())) {
            return;
        }
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getHeaderTag());
        if (this.isDispatch(messageInfo)) {
            this.dispatchUtil.collectPrefixes(xMLStreamReader);
        }
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        while (xMLStreamReader.getEventType() == 1) {
            this.decodeHeaderElement(xMLStreamReader, messageInfo, internalMessage);
        }
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getHeaderTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
    }

    protected void decodeHeaderElement(XMLStreamReader xMLStreamReader, MessageInfo messageInfo, InternalMessage internalMessage) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        if (runtimeContext == null) {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
            return;
        }
        BridgeContext bridgeContext = runtimeContext.getBridgeContext();
        Set<QName> set = ((SOAPRuntimeModel)runtimeContext.getModel()).getKnownHeaders();
        QName qName = xMLStreamReader.getName();
        if (set != null && set.contains(qName)) {
            Object object;
            QName qName2 = xMLStreamReader.getName();
            if (internalMessage.isHeaderPresent(qName)) {
                this.raiseFault(this.getSenderFaultCode(), DUPLICATE_HEADER + qName2);
            }
            if ((object = runtimeContext.getDecoderInfo(qName)) != null && object instanceof JAXBBridgeInfo) {
                JAXBBridgeInfo jAXBBridgeInfo = (JAXBBridgeInfo)object;
                jAXBBridgeInfo.deserialize(xMLStreamReader, bridgeContext);
                HeaderBlock headerBlock = new HeaderBlock(jAXBBridgeInfo);
                internalMessage.addHeader(headerBlock);
            }
        } else {
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
    }

    protected void decodeBody(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getBodyTag());
        int n = XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        this.decodeBodyContent(xMLStreamReader, internalMessage, messageInfo);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getBodyTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
    }

    protected void decodeBodyContent(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, MessageInfo messageInfo) {
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        BridgeContext bridgeContext = runtimeContext.getBridgeContext();
        this.decodeDispatchMethod(xMLStreamReader, internalMessage, messageInfo);
        if (xMLStreamReader.getEventType() == 1) {
            QName qName = xMLStreamReader.getName();
            if (qName.getNamespaceURI().equals(this.getEnvelopeTag().getNamespaceURI()) && qName.getLocalPart().equals("Fault")) {
                SOAPFaultInfo sOAPFaultInfo = this.decodeFault(xMLStreamReader, internalMessage, messageInfo);
                BodyBlock bodyBlock = new BodyBlock(sOAPFaultInfo);
                internalMessage.setBody(bodyBlock);
            } else {
                Object object = runtimeContext.getDecoderInfo(qName);
                if (object != null && object instanceof JAXBBridgeInfo) {
                    JAXBBridgeInfo jAXBBridgeInfo = (JAXBBridgeInfo)object;
                    jAXBBridgeInfo.deserialize(xMLStreamReader, bridgeContext);
                    BodyBlock bodyBlock = new BodyBlock(jAXBBridgeInfo);
                    internalMessage.setBody(bodyBlock);
                } else if (object != null && object instanceof RpcLitPayload) {
                    RpcLitPayload rpcLitPayload = (RpcLitPayload)object;
                    RpcLitPayloadSerializer.deserialize(xMLStreamReader, rpcLitPayload, bridgeContext);
                    BodyBlock bodyBlock = new BodyBlock(rpcLitPayload);
                    internalMessage.setBody(bodyBlock);
                }
            }
        }
    }

    public void decodeDispatchMethod(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, MessageInfo messageInfo) {
    }

    protected SOAPFaultInfo decodeFault(XMLStreamReader xMLStreamReader, InternalMessage internalMessage, MessageInfo messageInfo) {
        return null;
    }

    protected void convertBodyBlock(InternalMessage internalMessage, MessageInfo messageInfo) {
        Object object;
        BodyBlock bodyBlock = internalMessage.getBody();
        if (bodyBlock != null && !((object = bodyBlock.getValue()) instanceof JAXBBridgeInfo) && !(object instanceof RpcLitPayload)) {
            if (object instanceof Source) {
                Source source = (Source)object;
                XMLStreamReader xMLStreamReader = SourceReaderFactory.createSourceReader(source, true);
                XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
                this.decodeBodyContent(xMLStreamReader, internalMessage, messageInfo);
            } else {
                throw new WebServiceException("Shouldn't happen. Unknown type in BodyBlock =" + object.getClass());
            }
        }
    }

    protected void processAttachments(MessageInfo messageInfo, InternalMessage internalMessage, SOAPMessage sOAPMessage) throws SOAPException, ParseException, IOException {
        Object object;
        Iterator iterator = sOAPMessage.getAttachments();
        if (iterator.hasNext()) {
            object = null;
            if (MessageInfoUtil.getRuntimeContext(messageInfo) != null) {
                object = (JAXWSAttachmentUnmarshaller)MessageInfoUtil.getRuntimeContext(messageInfo).getBridgeContext().getAttachmentUnmarshaller();
            } else {
                Unmarshaller unmarshaller = (Unmarshaller)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.unmarshaller");
                if (unmarshaller != null) {
                    object = (JAXWSAttachmentUnmarshaller)unmarshaller.getAttachmentUnmarshaller();
                }
            }
            if (object != null) {
                ((JAXWSAttachmentUnmarshaller)object).setXOPPackage(this.isXOPPackage(sOAPMessage));
                ((JAXWSAttachmentUnmarshaller)object).setAttachments(internalMessage.getAttachments());
            }
        }
        while (iterator.hasNext()) {
            object = (AttachmentPart)iterator.next();
            internalMessage.addAttachment(AttachmentBlock.fromSAAJ((AttachmentPart)object));
        }
    }

    private boolean isXOPPackage(SOAPMessage sOAPMessage) throws ParseException {
        String string;
        String string2 = this.getContentType(sOAPMessage.getSOAPPart());
        ContentType contentType = new ContentType(string2);
        String string3 = contentType.getPrimaryType();
        String string4 = contentType.getSubType();
        return string3.equalsIgnoreCase("application") && string4.equalsIgnoreCase("xop+xml") && ((string = contentType.getParameter("type")).toLowerCase().startsWith("text/xml") || string.toLowerCase().startsWith("application/soap+xml"));
    }

    private String getContentType(SOAPPart sOAPPart) {
        String[] stringArray = sOAPPart.getMimeHeader("Content-Type");
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    public boolean doMustUnderstandProcessing(SOAPMessage sOAPMessage, MessageInfo messageInfo, HandlerContext handlerContext, boolean bl) throws SOAPException, IOException {
        try {
            Object object;
            boolean bl2 = false;
            Source source = sOAPMessage.getSOAPPart().getContent();
            ByteInputStream byteInputStream = null;
            if (source instanceof StreamSource) {
                object = (StreamSource)source;
                InputStream inputStream = ((StreamSource)object).getInputStream();
                if (inputStream != null && inputStream instanceof ByteInputStream) {
                    byteInputStream = (ByteInputStream)inputStream;
                } else {
                    logger.fine("SAAJ StreamSource doesn't have ByteInputStream " + inputStream);
                }
            } else if (FastInfosetReflection.isFastInfosetSource(source)) {
                try {
                    byteInputStream = (ByteInputStream)FastInfosetReflection.FastInfosetSource_getInputStream(source);
                }
                catch (Exception exception) {
                    throw new XMLReaderException("fastinfoset.noImplementation", new Object[0]);
                }
            } else {
                logger.fine("Inefficient Use - SOAPMessage is already parsed");
            }
            object = SourceReaderFactory.createSourceReader(source, true);
            XMLStreamReaderUtil.nextElementContent((XMLStreamReader)object);
            this.checkMustUnderstandHeaders((XMLStreamReader)object, messageInfo, handlerContext);
            if (bl) {
                bl2 = this.isOneway((XMLStreamReader)object, messageInfo);
            }
            XMLStreamReaderUtil.close((XMLStreamReader)object);
            if (byteInputStream != null) {
                byteInputStream.close();
            }
            return bl2;
        }
        catch (XMLStreamReaderException xMLStreamReaderException) {
            this.raiseBadXMLFault(handlerContext);
            throw xMLStreamReaderException;
        }
    }

    private boolean isOneway(XMLStreamReader xMLStreamReader, MessageInfo messageInfo) {
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getBodyTag());
        int n = XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        QName qName = null;
        if (n == 1) {
            qName = xMLStreamReader.getName();
        }
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        runtimeContext.setMethodAndMEP(qName, messageInfo);
        return messageInfo.getMEP() == 2;
    }

    private void checkMustUnderstandHeaders(XMLStreamReader xMLStreamReader, MessageInfo messageInfo, HandlerContext handlerContext) {
        SOAPRuntimeModel sOAPRuntimeModel;
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        QName qName = xMLStreamReader.getName();
        QName qName2 = this.getEnvelopeTag();
        if (qName.getLocalPart().equals(qName2.getLocalPart()) && !qName.getNamespaceURI().equals(qName2.getNamespaceURI())) {
            this.raiseFault(this.getVersionMismatchFaultCode(), "Invalid SOAP envelope version");
        }
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getEnvelopeTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 1);
        if (!"Header".equals(xMLStreamReader.getLocalName())) {
            return;
        }
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getHeaderTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        RuntimeContext runtimeContext = MessageInfoUtil.getRuntimeContext(messageInfo);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.getRequiredRoles());
        HandlerChainCaller handlerChainCaller = MessageInfoUtil.getHandlerChainCaller(messageInfo);
        if (handlerChainCaller != null) {
            hashSet.addAll(handlerChainCaller.getRoles());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("roles:");
            for (String iterator2 : hashSet) {
                logger.finest("\t\"" + iterator2 + "\"");
            }
        }
        HashSet<QName> hashSet2 = null;
        if (runtimeContext != null && (sOAPRuntimeModel = (SOAPRuntimeModel)runtimeContext.getModel()) != null && sOAPRuntimeModel.getKnownHeaders() != null) {
            hashSet2 = new HashSet<QName>(((SOAPRuntimeModel)runtimeContext.getModel()).getKnownHeaders());
        }
        if (hashSet2 == null) {
            if (handlerChainCaller != null) {
                hashSet2 = handlerChainCaller.getUnderstoodHeaders();
            }
        } else if (handlerChainCaller != null) {
            hashSet2.addAll(handlerChainCaller.getUnderstoodHeaders());
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("understood headers:");
            if (hashSet2 == null || hashSet2.isEmpty()) {
                logger.finest("\tnone");
            } else {
                for (QName qName3 : hashSet2) {
                    logger.finest("\t" + qName3.toString());
                }
            }
        }
        this.checkHeadersAgainstKnown(xMLStreamReader, hashSet, (Set<QName>)hashSet2, messageInfo);
        XMLStreamReaderUtil.verifyReaderState(xMLStreamReader, 2);
        XMLStreamReaderUtil.verifyTag(xMLStreamReader, this.getHeaderTag());
        XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
    }

    protected void checkHeadersAgainstKnown(XMLStreamReader xMLStreamReader, Set<String> set, Set<QName> set2, MessageInfo messageInfo) {
        while (xMLStreamReader.getEventType() == 1) {
            String string;
            QName qName = xMLStreamReader.getName();
            String string2 = xMLStreamReader.getAttributeValue(this.getMUAttrQName().getNamespaceURI(), this.getMUAttrQName().getLocalPart());
            if (string2 != null && (string2.equals("1") || string2.equalsIgnoreCase("true")) && (string = xMLStreamReader.getAttributeValue(this.getRoleAttrQName().getNamespaceURI(), this.getRoleAttrQName().getLocalPart())) != null && set.contains(string)) {
                logger.finest("Element=" + qName + " targeted at=" + string);
                if (set2 == null || !set2.contains(qName)) {
                    logger.finest("Element not understood=" + qName);
                    SOAPFault sOAPFault = SOAPUtil.createSOAPFault(MUST_UNDERSTAND_FAULT_MESSAGE_STRING, SOAPConstants.FAULT_CODE_MUST_UNDERSTAND, string, null, "http://schemas.xmlsoap.org/wsdl/soap/http");
                    throw new SOAPFaultException(sOAPFault);
                }
            }
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            XMLStreamReaderUtil.nextElementContent(xMLStreamReader);
        }
    }

    protected boolean isDispatch(MessageInfo messageInfo) {
        DispatchContext dispatchContext = (DispatchContext)messageInfo.getMetaData("com.sun.xml.internal.ws.client.dispatch.context");
        return dispatchContext != null;
    }

    protected String getSOAPMessageCharsetEncoding(SOAPMessage sOAPMessage) throws SOAPException {
        String string = (String)sOAPMessage.getProperty("javax.xml.soap.character-set-encoding");
        return string != null ? string : "UTF-8";
    }

    protected final void raiseFault(QName qName, String string) {
        throw new SOAPFaultException(SOAPUtil.createSOAPFault(string, qName, null, null, this.getBindingId()));
    }

    protected void raiseBadXMLFault(HandlerContext handlerContext) {
    }

    protected abstract QName getSenderFaultCode();

    protected abstract QName getReceiverFaultCode();

    protected abstract QName getVersionMismatchFaultCode();

    public abstract String getBindingId();

    public DispatchUtil getDispatchUtil() {
        return this.dispatchUtil;
    }
}

