/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.util.LinkedList;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.FileDispatcher;

class EPollArrayWrapper {
    static final int EPOLLIN = 1;
    static final int EPOLL_CTL_ADD = 1;
    static final int EPOLL_CTL_DEL = 2;
    static final int EPOLL_CTL_MOD = 3;
    static final short SIZE_EPOLLEVENT = 12;
    static final short EVENT_OFFSET = 0;
    static final short DATA_OFFSET = 4;
    static final short FD_OFFSET = 4;
    static final int NUM_EPOLLEVENTS = Math.min(EPollArrayWrapper.fdLimit(), 8192);
    private long pollArrayAddress;
    private LinkedList<Updator> updateList = new LinkedList();
    private AllocatedNativeObject pollArray;
    int epfd = this.epollCreate();
    int outgoingInterruptFD;
    int incomingInterruptFD;
    int interruptedIndex;
    int updated;
    boolean interrupted = false;

    EPollArrayWrapper() {
        int n = NUM_EPOLLEVENTS * 12;
        this.pollArray = new AllocatedNativeObject(n, true);
        this.pollArrayAddress = this.pollArray.address();
        for (int i = 0; i < NUM_EPOLLEVENTS; ++i) {
            this.putEventOps(i, 0);
            this.putData(i, 0L);
        }
    }

    void initInterrupt(int n, int n2) {
        this.outgoingInterruptFD = n2;
        this.incomingInterruptFD = n;
        this.epollCtl(this.epfd, 1, n, 1);
    }

    void putEventOps(int n, int n2) {
        int n3 = 12 * n + 0;
        this.pollArray.putInt(n3, n2);
    }

    void putData(int n, long l) {
        int n2 = 12 * n + 4;
        this.pollArray.putLong(n2, l);
    }

    void putDescriptor(int n, int n2) {
        int n3 = 12 * n + 4;
        this.pollArray.putInt(n3, n2);
    }

    int getEventOps(int n) {
        int n2 = 12 * n + 0;
        return this.pollArray.getInt(n2);
    }

    int getDescriptor(int n) {
        int n2 = 12 * n + 4;
        return this.pollArray.getInt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setInterest(int n, int n2) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            if (this.updateList.size() > 0) {
                Updator updator = this.updateList.getLast();
                if (updator.fd == n && updator.opcode == 1) {
                    updator.events = n2;
                    return;
                }
            }
            this.updateList.add(new Updator(3, n, n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(int n) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Updator(1, n, 0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void release(int n) {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            this.updateList.add(new Updator(2, n, 0));
        }
    }

    void closeEPollFD() throws IOException {
        FileDispatcher.closeIntFD(this.epfd);
        this.pollArray.free();
    }

    int poll(long l) throws IOException {
        this.updateRegistrations();
        this.updated = this.epollWait(this.pollArrayAddress, NUM_EPOLLEVENTS, l, this.epfd);
        for (int i = 0; i < this.updated; ++i) {
            if (this.getDescriptor(i) != this.incomingInterruptFD) continue;
            this.interruptedIndex = i;
            this.interrupted = true;
            break;
        }
        return this.updated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateRegistrations() {
        LinkedList<Updator> linkedList = this.updateList;
        synchronized (linkedList) {
            Updator updator = null;
            while ((updator = this.updateList.poll()) != null) {
                this.epollCtl(this.epfd, updator.opcode, updator.fd, updator.events);
            }
        }
    }

    public void interrupt() {
        EPollArrayWrapper.interrupt(this.outgoingInterruptFD);
    }

    public int interruptedIndex() {
        return this.interruptedIndex;
    }

    boolean interrupted() {
        return this.interrupted;
    }

    void clearInterrupted() {
        this.interrupted = false;
    }

    private native int epollCreate();

    private native void epollCtl(int var1, int var2, int var3, int var4);

    private native int epollWait(long var1, int var3, long var4, int var6) throws IOException;

    private static native int fdLimit();

    private static native void interrupt(int var0);

    private static native void init();

    static {
        EPollArrayWrapper.init();
    }

    private static class Updator {
        int opcode;
        int fd;
        int events;

        Updator(int n, int n2, int n3) {
            this.opcode = n;
            this.fd = n2;
            this.events = n3;
        }
    }
}

