------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                  A D A . N U M E R I C S _ R A N D O M                   --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  with Ada.Finalization; use Ada.Finalization;
package Ada.Numerics.Random_Numbers is

   pragma Elaborate_Body;

   type Generator is limited private;
   --  subtype Uniformly_Distributed is Float range 0.0 .. 1.0;
   subtype Uniformly_Distributed is Float;

   function Random (Gen : Generator) return Uniformly_Distributed;
   function Random_Integer (Gen       : Generator;
                            Low, High : Integer) return Integer;

   procedure Reset (Gen       : in Generator;
                    Initiator : in Integer);
   procedure Reset (Gen       : in Generator);

private

   Larger_Lag  : constant := 25;
   Smaller_Lag : constant := 11;
   type Lag_Range is mod Larger_Lag;
   type State_Vector is array (Lag_Range) of Float;
   type Internal_State is
      record
         Lagged_Outputs : State_Vector;
         Borrow         : Float;
         R, S           : Lag_Range;
      end record;
   type Access_State is access Internal_State;
   Initial_State : Internal_State;
   type Generator is
      --  new Limited_Controlled with
      record
         State : Access_State := new Internal_State'(Initial_State);
      end record;
   --  procedure Finalize (Gen : in out Generator);

end Ada.Numerics.Random_Numbers;
