/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                             M K T T Y P E F                              */
/*                                                                          */
/*                             Utility Program                              */
/*                                                                          */
/*                            $Revision: 1.9 $                              */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* Program to construct ttypef.ads from the template file ttypef.adt */

#include "hconfig.h"
#include "machmode.h"
#include "real.h"
#include <stdio.h>

/* Provide default values for all of the floating-point type widths
   (copied from c-decl.c).  */

#ifndef FLOAT_TYPE_SIZE
#define FLOAT_TYPE_SIZE BITS_PER_WORD
#endif

#ifndef DOUBLE_TYPE_SIZE
#define DOUBLE_TYPE_SIZE (BITS_PER_WORD * 2)
#endif

#ifndef LONG_DOUBLE_TYPE_SIZE
#define LONG_DOUBLE_TYPE_SIZE (BITS_PER_WORD * 2)
#endif

/* Map attribute in template into string value.  */

#define NUM_FLOAT_TYPES (4)
struct {char *attr, *(string[NUM_FLOAT_TYPES]);} attribute_map[]

  = {{"DN", {"True", "True", "True", "True"}}, /* Denorm  */

/*   {"EP", {"2.0 ** (-23)",              "2.0 ** (-52)",
		 "2.0 ** (-63)",  "2.0 ** (-113)"}}, /* Epsilon  */
     {"EP", {"1.19209289550781250000e-7", "2.220446049250313080847e-16",
		 "1.08420217248550443401e-19",
		 "9.62964972193617926527988971292e-35"}}, /* Epsilon  */

     {"EX", {"128", "1024", "16384", "16384"}}, /* Emax  */

/*   {"FS", {"-(1.0-2.0**(-24)) * 2.0**128",  "-(1.0-2.0**(-53)) * 2.0**1024",
		 "-(1.0-2.0**(-64)) * 2.0**16384",
		 "-(1.0-2.0**(-113)) * 2.0**16384"}}, /* First  */
     {"FS", {"-3.40282346638528859812e38",    "-1.797693134862315708145e308",
		 "-1.18973149535723176502e4932",
		 "-1.189731495357231765085759326628e4932"}}, /* First  */

/*   {"LG", {"(1.0-2.0**(-24)) * 2.0**128",  "(1.0-2.0**(-53)) * 2.0**1024",
		 "(1.0-2.0**(-64)) * 2.0**16384",
		 "(1.0-2.0**(-113)) * 2.0**16384"}}, /* Large  */
     {"LG", {"3.40282346638528859812e38",    "1.797693134862315708145e308",
		 "1.18973149535723176502e4932",
		 "1.189731495357231765085759326628e4932"}}, /* Large  */

/*   {"LS", {"(1.0-2.0**(-24)) * 2.0**128",  "(1.0-2.0**(-53)) * 2.0**1024",
		 "(1.0-2.0**(-64)) * 2.0**16384",
		 "(1.0-2.0**(-113)) * 2.0**16384"}}, /* Last  */
     {"LS", {"3.40282346638528859812e38",    "1.797693134862315708145e308",
		 "1.18973149535723176502e4932",
		 "1.189731495357231765085759326628e4932"}}, /* Last  */

     {"MA", {"24", "53", "64", "113"}}, /* Mantissa  */

     {"MM", {"24", "53", "64", "113"}}, /* Machine_Mantissa  */

     {"MN", {"-125", "-1021", "-16381", "-16381"}}, /* Machine_Emin  */

     {"MO", {"False", "False", "False", "False"}}, /* Machine_Overflows  */

     {"MR", {"2", "2", "2", "2"}}, /* Machine_Radix  */

     {"MX", {"128", "1024", "16384", "16384"}}, /* Machine_Emax  */

/*   {"OE", {"2.0 ** (-23)",              "2.0 ** (-52)",
		 "2.0 ** (-63)",  "2.0 ** (-113)"}}, /* Model_Epsilon  */
     {"OE", {"1.19209289550781250000e-7", "2.220446049250313080847e-16",
		 "1.08420217248550443401e-19",
		 "9.62964972193617926527988971292e-35"}}, /* Model_Epsilon  */

     {"OM", {"24", "53", "64", "113"}}, /* Model_Mantissa  */

     {"ON", {"-125", "-1021", "-16381", "-16381"}}, /* Model_Emin  */

/*   {"OS", {"2.0 ** (-126)",              "2.0 ** (-1022)",
		 "2.0 ** (-16381)",  "2.0 ** (-16381)"}}, /* Model_Small  */
     {"OS", {"1.17549435082228750797e-38", "2.22507385850720138309e-308",
		 "3.36210314311209350626e-4932",
		 "3.36210314311209350626267781732e-4932"}}, /* Model_Small  */

     {"RN", {"True", "True", "True", "True"}}, /* Machine_Rounds  */

/*   {"SF", {"-(1.0-2.0**(-24)) * 2.0**128",  "-(1.0-2.0**(-53)) * 2.0**1024",
		 "-(1.0-2.0**(-64)) * 2.0**16384",
		 "-(1.0-2.0**(-113)) * 2.0**16384"}}, /* Safe_First  */
     {"SF", {"-3.40282346638528859812e38",    "-1.797693134862315708145e308",
		 "-1.18973149535723176502e4932",
		 "-1.189731495357231765085759326628e4932"}}, /* Safe_First  */

/*   {"SL", {"(1.0-2.0**(-24)) * 2.0**128",  "(1.0-2.0**(-53)) * 2.0**1024",
		 "(1.0-2.0**(-64)) * 2.0**16384",
		 "(1.0-2.0**(-113)) * 2.0**16384"}}, /* Safe_Large  */
     {"SL", {"3.40282346638528859812e38",    "1.797693134862315708145e308",
		 "1.18973149535723176502e4932",
		 "1.189731495357231765085759326628e4932"}}, /* Safe_Large  */

/*   {"SM", {"2.0 ** (-126)",              "2.0 ** (-1022)",
		 "2.0 ** (-16381)",  "2.0 ** (-16381)"}}, /* Safe_Small  */
     {"SM", {"1.17549435082228750797e-38", "2.22507385850720138309e-308",
		 "3.36210314311209350626e-4932",
		 "3.36210314311209350626267781732e-4932"}}, /* Safe_Small  */

/*   {"SS", {"(1.0-2.0**(-24)) * 2.0**128",  "(1.0-2.0**(-53)) * 2.0**1024",
		 "(1.0-2.0**(-64)) * 2.0**16384",
		 "(1.0-2.0**(-113)) * 2.0**16384"}}, /* Safe_Last  */
     {"SS", {"3.40282346638528859812e38",    "1.797693134862315708145e308",
		 "1.18973149535723176502e4932",
		 "1.189731495357231765085759326628e4932"}}, /* Safe_Last  */

     {"SX", {"128", "1024", "16384", "16384"}}, /* Safe_Emax  */

     {"SZ", {"True", "True", "True", "True"}}}; /* Signed_Zeros  */

#define NUM_ATTRS sizeof attribute_map / sizeof attribute_map[0]
#define UNKNOWN_FLOAT_TYPE (-1)

int
main (argc, argv)
     int argc;
     char **argv;
{
  FILE *infile;
  int c, exit_code = SUCCESS_EXIT_CODE;

  if (TARGET_FLOAT_FORMAT != IEEE_FLOAT_FORMAT)
    {
      fprintf (stderr, "Don't know how to handle this float format");
      exit_code = FATAL_EXIT_CODE;
    }

  if (FLOAT_TYPE_SIZE != 32)
    {
      fprintf (stderr,
 "The characteristics of a float type of size %d bits are unknown",
	  FLOAT_TYPE_SIZE);
      exit_code = FATAL_EXIT_CODE;
    }

  if (DOUBLE_TYPE_SIZE != 64)
    {
      fprintf (stderr,
 "The characteristics of a double float type of size %d bits are unknown",
	  DOUBLE_TYPE_SIZE);
      exit_code = FATAL_EXIT_CODE;
    }

  if (LONG_DOUBLE_TYPE_SIZE != 64 && LONG_DOUBLE_TYPE_SIZE != 96
      && LONG_DOUBLE_TYPE_SIZE != 128)
    {
      fprintf (stderr,
 "The characteristics of a long double float type of size %d bits are unknown",
	  LONG_DOUBLE_TYPE_SIZE);
      exit_code = FATAL_EXIT_CODE;
    }

  if (exit_code != SUCCESS_EXIT_CODE)
    {
      fprintf (stderr,
	  " -\nyou must create ttypef.ads by some other means.\n");
      exit (exit_code);
    }

  infile = fopen (argv[1], "r");
  if (infile == 0)
    {
      perror (argv[1]);
      exit (FATAL_EXIT_CODE);
    }

  /* Read the entire file doing something special when we hit a "%".  */
  while ((c = getc (infile)) != EOF)
    {
      if (c != '%')
	putchar (c);
      else
	{
	  int float_type, c1, c2, i;
	  char *value;

	  /* Get the prefix.  */
	  c = getc (infile);
	  switch (c)
	    {
	    case 'f': /* FLOAT  */
	    case 'F': /* SHORT_FLOAT  */
	      float_type = 0;
	      break;

	    case 'd':
	      float_type = 1; /* LONG_FLOAT  */
	      break;

	    case 'D':
	      /* LONG_LONG_FLOAT  */
	      float_type = LONG_DOUBLE_TYPE_SIZE == 64 ? 1
			     : LONG_DOUBLE_TYPE_SIZE == 96 ? 2
			     : LONG_DOUBLE_TYPE_SIZE == 128 ? 3
			     : UNKNOWN_FLOAT_TYPE;
	      break;

	    default:
	      fprintf (stderr, "Unknown prefix character '%c'\n", c);
	      exit (FATAL_EXIT_CODE);
	    }

	  /* Scan the attribute map to get the attribute.  */
	  c1 = getc (infile); c2 = getc (infile);
	  value = NULL;
	  for (i = 0; i < NUM_ATTRS; i++)
	    if (attribute_map[i].attr[0] == c1
		&& attribute_map[i].attr[1] == c2)
	      if (float_type >= 0 && float_type < NUM_FLOAT_TYPES)
		value = attribute_map[i].string[float_type];

	  if (value == NULL)
	    {
	      fprintf (stderr, "Unknown attribute \"%c%c\"\n", c1, c2);
	      exit (FATAL_EXIT_CODE);
	    }

	  else printf ("%s", value);
	}
    }

  fflush (stdout);
  exit (ferror (stdout) != 0 ? FATAL_EXIT_CODE : SUCCESS_EXIT_CODE);
  /* NOTREACHED */
  return 0;
}
