------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                    S Y S T E M . E N V I R O N M E N T                   --
--                                                                          --
--                                 B o d y                                  --
--                              (UNIX Version)                              --
--                                                                          --
--                            $Revision: 1.10 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

package body System.Environment is

   Args : array (0 .. Arg_Count - 1) of Arg_Ptr;

   procedure Fill_Arg (A : System.Address; Arg_Num : Integer);
   pragma Interface (C, Fill_Arg);

   function Len_Arg (Arg_Num : Integer) return Integer;
   pragma Interface (C, Len_Arg);

   function Arg_Value (Arg_Num : Natural) return Arg_Ptr is
   begin
      return Args (Arg_Num);
   end Arg_Value;

begin

   for J in Args'range loop
      Args (J) := new String (1 .. Len_Arg (J));
      Fill_Arg (Args (J).all'Address, J);
   end loop;

end System.Environment;
