/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file clos_lf4.c */

#include "clos.h"

char *str2up();

/************ Manipolazione Stringhe **************/
/* STR2REAL , STR2INT , STR2NAME , STRING-EQUAL   */
/* STRING-EQ, STRINGP , STRCAT   , STRSUB	  */
/* STR2ASCII, STRNUM  , STRLEN	 , STRPRINTF	  */
/**************************************************/

/* sintassi (STR2REAL <stringa>) 		     */
/* ritorna un reale oppure il simbolo *SYNTAX_ERROR* */
void lf_str2real LF_PARAMS
{
 n_real d;
 char *ptr;
 node n;
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=CONSRIGHT(nin);
   n=calc_pointer(nout);
   if(IS_VALUE(n) && GET_VTYPE(n)==NT_STRING){
     string_get(STRING(n),buf1);
     d=strtod(buf1,&ptr);
     while(*ptr==' ')ptr++; /* salta gli spazi finali */
     if(*ptr==0){ /* XENIX non ha HUGE_VAL && d!=HUGE_VAL){ */
       TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_REAL;
       REAL(nout->node)=d;
       nout->type=P_ALLNODE;
     }else{
       nout->node=node_alloc(PARSE_ERROR_ID);
       nout->type=P_ALLNODE;
     }
     return;
   }
   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

/* sintassi (STR2INT <stringa> <intero base>? )	      */
/* ritorna un intero oppure il simbolo *SYNTAX_ERROR* */
/* la base 
 opzionale (default 10) e va da 2 a 32    */
void lf_str2int LF_PARAMS
{
 n_int i;
 char *ptr;
 node n,nr;
 int radix=10;
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   nin=CONSRIGHT(nin);
   n=calc_pointer(nout);
   if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=CONSRIGHT(nin);
     nr=calc_pointer(nout);
     if(IS_VALUE(nr) && GET_VTYPE(nr)==NT_INTEGER){
       if(INTEGER(nr)<=32 && INTEGER(nr)>=2){
	 radix=(int)INTEGER(nr);
       }else{
	 error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
       }
     }else{
       error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
     }
   }
   if(IS_VALUE(n) && GET_VTYPE(n)==NT_STRING){
     string_get(STRING(n),buf1);
     i=strtol(buf1,&ptr,radix);
     while(*ptr==' ')ptr++; /* salta gli spazi finali */
     if(*ptr==0){
       TYPE(nout->node=node_make())|=NT_IS_VALUE+NT_INTEGER;
       INTEGER(nout->node)=i;
       nout->type=P_ALLNODE;
     }else{
       nout->node=node_alloc(PARSE_ERROR_ID);
       nout->type=P_ALLNODE;
     }
     return;
   }
   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

/* sintassi (STR2NAME <stringa>)			*/
/* ritorna un nome di atomo specificato da <stringa>    */
/* es: (SETF (EVAL(NODE2STR "Atomo")) 10)		*/
void lf_str2name LF_PARAMS
{
 if(IS_CONS(nin)){
    eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
    nin=calc_pointer(nout);
    if(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_STRING){
	nout->node=node_alloc(string_getconv(STRING(nin),buf1));
	nout->type=P_ALLNODE;
	return;
    }
    error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}



/* sintassi (STRING=  <stringa> <stringa> <stringa>* )              */
/* ritorna T o NIL a seconda che le stringhe siano uguali o diverse */
/* NOTA: "ab" e "aB" sono diverse per stringeq 			    */
void lf_stringeq LF_PARAMS
{
 /*  "ab" e "aB" sono diverse per stringeq */
 node p1,p2;
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   p1=calc_pointer(nout);
   if(GET_NTYPE(p1)==NT_IS_VALUE&&GET_VTYPE(p1)==NT_STRING){
     if(IS_CONS(CONSRIGHT(nin))){
       while(IS_CONS(nin=CONSRIGHT(nin))){
	 eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	 p2=calc_pointer(nout);
	 if(GET_NTYPE(p2)==NT_IS_VALUE&&GET_VTYPE(p2)==NT_STRING){
	   if(strcmp(string_get(STRING(p1),buf1),string_get(STRING(p2),buf2))){
	     nout->node=NIL;
	     nout->type=P_ALLNODE;
	     return;
	   }
	   continue;
	 }
	 error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&p2);
       }
       nout->type=P_ALLNODE;
       nout->node=T;
       return;
     }
     error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
   }
   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&p1);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}
/* sintassi (STRING=  <stringa> <stringa> <stringa>* )              */
/* ritorna T o NIL a seconda che le stringhe siano uguali o diverse */
/* NOTA: "ab" e "aB" sono uguali per stringeq 			    */
void lf_stringequal LF_PARAMS
{
 node p1,p2;
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   p1=calc_pointer(nout);
   if(GET_NTYPE(p1)==NT_IS_VALUE&&GET_VTYPE(p1)==NT_STRING){
     if(IS_CONS(CONSRIGHT(nin))){
       while(IS_CONS(nin=CONSRIGHT(nin))){
	 eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	 p2=calc_pointer(nout);
	 if(GET_NTYPE(p2)==NT_IS_VALUE&&GET_VTYPE(p2)==NT_STRING){
	   if(strcmp(
		str2up(string_get(STRING(p1),buf1)),
		str2up(string_get(STRING(p2),buf2)))){
	     nout->node=NIL;
	     nout->type=P_ALLNODE;
	     return;
	   }
	   continue;
	 }
	 error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&p2);
       }
       nout->type=P_ALLNODE;
       nout->node=T;
       return;
     }
     error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
   }
   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&p1);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

char *str2up(s)
char *s;
{
 char *c=s;
 do
   if(*s>='a' && *s<='z')
     *s-=('a'-'A');
 while(*s++);
 return c;
}

/* sintassi (STRINGP <s-espressione>) 				   */
/* ritorna T se s-espressione 
 una stringa altrimenti ritorna NIL */
void lf_stringp LF_PARAMS
{
 /* controlla se il nodo e' una stringa */

 if(IS_CONS(nin)){
     eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
     nin=calc_pointer(nout);
     nout->node=(IS_VALUE(nin)&&GET_VTYPE(nin)==NT_STRING)?T:NIL;
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

/* sintassi (STRCAT <stringa>+)             	       */
/* ritorna una stringa concatenando tutte le <stringa> */
void lf_strcat LF_PARAMS
{
 node n=nin;
 node s;
 int  flag=FALSE;
 char strout[MAX_STR_LENGHT+1];

 strout[0]=0;
 while(nin!=NIL){
    flag=TRUE;
    if(IS_CONS(nin)){
	eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	s=calc_pointer(nout);
	if(IS_VALUE(s)&&GET_VTYPE(s)==NT_STRING){
	    string_get(STRING(s),buf1);
	    if(strlen(buf1)+strlen(strout)>MAX_STR_LENGHT)
		error(E_STRLONG,ERR_MERROR|ERR_TBLVL|ERR_PVOID,NULL);
	    strcat(strout,buf1);
	    nin=CONSRIGHT(nin);
	    continue;
	}
	error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&s);
    }
    error(E_BADLIST,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
 }
 if(flag){
     nout->node=node_make();
     STRING(nout->node)=string_put(strout,nout->node);
     TYPE(nout->node)|=NT_IS_VALUE+NT_STRING;
     /* NB: quando si alloca una stringa puo' avvenire un GC */
     /* e se si assegna prima il tipo al nodo appena allocato */
     /* il GC trova un nodo-stringa ma effettivamente senza la stringa */
     /* creando un errore interno */
     nout->type=P_ALLNODE;
     return;
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&NIL);
}

/* sintassi (STRSUB <stringa> <intero-da_dove> <intero-lughezza> )             	       */
/* ritorna una stringa es:<(STRSUB "ABCDE" 2 3)>="BCD" */
void lf_strsub LF_PARAMS
{
 node n=nin;
 node s;
 n_int from;
 n_int len;
 char strout[MAX_STR_LENGHT+1];


 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   s=calc_pointer(nout);
   nin=CONSRIGHT(nin);
   if(IS_VALUE(s)&&GET_VTYPE(s)==NT_STRING){
     string_get(STRING(s),strout);
     if(IS_CONS(nin)){
       eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
       s=calc_pointer(nout);
       nin=CONSRIGHT(nin);
       if(IS_VALUE(s)&&GET_VTYPE(s)==NT_INTEGER){
	 from=INTEGER(s);
	 if(from>strlen(strout))
	   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNINT,&from);
	 if(IS_CONS(nin)){
	   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
	   s=calc_pointer(nout);
	   nin=CONSRIGHT(nin);
	   if(IS_VALUE(s)&&GET_VTYPE(s)==NT_INTEGER){
	     len=INTEGER(s);
	     if(from+len-1>strlen(strout))
	       error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNINT,&len);
	     strout[(int)(from+len-1)]=0;
	     nout->node=node_make();
	     STRING(nout->node)=string_put(&strout[(int)(from-1)],nout->node);
	     TYPE(nout->node)|=NT_IS_VALUE+NT_STRING;
	     nout->type=P_ALLNODE;
	     return;
	   }
	   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&s);
	 }
	 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
       }
       error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&s);
     }
     error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
   }
   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&s);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&n);
}


/* sintassi (STR2ASCII <stringa> )    	       */
/* ritorna un intero che 
 il codice ascii del primo carattere della stringa*/
void lf_str2ascii LF_PARAMS
{
 node s;
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   s=calc_pointer(nout);
   if(IS_VALUE(s)&&GET_VTYPE(s)==NT_STRING){
     string_get(STRING(s),buf1);
     nout->node=node_make();
     INTEGER(nout->node)=buf1[0];
     TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
     nout->type=P_ALLNODE;
     return;
   }
   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&s);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}



/* sintassi (STRNUM <intero> )    	       			      */
/* ritorna una stringa di 1 carattere ascii specificato dal parametro */
void lf_strnum LF_PARAMS
{
 node s;
 n_int i;
 unsigned char strout[2];
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   s=calc_pointer(nout);
   if(IS_VALUE(s)&&GET_VTYPE(s)==NT_INTEGER){
     i=INTEGER(s);
     if(i>=0 && i<=255){
       strout[0]=(unsigned char)i;
       strout[1]=0;
       nout->node=node_make();
       STRING(nout->node)=string_put(strout,nout->node);
       TYPE(nout->node)|=NT_IS_VALUE+NT_STRING;
       nout->type=P_ALLNODE;
       return;
     }
     error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNINT,&i);
   }
   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&s);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

/* sintassi (STRLEN <stringa> )       */
/* ritorna un intero che 
 il codice ascii del primo carattere della stringa*/
void lf_strlen LF_PARAMS
{
 node s;
 if(IS_CONS(nin)){
   eval(CONSLEFT(nin),nout,genv,lenv,EVAL_NORM);
   s=calc_pointer(nout);
   if(IS_VALUE(s)&&GET_VTYPE(s)==NT_STRING){
     string_get(STRING(s),buf1);
     nout->node=node_make();
     INTEGER(nout->node)=strlen(buf1);
     TYPE(nout->node)|=NT_IS_VALUE+NT_INTEGER;
     nout->type=P_ALLNODE;
     return;
   }
   error(E_BADARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&s);
 }
 error(E_FEWARGS,ERR_MERROR|ERR_TBLVL|ERR_PNODE,&nin);
}

void lf_strprintf LF_PARAMS
{
 /* sintassi (strprintf <string> <sx>* ) */
 /* funziona esattamente come la printf delle librerie c */
 /* tipi di nodo lisp      indicatore nella stringa      */
 /* VALUE:                                               */
 /*   INTEGER			    %ld	%lx %l		 */
 /*   REAL			    %lf			 */
 /*   STRING			    %s			 */
 /*   RATIO			    %lf			 */
 /*   SYSFUNC			    %p			 */
 /*   CHAR			    %c			 */
 /*   STREAM			    %p			 */
 /*   altri			   ERRORE		 */
 /* NAME:						 */
 /*   nodo			    %s			 */
 /* CONS:                                                */
 /*   nodo			   ERRORE		 */
  
 node ni=nin;
 char arr[100];
 int arrc=0;
 node n;

 nin=eval_list(nin,genv,lenv);
 if(IS_CONS(nin)){
   n=CONSLEFT(nin);
   if(IS_VALUE(n) && GET_VTYPE(n)==NT_STRING){
     string_getconv(STRING(n),buf1);
     nin=CONSRIGHT(nin);
     while(IS_CONS(nin)){
       n=CONSLEFT(nin);
       if(IS_CONS(n))error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
       if(IS_NAME(n)){
	 *(str_t*)(&arr[arrc])=NAME(n);
	 arrc+=sizeof(str_t);
       }else{
       switch(GET_VTYPE(n)){

	 case NT_INTEGER:
	   *(n_int*)(&arr[arrc])=INTEGER(n);
	   arrc+=sizeof(n_int);
	   break;

	 case NT_REAL:
	   *(n_real*)(&arr[arrc])=REAL(n);
	   arrc+=sizeof(n_real);
	   break;

	 case NT_STRING:
	   *(str_t*)(&arr[arrc])=STRING(n);
	   arrc+=sizeof(str_t);
	   break;

	 case NT_RATIO:
	   *(n_real*)(&arr[arrc])=(n_real)RATIO_NUM(n)/(n_real)RATIO_DEN(n);
	   arrc+=sizeof(n_real);
	   break;

	 case NT_SYSFUNC:
	   *(n_func*)(&arr[arrc])=SYSFUNC(n);
	   arrc+=sizeof(n_func);
	   break;

	 case NT_CHAR:
	   *(n_char*)(&arr[arrc])=CHARACTER(n);
	   arrc+=2*sizeof(n_char);
	   break;

	 case NT_STREAM:
	   *(FILE**)(&arr[arrc])=STREAM(n);
	   arrc+=sizeof(FILE*);
	   break;

case NT_UFUNC:
case NT_ACCESSOR:
case NT_METHOD:
case NT_CLASS:
case NT_ENAME:
case NT_CNAME:
case NT_COMPLEX:
  error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);

       }}
       if(arrc>90)error(E_TOOMANYARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&ni);
       nin=CONSRIGHT(nin);
     }
     vsprintf(buf2,buf1,arr);
     nout->node=node_make();
     STRING(nout->node)=string_put(buf2,nout->node);
     TYPE(nout->node)|=NT_IS_VALUE+NT_STRING;
     nout->type=P_ALLNODE;
     return;
    }
    error(E_BADARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&n);
   }
 error(E_FEWARGS,ERR_MERROR|ERR_PNODE|ERR_TBLVL,&ni);
}
