;;;;;;;;; Funzioni aggiuntive common-lisp

; CxxxR , GENSYM

(defun caar  (_l)(car(car _l)))
(defun cadr  (_l)(car(cdr _l)))
(defun cdar  (_l)(cdr(car _l)))
(defun cddr  (_l)(cdr(cdr _l)))
(defun caaar (_l)(car(car(car _l))))
(defun caadr (_l)(car(car(cdr _l))))
(defun cadar (_l)(car(cdr(car _l))))
(defun caddr (_l)(car(cdr(cdr _l))))
(defun cdaar (_l)(cdr(car(car _l))))
(defun cdadr (_l)(cdr(car(cdr _l))))
(defun cddar (_l)(cdr(cdr(car _l))))
(defun cdddr (_l)(cdr(cdr(cdr _l))))


(defun rplacd (_list  _value)
  (setf (cdr _list) _value)
  _list
)

(defun rplaca (_list _value)
  (setf (car _list) _value)
  _list
)  



;; GENSYM: esempio di incapsulamento di variabile in una lambda-form
(let ((_counter -1))
  (defun gensym ()
    (str2name (strprintf "SYM%07ld" (setf _counter (1+ _counter))))
  )
)


(defun member (_element _list)
  (cond
    (
      (null _list)
      nil
    )
   (
     t
     (cond
       (
         (equal (car _list) _element) 
         t
       )
       (
         t
         (member _element (cdr _list))
       )
     )
   )
 )
)


;;;   FUNZIONI MATEMATICHE


(defun expt ( _num _pow &aux _result)
  (setf _result  (exp (* (float _pow) (log (float _num)))))
  (if
    (and (intp _num)  (intp _pow))
    (round (+ .5 _result))
   _result
 )
)


(defun floor (_num _den)
  (round (/ _num _den))
)

(setf pi (* 2 (asin 1.0)))



(print "\n")
(print "----------------->ADDON.LSP<-------------------\n")
(print "-         Funzioni aggiuntive CommonLisp      -\n")
(print "- CxxxR, RPLACA, RPLACD, GENSYM, MEMBER	      -\n")
(print "- EXPT, FLOOR, var PI 		 	      -\n")			
(print "-----------------------------------------------\n")
(print "\n")
