;;;;;;; GESTIONE ARRAY

; Funzioni MAKE-ARRAY e AREF
;

;;; initial-value e initial-element sono sinonimi si pu usare uno o l'altro.
(defun make-array (sizes &key initial-element initial-value initial-contents &aux array ret)
  (unless (listp sizes) (setf sizes (list sizes)))
  (cond
    (
      initial-contents
      initial-contents
    )
    (
      t
      (setf array 
	(cond (initial-value initial-value)
              (t initial-element)))

      (dolist (size sizes array)
        (setf 
          ret nil 
          array (dotimes (i size ret) (push (make-array-aux array) ret))
        )
      )
    )
  )
)

(defun make-array-aux (list)
  (cond
    (
      (consp list)
      (cons (car list) (make-array-aux (cdr list)))
    )
    (  
      t
      list
    )
  )
)


(defun aref (array &rest indexlist)
  (dotimes 
    ( i (1- (lenght indexlist)) (elt array (1+ (car indexlist))) )
    (setf
       array    (elt array (1+ (car indexlist))) 
       indexlist (cdr indexlist) 
    )
  )
)


(defun array-dimension ( _array _idx)
  (do
    (( _i _idx (1- _i))
     ( _a _array (car _a)))
    ((= _i 0) (lenght _a)))
)

(print "\n")
(print "----------------->ARRAY.LSP<-------------------\n")
(print "- Funzioni CommonLisp per la gestione degli   -\n")
(print "-  array                                      -\n")
(print "- MAKE-ARRAY, AREF, ARRAY-DIMENSION           -\n")
(print "-----------------------------------------------\n")
(print "\n")











