; Graphic Lisp
; -----------------------------  DAMA  ------------------------------
; ------------------- Scritto nel 1992-93 da Zoia Andrea ---------------


; La Scacchiera e' una lista di 100 elementi
; i bianchi sono sopra e i neri sotto
; 100 = posizione non corretta
; 0   = posizione vuota
; 1   = pedina bianca
; 2   = pedina nera
; 3   = damone bianco
; 4   = damone nero

(setf *load_lm_ok* nil)
(setf *load_pr_ok* nil)
(if
  (load "dama_lm.inc")
  (setf *load_pr_ok* t)
  (print "non riesco a trovare il file DAMA_LM.INC\n")
)
(if
  (load "dama_pr.inc")
  (setf *load_pr_ok* t)
  (print "Non riesco a caricare il file DAMA_PR.INC\n")
)


(setf *bianco* 1)
(setf *nero* 2)
(setf *pedina_bianca* 1)
(setf *pedina_nera* 2)
(setf *damone_bianco* 3)
(setf *damone_nero* 4)
(setf *user* 1)
(setf *computer* 2)

(setf *mosse_pezzi* '(
  (+9 +11 )	 	;pedina bianca
  (-9 -11 )		;pedina nera
  (+9 +11 -9 -11)	;damone bianco
  (+9 +11 -9 -11)	;damone nero
))


(setf *initboard* '(
100 100 100 100 100 100 100 100 100 100
100  1   0   1   0   1   0   1   0  100
100  0   1   0   1   0   1   0   1  100
100  1   0   1   0   1   0   1   0  100
100  0   0   0   0   0   0   0   0  100
100  0   0   0   0   0   0   0   0  100
100  0   2   0   2   0   2   0   2  100
100  2   0   2   0   2   0   2   0  100
100  0   2   0   2   0   2   0   2  100
100 100 100 100 100 100 100 100 100 100
))


(defun list-dup(l)(cond (l (cons (car l) (list-dup (cdr l)))) nil))
(defun init-board()(setf *scacchiera* (list-dup *initboard*)))


(defun NEW-fai-mossa (mossa &aux pezzo prev-pos mangiati)
 ;ritorna una lista di pezzi mangiati
 ;mossa rappresenta una mossa valida

 (setf pezzo (elt *scacchiera* (setf prev-pos (car mossa))))
 (setf (elt *scacchiera* prev-pos) 0) ;togli il pezzo

 (dolist ( posizione (cdr mossa) )
   (when (> posizione 1000) 
     (setf pezzo (+ 2 pezzo) posizione(- posizione 1000))
   ) ;diventa damone
   (when (> (abs (- prev-pos posizione)) 11) ;ha mangiato
     (setf 
       mangiati 
       (cons 
         (elt *scacchiera* (/ (+ prev-pos posizione) 2 ))
         mangiati
       )
       (elt *scacchiera* (/ (+ prev-pos posizione) 2 ))
       0  
     )
   )
   (setf prev-pos posizione)
 );dolist
 (setf (elt *scacchiera* prev-pos) pezzo)
 mangiati ;CONTIENE I PEZZI MANGIATI DALL' ULTIMO AL PRIMO
)
       
(defun NEW-disfa-mossa (mossa mangiati &aux pezzo prev-pos )
 (setf mossa (reverse mossa))
 (setf prev-pos (car mossa))
 (if (> prev-pos 1000) 
   (setf 
     prev-pos
     (- prev-pos 1000)
     pezzo
     (- (elt *scacchiera* prev-pos) 2)
   )
   (setf 
     pezzo
     (elt *scacchiera* prev-pos)
   )
 )
 (setf (elt *scacchiera* prev-pos) 0)

 (dolist ( posizione (cdr mossa) )
   (when (> posizione 1000) 
     (setf pezzo (- pezzo 2))
     (setf posizione (- posizione 1000))	
   ) ;diventa pedina
   (when (> (abs (- prev-pos posizione)) 11) ;ha mangiato
     (setf 
       (elt *scacchiera* (/ (+ prev-pos posizione) 2 ))
       (car mangiati)  
       mangiati 
       (cdr mangiati)
     )
   )
   (setf prev-pos posizione)
 );dolist
 (setf (elt *scacchiera* prev-pos) pezzo)
)

(defun NEW-inverti-colore (colore)
  (if (equal *bianco* colore) *nero* *bianco*)
)

(defun trova-mossa ( colore livello
         &aux valutazione maxmossa (maxvalutazione -100000))
  (dolist (secondamossa (NEW-crea-lista-mosse colore) maxmossa)
    (NEW-disfa-mossa secondamossa 
      (prog1
        (NEW-fai-mossa secondamossa)
        (setf valutazione (NEW-valuta-mossa-NP (1- livello) colore 100000))
        (when (> valutazione maxvalutazione)
          (setf maxvalutazione valutazione maxmossa secondamossa)
        )
      )
    ) 
  )
)

(defun NEW-valuta-mossa-NP_OLD ( livello colore
	      &aux (maxvalutazione -100000) valutazione )
  ; ritorna 0 in parita'  >0 ''colore,, in vantaggio
  ; colore T=bianco nil=nero

  (if (= 0 livello)
    ;then
    (NEW-valuta-scacchiera colore)
    ;else
    (dolist (secondamossa (NEW-crea-lista-mosse (NEW-inverti-colore colore)) (- maxvalutazione))
      (NEW-disfa-mossa secondamossa
        (prog1
          (NEW-fai-mossa secondamossa)
	  (setf valutazione (NEW-valuta-mossa-NP_OLD (1- livello) (NEW-inverti-colore colore)))
	  (when (> valutazione maxvalutazione)
	    (setf maxvalutazione valutazione)
	  )
	)
      )
    )
  )
)

(defun NEW-valuta-mossa-NP (livello colore prev-maxval
	      &aux (maxvalutazione -100000) valutazione )
  ; ritorna 0 in parita'  >0 ''colore,, in vantaggio
  ; colore T=bianco nil=nero

  (if (= 0 livello)
    ;then
    (NEW-valuta-scacchiera colore)
    ;else
    (dolist (secondamossa (NEW-crea-lista-mosse (NEW-inverti-colore colore)) (- maxvalutazione))
      (NEW-disfa-mossa secondamossa
        (prog1
          (NEW-fai-mossa secondamossa)
	  (setf valutazione (NEW-valuta-mossa-NP (1- livello) (NEW-inverti-colore colore) (- maxvalutazione)))
          (when (> valutazione maxvalutazione)
	    (setf maxvalutazione valutazione)
	  )
	)
      )
      (when (> valutazione prev-maxval) ;va bene anche >=
	    (return (- valutazione))	
      )
    )
  )
)

;  sigificato    x  d1 d2 d3 n1 n2 a1 a2 a3 x  NB: a3=DAMONE
;  linee         1  2  3  4  5  6  7  8  9  10
 (setf *lsd* ' ( 0  0  1  3  6  10 15 21 0  0 ) )
 (setf *rlsd* (reverse *lsd*) )
 (setf *dlsd* '( 0  0  15 21 21 21 21 15 0  0 ) )

(defun NEW-valuta-scacchiera ( colore
		&aux (valutazione 0) plusfunc minusfunc (curpos 9) curline )
  (if (equal colore *bianco*)
    (setf plusfunc #'+ minusfunc #'- )
    (setf plusfunc #'- minusfunc #'+ )
  )
  (dolist (pezzo *scacchiera* valutazione)
    (setf curpos (1+ curpos ))
    (setf curline (round (/ curpos 10)))
    (cond
      ( (or (= 0 pezzo) (= 100 pezzo))
        nil
      )
      ( (= 1 pezzo)
	(setf valutazione (apply plusfunc  valutazione 30 (elt *lsd* curline)))
      )
      ( (= 2 pezzo)
        (setf valutazione (apply minusfunc valutazione 30 (elt *rlsd* curline)))
      )
      ( (= 3 pezzo)
	(setf valutazione (apply plusfunc  valutazione 60 (elt *dlsd* curline)))
      )
      ( (= 4 pezzo)
	(setf valutazione (apply minusfunc valutazione 60 (elt *dlsd* curline)))
      )
    ) 
  )
)


(defun NEW-controlla-mossa ( mossa mosse )
 (if mosse
    (if (equal (car mosse) mossa)
      t
      (NEW-controlla-mossa mossa (cdr mosse))
    )
    nil
 )
)

    
(defun input-mossa (colore &aux mossa mosse)
 (setf mosse (NEW-crea-lista-mosse colore))
 (if mosse  
  (loop
    (setf mossa (inmove))
    (unless mossa (return t))
    (when (NEW-controlla-mossa mossa mosse) (return mossa))
  )
  nil
 )
) 
   
 
(defun dama (bianco nero livello &aux mossa)
  (init-board)
  (print-init)
  (textcolor 4 7)
  (curpos 40 23)
  (print "Dama Lisp  By Zoia Andrea")
  (curpos 45 22)
  (print "Digita EX per uscire")
  (loop
    (if 
      (equal *user* bianco)
      (setf mossa (input-mossa *bianco*))
      (setf mossa (trova-mossa *bianco* livello)) 
    ) 
    (unless mossa (return "Vincono i neri\n"))
    (when (eq mossa t) (return (print "\n")))
    (print-mov mossa)
    (NEW-fai-mossa mossa)

    (if 
      (equal *user* nero)
      (setf mossa (input-mossa *nero*))
      (setf mossa (trova-mossa *nero* livello))
    ) 
    (unless mossa (return "Vincono i bianchi\n"))
    (when (eq mossa t) (return (print "\n")))
    (print-mov mossa)
    (NEW-fai-mossa mossa)
  )
)










(print "\n\n ---- DAMA (Checker) LISP ---------\n")
(print "uso: (dama <bianco><nero><livello>)\n")
(print " <bianco> e <nero> rappresentano i 2 giocatori\n")
(print "  si possono usare i 2 valori *user* o *computer*\n")
(print " <livello> e' un intero che rappresenta il livello\n")
(print "  della strategia del computer (di solito 2 o 3)\n")
(print "  (NOTA: l'algoritmo e' NP e quindi con un livello superiore a\n")
(print "   3 si hanno lunghi tempi di attesa (a seconda del computer)\n")
(print "   Con un 80486 66Mhz al terzo livello si aspettano circa 20\n")
(print "    secondi per ogni mossa\n")
(print "  al livello 1 il computer e' molto ingenuo\n")
(print "  al livello 2 gia' appare come 'pensante,\n")
(print "  dal livello 3 in poi ''mi sembra,, che giochi bene (io non\n")
(print "    sono un gran giocatore....)\n")
(print "\n\n Es: (dama *user* *computer* 2 )\n")
(print "NOTA: Con windows attivare la voce di menu DYNAMIC REDRAW\n")

;(dama *user* *computer* 2)
     
