/*			     GRAPHIC LISP			*/
/*		Scritto nel 1991-94 da Zoia Andrea Michele 	*/
/*		Via Pergola #1 Tirano (SO) Tel. 0342-704210	*/
/* file clos_wi0.c non ansi-c per windows */
#include "clos.h"

#pragma hdrstop
#include <dir.h>
#include <dos.h>
#include "bwcc.h"


void InitWinClos(HANDLE hInstance, HANDLE hPrevInstance,LPSTR lpszCmdLine, int cmdShow);
void InitWinClos(HANDLE hInstance, HANDLE hPrevInstance,LPSTR lpszCmdLine, int cmdShow);
void InitWinClosFirst(HANDLE hInstance);
void InitWinClosEvery(HANDLE hInstance, int cmdShow);

long FAR PASCAL _export WinClosWndProc(HWND hWnd, WORD message,WORD wParam, LONG lParam);
BOOL FAR PASCAL _export About(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam);
long FAR PASCAL _export Resource(HWND hDlg, WORD wMsg, WORD wParam, LONG lParam);
long FAR PASCAL _export WinClosGrpWndProc(HWND hWnd, WORD message,WORD wParam, LONG lParam);

void SelectFont(LPLOGFONT lfFont);
void DrawDialogBar(HWND hDlg,int x,int y,int cx,int cy,int cxb);
int  InitTextBuffer(void);
void DoneTextBuffer(void);
void TextRepaint(HWND);
void TextClearWindow(void);

HANDLE	hInst=NULL;
HWND	hClosWindow=NULL;
HWND	hResourceWindow=NULL;

CATCHBUF ExitAddress;
char	*szAppName="Graphic Lisp";
char	*szDlgName="bordlg_ClosInfo";
BOOL	DynamicRedraw=FALSE;
BOOL	SelfPreemptive=FALSE;
BOOL	NeedRedraw=FALSE;
BOOL	IsHidden=FALSE;

#define TEXTBUFFER_ROWS 100
#define TEXTBUFFER_COLOUMNS 80
char 	 far *far*TextBuffer;
COLORREF far *far*TextBufferC;
COLORREF far *far*TextBufferB;
BOOL 	 far *far*TextBufferU;
TEXTMETRIC TextMetric;
LOGFONT    lfFont={10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, "Courier"};

BOOL	 HasCaret=FALSE;
BOOL	 ResetFlag=FALSE;
char     szFileName[81];                     // file name

int LastRow=0;
int LastCurPosY=0;
int FirstCurPosY=0;
int ScrollLines=0;
int CurPosX=0;
int CurPosY=0;
int VScrollPos; /* in caratteri */
int HScrollPos; /* in pixel */
int charYSize;  /* in pixel */
int charXSize;  /* in pixel */
int CharOutX;
int TextWndYSize;	/* in pixel */
int CaretSizeX=2;

// riga di buffer -> riga di schermo (0 la pi bassa,senza Vscroll)
#define ROW(aAa)  ((LastRow-aAa)<0?(LastRow-aAa+TEXTBUFFER_ROWS):(LastRow-aAa))

// riga di buffer -> riga di schermo (0 la pi bassa,con Vscroll) e
// riga di schermo (0 la pi bassa,con Vscroll) ->riga di buffer
#define ROWCVT(aAa)					\
((LastRow-aAa-VScrollPos)<0?				\
    ((LastRow-aAa+TEXTBUFFER_ROWS-VScrollPos)<0?	\
	(LastRow-aAa+2*TEXTBUFFER_ROWS-VScrollPos):	\
	(LastRow-aAa+TEXTBUFFER_ROWS-VScrollPos)	\
    ):							\
    (LastRow-aAa-VScrollPos)				\
)

#define HIDECARET if(HasCaret)HideCaret(hClosWindow)
#define SHOWCARET if(HasCaret)ShowCaret(hClosWindow)
#define MOVECARET if(HasCaret)SetCaretPos(CurPosX*charXSize,TextWndYSize-((ROWCVT(CurPosY)+1)*charYSize))

COLORREF CurrentColor;
COLORREF CurrentBackground;


#define MAX_ARGV 16
 #define BYPASS_STRING "-Bypass"
int  argc;
char *argv[MAX_ARGV];

BOOL StackSwitched;

int PASCAL WinMain(	HANDLE hInstance,
			HANDLE hPrevInstance,
			LPSTR lpszCmdLine, int cmdShow)
{

 unsigned long magic=0x87654321L;
 char *c;
 WORD Wv;
 HGLOBAL hg;
 void far *p;
 BOOL BypassFlag=FALSE; // usato solo da WinMain

 _fstrncpy(szFileName,lpszCmdLine,80);
 //BWCCMessageBox(NULL,szFName,szAppName,IDOK);
 c=szFileName;
 argv[0]="";
 argc=1;
 for(;;){
   while(*c==' ')*c++=0;
   if(!*c)break;
   if(argc<MAX_ARGV){
     if(strcmp(BYPASS_STRING,c)){
       argv[argc++]=c;
     }else{
       BypassFlag=TRUE;
     }
     // BWCCMessageBox(NULL,argv[argc-1],szAppName,IDOK);
   }
   while(*c!=' ' && *c )c++;
 }

 Wv=GetVersion();
 if(LOBYTE(Wv)==3){
   if(HIBYTE(Wv)<1){
     BWCCMessageBox(NULL,"   Graphic Lisp Works only with\n Windows ver 3.1 or higher (this:V3.0)",szAppName,IDOK);
     if(!BypassFlag)return 0;
   }
 }else{
   if(LOBYTE(Wv)<3){
     BWCCMessageBox(NULL,"   Graphic Lisp Works only with\n Windows ver 3.1 or higher (this:V2.x)",szAppName,IDOK);
     if(!BypassFlag)return 0;
   }
 }

 // Inizializza
 InitWinClos(hInstance, hPrevInstance, lpszCmdLine, cmdShow);
 ClosDDEInit();

 hg=GlobalAlloc(GMEM_FIXED,0xffffL);
 p=GlobalLock(hg);
 if(LOWORD(p)!=0 || HIWORD(p)==0 ){
   BWCCMessageBox(NULL,"Can't Switch Stack",szAppName,MB_OK);
   StackSwitched=FALSE;
 }else{
   SwitchStackTo(HIWORD(p),0xfff0,0x000f);
   StackSwitched=TRUE;
 }

 if(Catch((LPCATCHBUF)&ExitAddress)){
   if(StackSwitched)SwitchStackBack();
   GlobalUnlock(hg);
   GlobalFree(hg);

   ClosDDEUnInit();
   lisp_free();
   DoneTextBuffer();
   if(dribble_file)fclose(dribble_file);
   return 0;
 }

 main(argc,argv);
 return 0;
}

void InitWinClos(HANDLE hInstance, HANDLE hPrevInstance,
  LPSTR lpszCmdLine, int cmdShow)
{
 if (! hPrevInstance)              // if no previous instance, this is first
   InitWinClosFirst(hInstance);
 InitWinClosEvery(hInstance, cmdShow);  // initialization for all instances
}

void InitWinClosFirst(HANDLE hInstance)
{
 WNDCLASS wcHdumpClass;

 // Define the window class for this application.
 wcHdumpClass.lpszClassName = szAppName;
 wcHdumpClass.hInstance     = hInstance;
 wcHdumpClass.lpfnWndProc   = (WNDPROC)WinClosWndProc;
 wcHdumpClass.hCursor       = LoadCursor(hInstance, MAKEINTRESOURCE(CUR_MAIN));
 wcHdumpClass.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(ICO_MAIN));
 wcHdumpClass.lpszMenuName  = MAKEINTRESOURCE(MENU_MAIN);
 wcHdumpClass.hbrBackground = COLOR_WINDOW + 1;
 wcHdumpClass.style         = CS_VREDRAW | CS_CLASSDC | CS_OWNDC ;// | CS_HREDRAW |CS_VREDRAW
 wcHdumpClass.cbClsExtra    = 0;
 wcHdumpClass.cbWndExtra    = 0;
 // Register the class
 RegisterClass(&wcHdumpClass);

 wcHdumpClass.lpszClassName = szDlgName;
 wcHdumpClass.hInstance     = hInstance;
 wcHdumpClass.lpfnWndProc   = (WNDPROC)Resource;
 wcHdumpClass.hCursor       = LoadCursor(hInstance, MAKEINTRESOURCE(CUR_MAIN));
 wcHdumpClass.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(ICO_MAIN));
 wcHdumpClass.lpszMenuName  = NULL;
 wcHdumpClass.hbrBackground = COLOR_WINDOW+1;
 wcHdumpClass.style         = CS_HREDRAW | CS_VREDRAW;
 wcHdumpClass.cbClsExtra    = 0;
 wcHdumpClass.cbWndExtra    = DLGWINDOWEXTRA;
 // Register the class
 RegisterClass(&wcHdumpClass);

 RegisterGraphWindow(hInstance); 

}

void InitWinClosEvery(HANDLE hInstance, int cmdShow)
{

 hInst = hInstance;       // save for use by window procs

 // Create applications main window.
 hClosWindow = CreateWindow(
   szAppName,			// window class name
   szAppName,     		// window title
   WS_OVERLAPPEDWINDOW|WS_HSCROLL|WS_VSCROLL,		// type of window
   CW_USEDEFAULT,
   CW_USEDEFAULT,
   CW_USEDEFAULT,
   CW_USEDEFAULT,
   NULL,                    // no parent for this window
   NULL,                    // use the class menu
   hInstance,               // who created this window
   NULL                     // no parms to pass on
  );

  ShowWindow(hClosWindow,cmdShow);
  UpdateWindow(hClosWindow);
  IsHidden=!(cmdShow==SW_MINIMIZE);
}


long FAR PASCAL _export WinClosWndProc(HWND hWnd, WORD message,WORD wParam, LONG lParam)
{
 extern HDC hMetaFile;
 HDC hDc;
 FARPROC lpFunc;
 RECT rRect;
 int oldpos,i;
 HFONT hfFont;

 switch (message){
   case WM_CLOSE:
   case WM_QUERYENDSESSION:
     if(BWCCMessageBox(hClosWindow,"Exit?",szAppName,MB_OKCANCEL|MB_ICONEXCLAMATION)==IDCANCEL)
       return 0;
     if(HasCaret)
       DestroyCaret();
     // chiudi la finestra grafica
     if(hGraphWindow)SendMessage(hGraphWindow,WM_CLOSE,0,0);
     /////////////////////////////
     hDc=GetDC(hWnd);
     DeleteObject(SelectObject(hDc,GetStockObject(SYSTEM_FONT)));
     ReleaseDC(hWnd,hDc);
     //distruggi il vecchio font
     break;
   case WM_DESTROY:
     hClosWindow=NULL;
     Throw((LPCATCHBUF)&ExitAddress,1);
   case WM_CREATE:
     if(InitTextBuffer()){
       BWCCMessageBox(hWnd,"Out Of Memory allocating text buffers",szAppName,IDOK);
       Throw((LPCATCHBUF)&ExitAddress,1);
     }
     hClosWindow=hWnd;

     hDc=GetDC(hWnd);
     SelectObject(hDc,CreateFontIndirect(&lfFont));
     GetTextMetrics(hDc,&TextMetric);
     SetTextColor(hDc,CurrentColor=GetSysColor(COLOR_WINDOWTEXT));
     SetBkMode   (hDc,OPAQUE);
     SetBkColor  (hDc,CurrentBackground=GetSysColor(COLOR_WINDOW));
     ReleaseDC(hWnd,hDc);

     SetScrollRange(hWnd,SB_VERT,VScrollPos=0,TEXTBUFFER_ROWS-1,TRUE);
     SetScrollPos(hWnd,SB_VERT,VScrollPos,TRUE);
     charYSize=TextMetric.tmHeight+TextMetric.tmExternalLeading;
     charXSize=TextMetric.tmAveCharWidth;

     EnableMenuItem(GetMenu(hClosWindow),CM_GRAPHSAVE,MF_DISABLED|MF_GRAYED);
     EnableMenuItem(GetMenu(hClosWindow),CM_ZOOMIN,MF_DISABLED|MF_GRAYED);
     EnableMenuItem(GetMenu(hClosWindow),CM_ZOOMOUT,MF_DISABLED|MF_GRAYED);
     MoveWindow(hWnd,
       1*GetSystemMetrics(SM_CXSCREEN)/30,
       1*GetSystemMetrics(SM_CYSCREEN)/20,
      28*GetSystemMetrics(SM_CXSCREEN)/30,
      15*GetSystemMetrics(SM_CYSCREEN)/20,
     TRUE);
     TextClearWindow();
     return 0;
   case WM_SETFOCUS:
     if(wParam && hGraphWindow==wParam)
     return 0;
     HasCaret=TRUE;
     CreateCaret(hWnd,NULL,CaretSizeX,charYSize);
     MOVECARET;
     SHOWCARET;
     return 0;
   case WM_KILLFOCUS:
     if(wParam && hGraphWindow==wParam)
     return 0;
     HIDECARET;
     DestroyCaret();
     HasCaret=FALSE;
     return 0;
   case WM_PAINT:
     TextRepaint(hWnd);
     return 0;
   case WM_SIZE:
     IsHidden=(wParam==SIZEICONIC || wParam==SIZEZOOMHIDE);
     GetClientRect(hWnd,&rRect);
     CharOutX=(charXSize*TEXTBUFFER_COLOUMNS-rRect.right)%charXSize?
		(charXSize*TEXTBUFFER_COLOUMNS-rRect.right)/charXSize+1:
		(charXSize*TEXTBUFFER_COLOUMNS-rRect.right)/charXSize;
     SetScrollRange(hWnd,SB_HORZ,0,CharOutX,FALSE);
     if(HScrollPos>CharOutX)HScrollPos=CharOutX;
     SetScrollPos  (hWnd,SB_HORZ,HScrollPos,TRUE);
     GetClientRect(hWnd,&rRect);
     TextWndYSize=rRect.bottom;
     HIDECARET;
     MOVECARET;
     SHOWCARET;
     return 0;
   case WM_GETMINMAXINFO:
     #define SIZE_MINCHARY 1
     GetWindowRect(hWnd,&rRect);
     i=rRect.bottom-rRect.top;
     GetClientRect(hWnd,&rRect);
     ((MINMAXINFO far *)lParam)->ptMinTrackSize.y=i-rRect.bottom+charYSize*SIZE_MINCHARY+1;
     ((MINMAXINFO far *)lParam)->ptMinTrackSize.x=300;
     GetWindowRect(hWnd,&rRect);
     i=rRect.right-rRect.left;
     GetClientRect(hWnd,&rRect);
     i-=rRect.right;
     ((MINMAXINFO far *)lParam)->ptMaxTrackSize.x=charXSize*TEXTBUFFER_COLOUMNS+i;
     return 0;
   case WM_VSCROLL:
     oldpos=VScrollPos;
     switch(wParam){
       case SB_TOP:VScrollPos=0;break;
       case SB_BOTTOM:VScrollPos=TEXTBUFFER_ROWS;break;
       case SB_PAGEUP:VScrollPos-=TEXTBUFFER_ROWS/10;break;
       case SB_PAGEDOWN:VScrollPos+=TEXTBUFFER_ROWS/10;break;
       case SB_LINEUP:VScrollPos--;break;
       case SB_LINEDOWN:VScrollPos++;break;
       case SB_THUMBTRACK:VScrollPos=LOWORD(lParam);break;
       default:return 0;
     }
     if(VScrollPos<0)
       VScrollPos=0;
     if(VScrollPos>TEXTBUFFER_ROWS)
       VScrollPos=TEXTBUFFER_ROWS;
     if(oldpos!=VScrollPos){
       HIDECARET;
       ScrollWindow(hClosWindow,0,charYSize*(VScrollPos-oldpos),NULL,NULL);
       MOVECARET;
       SHOWCARET;
       SetScrollPos(hWnd,SB_VERT,VScrollPos,TRUE);
     }
     return 0;
   case WM_HSCROLL:
     oldpos=HScrollPos;
     switch(wParam){
       case SB_TOP:HScrollPos=0;break;
       case SB_BOTTOM:HScrollPos=CharOutX;break;
       case SB_PAGEUP:HScrollPos-=(TEXTBUFFER_COLOUMNS-CharOutX)/2;break;
       case SB_PAGEDOWN:HScrollPos+=(TEXTBUFFER_COLOUMNS-CharOutX)/2;break;
       case SB_LINEUP:HScrollPos--;break;
       case SB_LINEDOWN:HScrollPos++;break;
       case SB_THUMBTRACK:HScrollPos=LOWORD(lParam);break;
       default:return 0;
     }
     if(HScrollPos<0)
       HScrollPos=0;
     if(HScrollPos>CharOutX)
       HScrollPos=CharOutX;
     if(oldpos!=HScrollPos){
       SetScrollPos(hWnd,SB_HORZ,HScrollPos,TRUE);
       HIDECARET;
       hDc=GetDC(hClosWindow);
       SetWindowOrg(hDc,HScrollPos*charXSize,0);
       ReleaseDC(hClosWindow,hDc);
       ScrollWindow(hClosWindow,charXSize*(oldpos-HScrollPos),0,NULL,NULL);
       MOVECARET;
       SHOWCARET;
     }
     return 0;
   case WM_COMMAND:
     switch(wParam){
       case CM_EXIT:
         PostMessage(hWnd,WM_CLOSE,0,0L);
         return 0;
       case CM_RESOURCES:
         if(hResourceWindow){
           SendMessage(hResourceWindow,WM_CLOSE,0,0);
	 }else{
	   CreateDialog(hInst,MAKEINTRESOURCE(DLG_RESOURCE),hClosWindow,NULL);
	 }
	 return 0;
       case CM_ABOUT:
	 lpFunc=MakeProcInstance((FARPROC)About,hInst);
	 DialogBox(hInst,MAKEINTRESOURCE(DLG_ABOUT),hClosWindow,(DLGPROC)lpFunc);
         FreeProcInstance(lpFunc);
         return 0;
       case CM_CHOOSEFONT:
	 if(CMUFont(hWnd,&lfFont)){
	   SelectFont(&lfFont);
	 }
         return 0;
       case CM_DYNREDRAW:
         DynamicRedraw^=1;
         CheckMenuItem(GetMenu(hClosWindow),CM_DYNREDRAW,MF_BYCOMMAND|(DynamicRedraw?MF_CHECKED:MF_UNCHECKED));
	 return 0;
       case CM_SELFPREEMPTIVE:
	 SelfPreemptive^=1;
	 CheckMenuItem(GetMenu(hClosWindow),CM_SELFPREEMPTIVE,MF_BYCOMMAND|(SelfPreemptive?MF_CHECKED:MF_UNCHECKED));
	 return 0;
       case CM_BREAK:
         Throw((LPCATCHBUF)&critical_jmp,LONGJMP_CONTROLC);
       case CM_NEXTWIN:
         if(hGraphWindow){
	   SetFocus(hGraphWindow);
	   return 0;
	 }
	 if(hResourceWindow){
	   SetFocus(hResourceWindow);
	 }
	 return 0;
       case CM_OPEN:
         *szFileName=0;
	 if(!CMUFileOpen(hWnd,szFileName,80)){
           if(*szFileName){
	     eval_lisp_file_async(szFileName);
	   }
	 }
         return 0;
       case CM_RESERVED1:
	 getcurdir(0,szFileName);
	 BWCCMessageBox(hWnd,szFileName,"Cur Dir",MB_OK);
	 return 0;
       default:
         break;
    } 
 }
 return(DefWindowProc(hWnd, message, wParam, lParam));
}

void SelectFont(LPLOGFONT lfFont)
{
 // Seleziona il font e ridisegna la finestra

 HDC hDc;
 RECT rRect;
 int i;

 hDc=GetDC(hClosWindow);
 DeleteObject(SelectObject(hDc,CreateFontIndirect(lfFont)));
 GetTextMetrics(hDc,&TextMetric);
 SetWindowOrg(hDc,0,0);
 ReleaseDC(hClosWindow,hDc);
 GetClientRect(hClosWindow,&rRect);
 charYSize=TextMetric.tmHeight+TextMetric.tmExternalLeading;
 charXSize=TextMetric.tmMaxCharWidth;
 CharOutX=(charXSize*TEXTBUFFER_COLOUMNS-rRect.right)%charXSize?
		(charXSize*TEXTBUFFER_COLOUMNS-rRect.right)/charXSize+1:
		(charXSize*TEXTBUFFER_COLOUMNS-rRect.right)/charXSize;
 if(CharOutX<0){
   CharOutX=0;
   i=rRect.right;
   GetWindowRect(hClosWindow,&rRect);
   i=rRect.right-rRect.left-i;

   MoveWindow(hClosWindow,rRect.left,rRect.top,i+charXSize*TEXTBUFFER_COLOUMNS,rRect.bottom-rRect.top,TRUE);
 }
 SetScrollRange(hClosWindow,SB_HORZ,0,CharOutX,TRUE);
 HScrollPos=0;
 SetScrollPos(hClosWindow,SB_HORZ,0,TRUE);
 if(HasCaret){
   HIDECARET;
   DestroyCaret();
   if(CaretSizeX!=2)CaretSizeX=charXSize;
   CreateCaret(hClosWindow,NULL,CaretSizeX,charYSize);
   MOVECARET;
   SHOWCARET;
 }
 InvalidateRect(hClosWindow,NULL,TRUE);
}


BOOL FAR PASCAL _export About(HWND hDlg, WORD wMsg, WORD wParam, DWORD lParam)
{
 lsiz_t nodes_used;
 lsiz_t nodes_free;
 extern lsiz_t HashAllocated;
 extern unsigned long int nameidx;
 extern lsiz_t MaxHash;
 extern unsigned long int maxname;

 switch(wMsg){
   case WM_INITDIALOG:
     strcpy(szFileName,"About ");
     SetWindowText(hDlg,strcat(szFileName,szAppName));
     SetDlgItemText(hDlg,DLG_ABOUT_VERSION,CLOS_VERSION);
     SetDlgItemText(hDlg,DLG_ABOUT_TIME,__TIME__);
     SetDlgItemText(hDlg,DLG_ABOUT_DATE,__DATE__);
     node_count(&nodes_used,&nodes_free);
     sprintf(szFileName,"Memory:%lu Bytes(%2.3f Meg)",
       (nodes_used+nodes_free)*sizeof(node_s)+maxname+MaxHash*sizeof(hash_t),
       (double)((nodes_used+nodes_free)*sizeof(node_s)+maxname+MaxHash*sizeof(hash_t))/1048576.0);
     SetDlgItemText(hDlg,DLG_ABOUT_MEM,szFileName);
     return TRUE;
   case WM_CLOSE:
     EndDialog(hDlg,TRUE);
     return TRUE;
   case WM_COMMAND:
     switch(wParam){
       case IDOK:
	 EndDialog(hDlg,TRUE);
	 return TRUE;
     }
   }      
 return FALSE;
}


void DrawDialogBar(HWND hDlg,int x,int y,int cx,int cy,int cxb)
{
 HRGN r1,r2;
 RECT r;
 HDC hDc;

 hDc=GetDC(hDlg);
 r.left=x;
 r.top=y;
 r.right=x+cxb;
 r.bottom=y+cy;
 MapDialogRect(hDlg,&r);
 r1=CreateRectRgnIndirect(&r);
 r.left=x+cxb;
 r.top=y;
 r.right=x+cx;
 r.bottom=y+cy;
 MapDialogRect(hDlg,&r);
 r2=CreateRectRgnIndirect(&r);
 FillRgn(hDc,r1,GetStockObject(BLACK_BRUSH));
 FillRgn(hDc,r2,GetStockObject(WHITE_BRUSH));
 DeleteObject(r1);
 DeleteObject(r2);
 ReleaseDC(hDlg,hDc);
}

long FAR PASCAL _export Resource(HWND hDlg, WORD wMsg, WORD wParam, LONG lParam)
{
 lsiz_t nodes_used;
 lsiz_t nodes_free;
 extern lsiz_t HashAllocated;
 extern unsigned long int nameidx;
 extern lsiz_t MaxHash;
 extern unsigned long int maxname;

 switch(wMsg){
   case WM_CREATE:
     strcpy(szFileName,szAppName);
     SetWindowText(hDlg,strcat(szFileName," resources"));
     SetTimer(hDlg,1,500,NULL);
     hResourceWindow=hDlg;
     CheckMenuItem(GetMenu(hClosWindow),CM_RESOURCES,MF_CHECKED);
     return 0;
   case WM_TIMER:
   #define BAR_X 146
   #define BAR_Y 24
   #define BAR_SIZEX 92
   #define BAR_SIZEY 10
   #define BAR_SPACE 13
     node_count(&nodes_used,&nodes_free);
     DrawDialogBar(hDlg,BAR_X,BAR_Y,BAR_SIZEX,BAR_SIZEY,(int) ((BAR_SIZEX*nodes_used)/(nodes_used+nodes_free)) );
     DrawDialogBar(hDlg,BAR_X,BAR_Y+BAR_SPACE,BAR_SIZEX,BAR_SIZEY,(int) ((BAR_SIZEX*nameidx)/maxname) );
     DrawDialogBar(hDlg,BAR_X,BAR_Y+BAR_SPACE*2,BAR_SIZEX,BAR_SIZEY,(int) ((BAR_SIZEX*HashAllocated)/MaxHash) );
     SetDlgItemText(hDlg,DLG_RESOURCE_NODES,ltoa(nodes_used,"1234567",10));
     SetDlgItemText(hDlg,DLG_RESOURCE_STRING,ltoa(nameidx,"1234567",10));
     SetDlgItemText(hDlg,DLG_RESOURCE_HASH,ltoa(HashAllocated,"1234567",10));
     SetDlgItemText(hDlg,DLG_RESOURCE_NODESL,ltoa(nodes_free,"1234567",10));
     SetDlgItemText(hDlg,DLG_RESOURCE_STRINGL,ltoa(maxname-nameidx,"1234567",10));
     SetDlgItemText(hDlg,DLG_RESOURCE_HASHL,ltoa(MaxHash-HashAllocated,"1234567",10));
     SetDlgItemText(hDlg,DLG_RESOURCE_NODES,ltoa(nodes_used,"1234567",10));
     //hDlg=GetDlgItem(hDlg,1118);
     //MoveWindow(hDlg,0,0,10,10,TRUE);
     return 0;
   case WM_DESTROY:
     CheckMenuItem(GetMenu(hClosWindow),CM_RESOURCES,MF_UNCHECKED);
     hResourceWindow=NULL;
     KillTimer(hDlg,1);
     break;
   case WM_COMMAND:
     switch(wParam){
       case IDOK:
	 PostMessage(hDlg,WM_CLOSE,0,0);
	 break;
       case CM_NEXTWIN:
	 SetFocus(hClosWindow);
	 return 0;
       default:break;
     }
 }
 return BWCCDefWindowProc(hDlg,wMsg,wParam,lParam);
}

int InitTextBuffer(void)
{
 HANDLE hMem;
 unsigned i,j;

 hMem=GlobalAlloc(GMEM_FIXED,sizeof(char far*)*TEXTBUFFER_ROWS);
 if(!hMem) return 1;
 TextBuffer=(char far*far*)GlobalLock(hMem);
 hMem=GlobalAlloc(GMEM_FIXED,sizeof(char far*)*TEXTBUFFER_ROWS);
 if(!hMem) return 1;
 TextBufferC=(COLORREF far*far*)GlobalLock(hMem);
 hMem=GlobalAlloc(GMEM_FIXED,sizeof(char far*)*TEXTBUFFER_ROWS);
 if(!hMem) return 1;
 TextBufferB=(COLORREF far*far*)GlobalLock(hMem);
 hMem=GlobalAlloc(GMEM_FIXED,sizeof(char far*)*TEXTBUFFER_ROWS);
 if(!hMem) return 1;
 TextBufferU=(BOOL far*far*)GlobalLock(hMem);

 for(i=0;i<TEXTBUFFER_ROWS;i++){
   hMem=GlobalAlloc(GMEM_FIXED,TEXTBUFFER_COLOUMNS*sizeof(char));
   if(!hMem)return 1;
   TextBuffer[i]=(char far*)GlobalLock(hMem);
   hMem=GlobalAlloc(GMEM_FIXED,TEXTBUFFER_COLOUMNS*sizeof(COLORREF));
   if(!hMem)return 1;
   TextBufferC[i]=(COLORREF far*)GlobalLock(hMem);
   hMem=GlobalAlloc(GMEM_FIXED,TEXTBUFFER_COLOUMNS*sizeof(COLORREF));
   if(!hMem)return 1;
   TextBufferB[i]=(COLORREF far*)GlobalLock(hMem);
   hMem=GlobalAlloc(GMEM_FIXED,TEXTBUFFER_COLOUMNS*sizeof(BOOL));
   if(!hMem)return 1;
   TextBufferU[i]=(BOOL far*)GlobalLock(hMem);
 }
 return 0;
}

void DoneTextBuffer(void)
{
 int i;
 HANDLE hMem;
 for(i=0;i<TEXTBUFFER_ROWS;i++){
   hMem=LOWORD(GlobalHandle(HIWORD(TextBuffer[i])));
   GlobalUnlock(hMem);
   GlobalFree(hMem);
   hMem=LOWORD(GlobalHandle(HIWORD(TextBufferC[i])));
   GlobalUnlock(hMem);
   GlobalFree(hMem);
   hMem=LOWORD(GlobalHandle(HIWORD(TextBufferB[i])));
   GlobalUnlock(hMem);
   GlobalFree(hMem);
   hMem=LOWORD(GlobalHandle(HIWORD(TextBufferU[i])));
   GlobalUnlock(hMem);
   GlobalFree(hMem);
 }
 hMem=LOWORD(GlobalHandle(HIWORD(TextBuffer)));
 GlobalUnlock(hMem);
 GlobalFree(hMem);
 hMem=LOWORD(GlobalHandle(HIWORD(TextBufferC)));
 GlobalUnlock(hMem);
 GlobalFree(hMem);
 hMem=LOWORD(GlobalHandle(HIWORD(TextBufferB)));
 GlobalUnlock(hMem);
 GlobalFree(hMem);
 hMem=LOWORD(GlobalHandle(HIWORD(TextBufferU)));
 GlobalUnlock(hMem);
 GlobalFree(hMem);
}



// 1 in basso, TEXTBUFFER_ROWS in alto
void TextCursorXY(int x,int y)
{/* nb: 1,1  la posizione in basso a sinistra */
 CurPosX=x-1;
 CurPosY=LastRow-y+1;
 if(CurPosY<0)CurPosY+=TEXTBUFFER_ROWS;
}

int TextWhereX(void)
{
 return CurPosX+1;
}

int TextWhereY(void)
{
 int y;
 y=1+LastRow-CurPosY;
 return y<0?y+TEXTBUFFER_ROWS:y;
}


void TextClearLine(int Line)
{
 int i;
 for(i=0;i<TEXTBUFFER_COLOUMNS;i++){
   TextBuffer [Line][i]=' ';
   TextBufferC[Line][i]=CurrentColor;
   TextBufferB[Line][i]=CurrentBackground;
   TextBufferU[Line][i]=FALSE;
 }
}

void TextClearWindow(void)
{
 int i;
 for(i=0;i<TEXTBUFFER_ROWS;i++)
   TextClearLine(i);
 CurPosX=0;
 CurPosY=LastRow;
}

void TextUpdate(void);

#define TAB 0x9
#define TAB_SIZE 0x8
void TextPutChar(int c)
{
 switch(c){
   case '\n':
     CurPosX=TEXTBUFFER_COLOUMNS;
     break;
   case '\t':
     do{
       TextBuffer [CurPosY][CurPosX]=' ';
       TextBufferC[CurPosY][CurPosX]=CurrentColor;
       TextBufferB[CurPosY][CurPosX]=CurrentBackground;
       TextBufferU[CurPosY][CurPosX]=FALSE;
       CurPosX++;
     }while(CurPosX%TAB_SIZE && CurPosX!=TEXTBUFFER_COLOUMNS);
     break;
   case '\b':
     if(CurPosX){
       CurPosX--;
       TextBufferU[CurPosY][CurPosX]=FALSE;
     }
     break;
   default:
     TextBuffer [CurPosY][CurPosX]=c;
     TextBufferC[CurPosY][CurPosX]=CurrentColor;
     TextBufferB[CurPosY][CurPosX]=CurrentBackground;
     TextBufferU[CurPosY][CurPosX]=FALSE;
     CurPosX++;
 }
 if(CurPosX==TEXTBUFFER_COLOUMNS){
   CurPosX=0;
   if(CurPosY==LastRow){
     CurPosY+=1;
     CurPosY%=TEXTBUFFER_ROWS;
     LastRow=CurPosY;
     TextClearLine(LastRow);
     ScrollLines++;
     if(FirstCurPosY==LastRow){
       FirstCurPosY++;
       FirstCurPosY%=TEXTBUFFER_ROWS;
     }
   }else{
     CurPosY+=1;
     CurPosY%=TEXTBUFFER_ROWS;
   }
 }
 if(ROW(CurPosY)>ROW(FirstCurPosY))
   FirstCurPosY=CurPosY;
 if(ROW(CurPosY)<ROW(LastCurPosY))
   LastCurPosY=CurPosY;
 if(DynamicRedraw)TextUpdate();
}

void TextPutString(char *s)
{
 while(*s)TextPutChar(*s++);
}

void TextOutputChar(HDC TextDev,int xBuf,int yBuf,int xScrn,int yScrn)
{
 SetTextColor(TextDev,TextBufferC[yBuf][xBuf]);
 SetBkColor  (TextDev,TextBufferB[yBuf][xBuf]);
 TextBufferU[yBuf][xBuf]=TRUE;
 TextOut(TextDev,xScrn,yScrn,&TextBuffer[yBuf][xBuf],1);
}

void TextSolidCursor(BOOL SolidF)
{
 if(HasCaret){
   if(SolidF && CaretSizeX==2){
     HIDECARET;
     DestroyCaret();
     CreateCaret(hClosWindow,NULL,CaretSizeX=charXSize,charYSize);
     SHOWCARET;
   }
   if(!SolidF && CaretSizeX!=2){
     HIDECARET;
     DestroyCaret();
     CreateCaret(hClosWindow,NULL,CaretSizeX=2,charYSize);
     SHOWCARET;
   }
 }
}

void TextUpdate(void)
{
 int i,j,x,y,first,last;
 RECT r;
 HDC TextDev;

 HIDECARET;
 if(ScrollLines){
   ScrollWindow(hClosWindow,0,-charYSize*ScrollLines,NULL,NULL);
   ScrollLines=0;
 }
 TextDev=GetDC(hClosWindow);
 GetClientRect(hClosWindow,&r);
 last =0;
 first=r.bottom%charYSize?r.bottom/charYSize:r.bottom/charYSize-1;
 if(ROWCVT(FirstCurPosY)<first)first=ROWCVT(FirstCurPosY);
 if(ROWCVT(LastCurPosY )>last )last =ROWCVT(LastCurPosY );
 y=r.bottom-(first+1)*charYSize;
 r.top=y;
 for(i=ROWCVT(first);i!=ROWCVT(last);i++,i%=TEXTBUFFER_ROWS,y+=charYSize)
   for(j=0,x=0;j<TEXTBUFFER_COLOUMNS;j++,x+=charXSize)
     if(!TextBufferU[i][j])
       TextOutputChar(TextDev,j,i,x,y);
 for(j=0,x=0;j<TEXTBUFFER_COLOUMNS;j++,x+=charXSize)
   if(!TextBufferU[i][j])
     TextOutputChar(TextDev,j,i,x,y);
 y+=charYSize;
 r.bottom=y;
 FirstCurPosY=LastCurPosY;
 ReleaseDC(hClosWindow,TextDev);
 ValidateRect(hClosWindow,&r);
 MOVECARET;
 SHOWCARET;
}

void TextRepaint(HWND hWnd)
{
 PAINTSTRUCT ps;
 RECT r;
 int first_row,last_row,first_col,last_col,i,j,x,y;
 BeginPaint(hWnd,&ps);
 GetClientRect(hWnd,&r);
 first_row=ROWCVT((r.bottom-ps.rcPaint.top   )/charYSize );
 while(first_row<0)first_row+=TEXTBUFFER_ROWS;
 last_row =ROWCVT((r.bottom-ps.rcPaint.bottom)/charYSize+1);
 while(last_row<0)last_row+=TEXTBUFFER_ROWS;
 first_col=ps.rcPaint.left /charXSize;
 if(first_col<TEXTBUFFER_COLOUMNS){
   last_col =ps.rcPaint.right/charXSize+1;
   if(last_col>=TEXTBUFFER_COLOUMNS)last_col=TEXTBUFFER_COLOUMNS-1;
   y=r.bottom-((r.bottom-ps.rcPaint.top)/charYSize+1)*charYSize;
   for(i=first_row;i!=last_row;i++,i%=TEXTBUFFER_ROWS,y+=charYSize)
     for(x=first_col*charXSize,j=first_col;j<=last_col;j++,x+=charXSize)
       TextOutputChar(ps.hdc,j,i,x,y);
 }
 EndPaint(hWnd,&ps);
}

int WindowsGetChar(void)
{
 MSG msg;
 extern int ResetFlag;
 static int  vkKey=0;
 int tmp;

 if(!DynamicRedraw)TextUpdate();
 UpdateGraphWindow();
 if(vkKey){
   tmp=vkKey;
   vkKey=0;
   return tmp;
 }
 for(;;){
   /* si sospende in attesa di un evento */
   /* Questo e' il loop principale dei messagi di tutto il programma */
   GetMessage(&msg,NULL,0,0);
   if( !hResourceWindow || !IsDialogMessage(hResourceWindow,&msg)){
     TranslateMessage(&msg);
     DispatchMessage(&msg);
     if(ResetFlag){
       ResetFlag=FALSE;
       longjmp(break_jmp,LONGJMP_ERROR);
     }
     switch(msg.message){
       case WM_KEYDOWN:
	 vkKey=msg.wParam;break;
       case WM_CHAR:
	 vkKey=0;return msg.wParam;
       case WM_KEYUP:
         if(vkKey)return 0; // indica che il prossimo carattere  un vkKey
     }
   }
 }
}

void WindowsReleaseCPU(void)
{
 MSG Msg;
 /* Se si setta PM_NOYELD allora non da la CPU agli altri processi */
 /* ma comunque controlla se c'e' il messaggio */
 if(PeekMessage(&Msg,NULL,0,0,PM_REMOVE)){
   if( !hResourceWindow || !IsDialogMessage(hResourceWindow,&Msg)){
     TranslateMessage(&Msg);
     DispatchMessage(&Msg);
     if(ResetFlag){
       ResetFlag=FALSE;
       longjmp(break_jmp,LONGJMP_ERROR);
     }
   }
 }
}