/*
version: [$Id: read_menu_main.c,v 5.123 1995/01/18 01:24:58 hitman Exp $]
purpose: The main function for the test program menu read.
updates: All updates are handled by RCS
Author: The Hitman 1994
*/

#include <stdio.h>
#include <stdlib.h>

#include "bbs_director.h"
#include "menu_info.h"

int
main(int argc, char **argv)
{
	struct menu_struct menu[MAXLINES];
	int             size = sizeof(struct menu_struct);
	int             count = 0;
	FILE           *data_file;
	char            filename[MAXLENGTH];

	/** External functions **/
	extern char    *menu_data_filename(const char *);

#ifdef OSF1
	extern char    *strcpy(char *, const char *);
	extern char    *strcat(char *, const char *);
#endif				/* OSF1 */

	/** Get the argument and give it to a variable, point to it */
	/* then add the rest of the items needed. * */
	strcpy(filename, menu_data_filename(argv[1]));	/* Set down the filename */

	/** This file is a binary file, that will be written from the */
	/* beginning each time.  No appending * */
#if DEBUG
	fprintf(stderr, "** %s: filename = %s, argv[1] = %s **\n", __FILE__, filename, argv[1]);
#endif
	if ((data_file = fopen(filename, "r")) == NULL)
	{
		/** one day put in some error handleing. **/
		fprintf(stderr, "%s: %s(%d): %s: Need read permission\n", argv[0], __FILE__, __LINE__, filename);
		exit(EXIT_FAILURE);
	}			/* if */

	/** Make sure the file is at the beginning **/
	fseek(data_file, 0, SEEK_SET);

	puts("Menu ------------------\n");
	while (count < MAXLINES && fread(&menu[count], size, 1, data_file) == 1)
	{
		printf("(%s) %s \n", menu[count].keyword, menu[count].description);
	}
	fclose(data_file);


	return (0);
}
