/*
version: $Id: shell_display.c,v 5.123 1995/01/18 01:24:58 hitman Exp $
purpose: All display functions for program.
updates: Handled by RCS
*/

#include <stdio.h>

#ifndef __MSDOS__
#	include "hsh_glob.h"
#	include "hshgen_s.h"
#else				/* not_MSDOS */
#	include "..\src\hsh_glob.h"
#	include "..\src\hshgen_s.h"
#endif				/* MSDOS */
#include "version.h"

/* Table of functions and procedures.								*/
int             shell_display(_character * Character);

/* Shell Display Title */
int 
shell_display(_character * Character)
{
#ifdef DEBUG
	fprintf(stderr, "** %s: Character->nextstate = %d **\n", __FILE__, Character->nextstate);
#endif				/* DEBUG */
	printf("\n");
/** the bilangual parts of this program are set up with compiler */
/*	statements.  The code is large but the program is small. **/
#ifdef ENGLISH
	printf("Program: %s, v%s\n", PROGRAM, VER);
	printf("Copyright: %s, %s\n", COPYRIGHT, __DATE__);
	printf("Compiled: %s, %s, %s\n", OSVER, CCVER, COMPBY);
	printf("Support Address: %s\n", SUPPORT_ADDRESS);
#elif SPANISH			/* ENGLISH */
	printf("Programa: %s, v%s\n", PROGRAM, VER);
	printf("Derecho de Propiedad: %s, %s\n", COPYRIGHT, __DATE__);
	printf("Compilador: %s, %s, %s\n", OSVER, CCVER, COMPBY);
	printf("Support Address: %s\n", SUPPORT_ADDRESS);
#endif				/* SPANISH */
	printf("\n");

	switch (Character->Activity)
	{
	case SHELL_DISPLAY:
		return (RET_ERROR1);
		break;		/* case_shell_display */
	}			/* switch_special_case */
	return (RET_NORMAL);
}				/* shell_display */
