/***************************************************************************

  EDU - Extended Disk Usage                                 ( A better 'du' )

  Author: Kenneth DeGrant 
          kld@soft.eng.gilbarco.com
          degrant@cms.uncwil.edu

  EDU was intended to be a better form to display disk usage for a directory 
  than the UNIX command ``du''.  The UNIX 'du' displays output in the form 
  of either 512 or 1024 byte BLOCKS (depending on the version of du), Since 
  disk space is measured in Megabytes, and people relate better to the term 
  "MEGABYTE", EDU displays its' output in megabytes.

DOS and OS2 Users:
  Copy the appropriate executable file to a place in your PATH statement as 
  EDU.EXE or whatever you wish to call it.  

UNIX Users:
  If you plan on using EDU in a UNIX environment, the source file will 
  compile using gcc.  As far as other compilers, I have tested only SCO-UNIX
  cc (Microsoft).

  This program may be freely modified and distributed under the condition 
  that the author be notified of changes made, and the following files are 
  distributed with it:
        README
        eduos2.exe
        edudos.exe
        edu.c
  This way, your modifications will be incorporated into future versions 
  of EDU.

  If you like EDU, you are encouraged to Register EDU for a cost of 2 minutes.
  In this period, you should send an E-mail message stating that you find it 
  useful.  You should also include your E-mail address, so that I can notify 
  you of changes to and ports of the program to different operating systems, 
  and windowing environments.  I will mail notices of new version changes 
  when they happen.

  Note:  The '/' and '-' option start characters are synonymous and here for
         various operating systems that use different ones.

  Usage: 
         edu [/total_only] [/help] [dirname]

         /total_only  
         /t                Displays only the grand total for the directory tree.

         /help
         /h                Displays the usage message.

         dirname           Path from which to start the listing.
 
  EDU displays output of the form:

  XXX.XX Megabytes in DIRECTORYNAME

An example of EDU.

[D:\] cd emacs
[D:\emacs]edu
  3.20 Megabytes in .\19.27\bin
  0.85 Megabytes in .\19.27\data
  0.21 Megabytes in .\19.27\emx
  2.18 Megabytes in .\19.27\etc
  0.02 Megabytes in .\19.27\lib-src\os2
  0.40 Megabytes in .\19.27\lib-src
  0.20 Megabytes in .\19.27\lisp\term
 11.54 Megabytes in .\19.27\lisp
  1.88 Megabytes in .\19.27\man
  0.00 Megabytes in .\19.27\src\m
  0.00 Megabytes in .\19.27\src\s
  3.41 Megabytes in .\19.27\src
 23.74 Megabytes in .\19.27
 23.74 Megabytes in .
[D:\emacs]
  
Building EDU from source on a UNIX machine:

  You must define UNIX when compiling.  For example:
      cc -DUNIX edu.c

Building EDU from source on a non-UNIX machine:

  Compile normally.


History:

  Date  Author                    Change
  7-93  Kenneth DeGrant           Original version developed for MS-DOS.
  1-95      "                     Ported to SCO-UNIX.
  1-95      "                     Ported to OS2 using the EMX 0.9a development
                                  system.
  
Ported to Platforms:
      
  Platform       Compiler
  --------       -----------------------------
  MS-DOS         Borland 4.01
  OS2/EMX        EMX GCC
  SCO-UNIX       CC (Microsoft) and GCC
  Linux          GCC

Future:

  Plans to port to Microsoft Windows Environment, and an X11 environment.

  
Wanted:

  A VMS port. (Behind Unix, my second favorite OS.)


Contributors:
  Name              Address       Change Made


******************************************************************************************/

#include<stdio.h>
#include<stdlib.h>
#include<ctype.h>
#include<sys/types.h>
#include<sys/stat.h>
#include<dirent.h>

#define MEGABYTE              1048576L
#ifndef TRUE
#define TRUE                  1
#define FALSE                 0
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN 257
#endif


typedef struct total{
                         int            Megabytes;
                         unsigned long  Bytes;

                    } Total;
void Add( int megs, unsigned long bytes, Total *number )
{
   number->Bytes += bytes;
   number->Megabytes += megs;

   while( number->Bytes > MEGABYTE )
   {
      number->Megabytes++;
      number->Bytes -= MEGABYTE;
   }
}

   
Total DirectoryTotal( char *dirname, int total_only, char PathDelimiter )
{
   DIR *mydir;
   struct dirent *fbuf;
   struct stat statbuf;

   char filespec[MAXPATHLEN];
   char newdir[MAXPATHLEN];

   Total DirTotal = {0,0};
   Total TempTotal = {0,0};

   if( NULL == ( mydir = opendir( dirname ) ) )
   {
      fprintf(stderr,"Unable to open directory: %s\n", dirname );
      perror("opendir:");
      return (DirTotal);
   }

   while( NULL != ( fbuf = readdir(mydir) ) )
   {
      sprintf(filespec,"%-s%c%-s", dirname, PathDelimiter, fbuf->d_name);

#ifdef UNIX
      if ( lstat( filespec, &statbuf) == -1 ) 
      {
         continue;
      }
      if( (statbuf.st_mode & S_IFMT) == S_IFLNK  )
      {
         continue;
      }
#else
      if ( stat( filespec, &statbuf) == -1 ) 
      {
         continue;
      }
#endif

      if( (statbuf.st_mode & S_IFMT) == S_IFDIR  )
      {
         if( fbuf->d_name[0] == '.' ) 
         {
            /* "." and ".." are directory names, do not follow them! */
            if( (fbuf->d_name[1] == 0) || (fbuf->d_name[1] == '.') )
               continue;
         }

         sprintf(newdir,"%s%c%s", dirname, PathDelimiter, fbuf->d_name );

         TempTotal = DirectoryTotal( newdir, total_only, PathDelimiter );

         Add( TempTotal.Megabytes, (unsigned long ) TempTotal.Bytes, &DirTotal );
      }
      else 
      {
         Add( 0, (unsigned long) statbuf.st_size, &DirTotal );
      }
   }

  if( total_only == FALSE )
  {
     printf( "%6.2lf Megabytes in %-s\n", 
         (double)((double)DirTotal.Megabytes + ((double)DirTotal.Bytes/(double)MEGABYTE)), dirname);
  }

   closedir( mydir );
   return ( DirTotal );
}

int isOptionChar( char c )
{
   if( c == '/' || c == '-' )
   {
      return TRUE;
   }
   else
   {
      return 0;
   }
}
int main( int argc, char *argv[] )
{
   Total total;
   char path[MAXPATHLEN] = ".";
   int total_only;
   Total OverallTotal;
   char PathDelimiter;

#ifdef UNIX
      PathDelimiter  =  '/';
#else
      PathDelimiter  = '\\';
#endif

   while( --argc )
   {
      if( isOptionChar(argv[argc][0])  &&  toupper( argv[argc][1] ) == 'H' )
      {
         puts( "\nExtended Disk Usage.  1993 Kenneth DeGrant\n\n"
               "edu [/total_only]                             \n"
               "    [/help]                                   \n"
               "    [dirname]                                 \n");
         exit(0);
      }
      else if( isOptionChar(argv[argc][0]) && toupper( argv[argc][1] ) == 'T' )
      {
         total_only = TRUE;
      }
      else
      {
         strcpy( path, argv[argc] );
      }

   }


   OverallTotal =   DirectoryTotal( path, total_only, PathDelimiter ) ;

   if( total_only )
      printf( "%6.2lf Megabytes\n",(double)((double)OverallTotal.Megabytes+((double)OverallTotal.Bytes/(double)MEGABYTE)));

   

   return 1;
}
