/*
 * naked Gopher program.
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/ioctl.h>

#include <netinet/in.h>

#include <arpa/telnet.h>

#include "def.h"

#include <ctype.h>
#include <errno.h>
#include <signal.h>
#include <setjmp.h>
#include <netdb.h>

#define	strip(x)	((x)&0177)

#define	GOPHERTEXT	'0'
#define	GOPHERDIRECTORY	'1'
#define	GOPHERINDEX	'7'

char	*gopherServer = NGOPHERSITE;
int	gopherPort = NGOPHERPORT;
char	gopherFlag = GOPHERDIRECTORY;
char	*gopherPath = "1/";
char	*gopherKeyword = "";
char	*gopherRequest[BUFSIZ];

struct	servent *sp;

struct hostent *host;
char	*hostname;
char	hnamebuf[32];

struct sockaddr_in socin;

int	net;

char	sibuf[BUFSIZ];
int	scc;

filter(s, c)
	char *s;
	char c;
{
	while (*s)
		if (*s == c) {
			int i;
			s[strlen(s)+1] = '\0';
			for (i=strlen(s); i>0; i--) s[i] = s[i-1];
			*s = '\\';
			s = s+2;
		} else
			s++;
}

gopherText(s, len)
	char *s;
	int len;
{
	char c;

	while (len--) {
	    switch (c = *s++) {
		case '\r': /* ignore carriage returns */
			break;
		case '[':
		case '<':
			/* backquote markers */
			putchar('\\'); putchar(c);
			break;
		default:
			putchar(c);
	    } /* switch */
	}
}

gopherDirectory(s, len)
	char *s;
	int len;
{
	static int newLine = 1;
	static int entry, buflen;
	static char info[5][BUFSIZ];
	char c;

	while (len--) {
	    switch (c = *s++) {
		case '\t':
			info[entry][buflen] = 0;
			entry++; buflen = 0;
			break;
		case '\r': break;
		case '\n':
			info[entry][buflen] = 0;
			filter(info[1], '[');
			filter(info[2], ':');
			if (info[0][0] == GOPHERDIRECTORY)
			printf("[@$ngopher -F1 -p'%s' %s %s:] %s/\n",
				info[2], info[3], info[4], info[1]);
			else if (info[0][0] == GOPHERINDEX)
			printf("%s [$kw=@$ngopher -k'$kw' -F7 -p'%s' %s %s]\n",
				info[1], info[2], info[3], info[4]);
			else printf("[@$ngopher -F%s -p'%s' %s %s:] %s\n",
				info[0], info[2], info[3], info[4], info[1]);
			newLine = 1;
			break;
		case '.':
			if (newLine) return;
		default:
			if (newLine) {
				entry = 0;
				info[entry][0] = c;
				info[entry++][1] = 0;
				buflen = 0;
				newLine = 0;
			} else
				info[entry][buflen++] = c;
	    } /* switch */
	}
}

main(argc, argv)
	int argc;
	char *argv[];
{
	int errflag = 0;
	extern char *optarg;
	extern int optind;
	char c;

	sp = getservbyname("telnet", "tcp");
	if (sp == 0) {
		printf("gopher: tcp/gopher: unknown service\n");
		exit(1);
	}

	/* process options */
	while ((c = getopt(argc, argv, "F:p:k:")) != -1)
	    switch (c) {
	    case 'p':
		gopherPath = malloc(strlen(optarg)+1);
		strcpy(gopherPath, optarg);
		break;
	    case 'F':
		gopherFlag = optarg[0];
		break;
	    case 'k':
		gopherKeyword = malloc(strlen(optarg)+1);
		strcpy(gopherKeyword, optarg);
		break;
	    case '?':
	       errflag++;
	    }
	if (errflag) {
		printf("Usage: %s [-p path] [-F flag] [hostname [port]]\n",
			argv[0]);
		exit(-1);
	}
	if (optind < argc) {
		gopherServer = malloc(strlen(argv[optind])+1);
		strcpy(gopherServer, argv[optind++]);
	}
	if (optind < argc) {
		gopherPort = atoi(argv[optind++]);
	}

	/* get connection */
	host = gethostbyname(gopherServer);
	if (host) {
		socin.sin_family = host->h_addrtype;
		bcopy(host->h_addr, (caddr_t)&socin.sin_addr, host->h_length);
		hostname = host->h_name;
	} else {
		socin.sin_family = AF_INET;
		socin.sin_addr.s_addr = inet_addr(gopherServer);
		if (socin.sin_addr.s_addr == -1) {
			printf("%s: unknown host\n", gopherServer);
			return;
		}
		strcpy(hnamebuf, gopherServer);
		hostname = hnamebuf;
	}
	socin.sin_port = htons(gopherPort);
	net = socket(AF_INET, SOCK_STREAM, 0);
	if (net < 0) {
		perror("gopher: socket");
		exit(-1);
	}
	if (connect(net, (caddr_t)&socin, sizeof (socin)) < 0) {
		perror("gopher: connect");
		exit(-1);
	}

	if (gopherFlag == GOPHERINDEX)
	  sprintf(gopherRequest, "%s\t%s\r\n", gopherPath, gopherKeyword);
	else
	  sprintf(gopherRequest, "%s\r\n", gopherPath);
	write(net, gopherRequest, strlen(gopherRequest));

	while (scc >= 0) {
	    scc = read(net, sibuf, sizeof (sibuf));
	    if (scc > 0)
		if (gopherFlag == GOPHERDIRECTORY || gopherFlag == GOPHERINDEX)
			gopherDirectory(sibuf, scc);
		else
			gopherText(sibuf, scc);
	    else if (scc < 0 && errno == EWOULDBLOCK) scc = 0;
	    else
		if (scc <= 0) break;
	    if (scc == 0) sleep(5);
	}

	close(net);
	exit(0);
}
