#include	"def.h"
#include	<string.h>
#include	<sgtty.h>
#ifdef	CURSESX
#include	<cursesX.h>
#else
#include	<curses.h>
#endif

char erasech;
char ruboutch;

#ifndef USG3TTY
struct sgttyb tty;
struct tchars ttyc;
struct ltchars lttyc;
#else
struct termio tty;
#endif

#define check(i) if ((i) < 0) {printf("ioctl error\n");exit(1);}

void startCurses()
{
#ifndef USG3TTY
# ifdef USG
	/* Bug in USG tty driver, put out a DEL as a patch. */
	if (tty.sg_ospeed >= B1200)
		write(1, "\377", 1);
# endif
# ifdef TIOCSETN
	/* Don't flush typeahead if we don't have to */
	check(ioctl(0, TIOCSETN, &tty));
# else
	/* We have to.  Too bad. */
	stty(0, &tty);
# endif
# ifdef TIOCGETC
	/* Update the other random chars while we're at it. */
	check(ioctl(0, TIOCSETC, &ttyc));
# endif
# ifdef TIOCSLTC
	check(ioctl(0, TIOCSLTC, &lttyc));
# endif
#else
	/* USG 3 very simple: just set everything */
	check(ioctl(0, TCSETAW, &tty));
#endif
	initscr();
#ifdef CONVEX          /* modification for CONVEX by T.W.Tan 2 May 1993 */
	crmode();
#else
	cbreak();
#endif
	noecho();
}

void stopCurses()
{
	endwin();
}

dumbterm(term)
char *term;
{
	int dumb = FALSE;

	if (*term == '\0'||
		strcmp(term, "network") == 0 ||
		strcmp(term, "unknown") == 0 ||
		strcmp(term, "dialup")  == 0 ||
		strcmp(term, "dumb")    == 0 ||
		strcmp(term, "switch")  == 0 ||
		strcmp(term, "ethernet") == 0)
		dumb = TRUE;
	return(dumb);
}

screenInit()
{
	char term[MAXFNAME];

	strcpy(term, getenv("TERM"));
	if (strncmp(term, "dec-vt", 6) == 0)
		strcpy(term, term+4);
	if (strncmp(term, "vt220", 5) == 0)
		strcpy(term, "vt100");

	if (dumbterm(term)) {
		printf("Please enter your terminal type (default vt100): ");
		gets(term);
		if (strlen(term) == 0)
			strcpy(term, "vt100");
	}
	setenv("TERM", term, 1);

#ifndef USG3TTY
	gtty(0, &tty);
# ifdef TIOCGETC
	check(ioctl(0, TIOCGETC, &ttyc));
# endif
# ifdef TIOCGLTC
	check(ioctl(0, TIOCGLTC, &lttyc));
# endif
#else
	check(ioctl(0, TCGETA, &tty));
#endif

#ifdef	SGI
	erasech = erasechar();
#else
	erasech = tty.sg_erase;
#endif
	ruboutch = '\177';
	if (erasech == '\177')
		ruboutch = '\b';

	startCurses();
	return(1);
}
