/*
 * util.c
 *
 * This file is part of "locatedir"
 * by Alexander Kourakos <awk@vt.edu>
 *
 * Copyright (C) 1994 Alexander Kourakos
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice remains unchanged on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the author.
 *
 * There is no warranty or other guarantee of this software fitness
 * for any purpose. It is provided solely "as is".
 */

#include "locatedir.h"

/*
 * Report an error, and quit. Echoes "." to stdout so that the
 * directory doesn't get changed.
 */

void
error (const char *string)
{
  fprintf (stderr, "%s: %s\n", progname, string);
  printf ("%s\n", HERE);
  exit (EXIT_FAILURE);
}

/*
 * Print the usage message.
 */

void
usage (void)
{
  fprintf (stderr, "usage: %s [-nqd] [<directory name>]\n", progname);
  fprintf (stderr, "   or  %s -r [<start directory>]\n\n", progname);
  printf ("%s\n", HERE);
  exit (EXIT_FAILURE);
}

/*
 * end of file 
 */
