
/* Copyright (c) 1994
 *      Zbigniew Wieckowski (wieckows@cs.umn.edu)
 *
 * Permission is granted to freely use, copy, modify, and redistribute
 * this software under the terms of the GPL licence agreement.
 */

#include <stdio.h>
#include <tk.h>
#include "chichotConfig.h"

#define BUFFER_LEN 256
#define BUFFER_LEN_EXTRA (BUFFER_LEN+1)

const char* const chichotTkInterfacePath;
const char* const chichotTkInterfaceName;

Tcl_Interp* interp;
int code;
Tk_Window window;

char buffer[BUFFER_LEN_EXTRA];
int buffhead = 0;
int bufftail = 0;
int buffcount = 0;
static int displayExists;
char pcmd[BUFFER_LEN_EXTRA];

void alert(char*);

extern void endCycle();

int
assist(char* input, int* inputlen, int getinput, short* endCycle)
{
  static init = 1;
  short ret_val;

  ret_val = 0;

  if (init) {
    init = 0;
    interp = Tcl_CreateInterp();
    displayExists = (int)XOpenDisplay((char*)NULL);
    if (displayExists) {
       sprintf(pcmd, "%s &", chichotTkInterfacePath);
       system(pcmd);
       code = Tcl_GlobalEval(interp, "set env(DISPLAY)");
       window = Tk_CreateMainWindow(interp, interp->result, "chichot",
				    "chichot");
       Tk_DoOneEvent(TK_DONT_WAIT);
       Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
       Tk_UnmapWindow(window);
       Tk_DoOneEvent(TK_DONT_WAIT);
       Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
       strcpy(pcmd, "set chichotCmd \"\"\nset chichotEndCycle \"\"");
       code = Tcl_GlobalEval(interp, pcmd);
       if (code != TCL_OK) {
          sprintf(pcmd, "assist: Code %d after: set chichotCmd", code);
          alert(pcmd);
          return 0;
       }
       Tk_DoOneEvent(TK_DONT_WAIT);
       Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
    }
  }
  if (displayExists) {
     code = Tcl_GlobalEval(interp, "set chichotEndCycle");
     Tk_DoOneEvent(TK_DONT_WAIT);
     Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
  }
  if (!displayExists || code != TCL_OK) {
     sprintf(pcmd, "assist: Code %d after: set chichotEndCycle", code);
     alert(pcmd);
     return 0;
  } else if (!strcmp(interp->result, "1")) {
     *endCycle = 1;
     code = Tcl_GlobalEval(interp, "set chichotEndCycle \"\"");
     if (TCL_OK != code) {
        sprintf(pcmd, "assist: Code after reset chichotEndCycle %d", code);
        alert(pcmd);
     }
     Tk_DoOneEvent(TK_DONT_WAIT);
     Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
  }
  if (displayExists) {
     code = Tcl_GlobalEval(interp, "set chichotCmd");
     Tk_DoOneEvent(TK_DONT_WAIT);
     Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
  }
  if (!displayExists || code != TCL_OK) {
     sprintf(pcmd, "assist: Code %d after: set chichotCmd", code);
     alert(pcmd);
     return 0;
  }
  else {
     if (strlen(interp->result) + bufftail <= BUFFER_LEN) {
	strcpy(&buffer[bufftail], interp->result);
	bufftail += strlen(interp->result);
	bufftail %= BUFFER_LEN;
     } else {
	strncpy(&buffer[bufftail], interp->result, BUFFER_LEN - bufftail);
	strcpy(&buffer[0], &interp->result[BUFFER_LEN - bufftail]);
	bufftail = strlen(&interp->result[BUFFER_LEN - bufftail]);
     }
     buffcount += strlen(interp->result);
     if (getinput && buffcount > 0) {
	*input = buffer[buffhead++];
	buffhead %= BUFFER_LEN;
	buffcount--;
	ret_val = buffcount;
	if ('\0' == *input)
	   *inputlen = 0;
	else
	   *inputlen = 1;
     }
     code = Tcl_GlobalEval(interp, "set chichotCmd \"\"");
      if (TCL_OK != code) {
	 sprintf(pcmd, "assist: Code after reset chichotCmd %d", code);
	 alert(pcmd);
      }
     Tk_DoOneEvent(TK_DONT_WAIT);
     Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
  }
  return ret_val;
}

int
sendContexts(const char* pcontexts)
{
   short done = 0;
   int i, pcmdlen;

  if (displayExists) {
     sprintf(pcmd, "send %s currContextsText delete 0.0 end",
	     chichotTkInterfaceName);
     Tcl_GlobalEval(interp, pcmd);
     Tk_DoOneEvent(TK_DONT_WAIT);
     Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
     sprintf(pcmd, "send %s currContextsText insert 0.0 \\\"",
	     chichotTkInterfaceName);
     i = 0;
     pcmdlen = strlen(&pcmd[0]);
     while (!done) {
	if ('\n' != pcontexts[i] && '\0' != pcontexts[i])
	   pcmd[pcmdlen++] = pcontexts[i++];
	else if ('\n' == pcontexts[i]) {
	   pcmd[pcmdlen++] = '\\';
	   pcmd[pcmdlen++] = '\\';
	   pcmd[pcmdlen++] = 'n';
	   i++;
	} else {
	   pcmd[pcmdlen] = '\0';
	   done = 1;
	}
     }
     strcat(&pcmd[0], "\\\"");
     code = Tcl_GlobalEval(interp, &pcmd[0]);
      if (TCL_OK != code) {
	 sprintf(pcmd, "sendContexts - return code %d", code);
	 alert(pcmd);
      }
     Tk_DoOneEvent(TK_DONT_WAIT);
     Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
  }
}

int
matchglob(const char* patt, const char* s)
{
   if (!strcmp(" ", patt) && !strcmp(" ", s))
      return 1;
   if (!strcmp(" ", patt) || !strcmp(" ", s))
      return 0;
   strcpy(&pcmd[0], "string match ");
   strcat(&pcmd[0], patt);
   strcat(&pcmd[0], " ");
   strcat(&pcmd[0], s);
   code = Tcl_GlobalEval(interp, &pcmd[0]);
   if (TCL_OK != code) {
      sprintf(pcmd, "matchglob - return code %d", code);
      alert(pcmd);
   }
   Tk_DoOneEvent(TK_DONT_WAIT);
   Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
   return atoi(interp->result);
}

int
sendName(const char* name, const char mode)
{
   short i = 0;
   short pcmdlen;
   short done = 0;

   if (displayExists) {
      sprintf(pcmd, "send %s", chichotTkInterfaceName);
      switch (mode) {
	 case 'a': strcat(&pcmd[0], " actionList insert end \\\"");
	 break;
	 case 'i': strcat(&pcmd[0], " inputMacroList insert end \\\"");
	 break;
	 case 'o': strcat(&pcmd[0], " triggerList insert end \\\"");
	 break;
	 case 'k': strcat(&pcmd[0], " keywordList insert end \\\"");
	 break;
	 case 's': strcat(&pcmd[0], " screenMacroList insert end \\\"");
	 break;
	 default:
	 strcat(&pcmd[0], " wm deiconify .top4\n");
	 strcat(&pcmd[0], "send ");
	 strcat(&pcmd[0], chichotTkInterfaceName);
	 strcat(&pcmd[0],
		" feedback insert 0.0 \\\"Wrong macro list mode\\\"\n");
	 break;
      }
      pcmdlen = strlen(&pcmd[0]);
      while (!done) {
	 if ('\n' != name[i] && '[' != name[i] && '\0' != name[i] &&
	     '\r' != name[i])
	    pcmd[pcmdlen++] = name[i++];
	 else if ('\n' == name[i]) {
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = 'n';
	    i++;
	 } else if ('\r' == name[i]) {
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = 'r';
	    i++;
	 } else if ('[' == name[i]) {
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '\\';
	    pcmd[pcmdlen++] = '[';
	    i++;
	 }
	 else {
	    pcmd[pcmdlen] = '\0';
	    done = 1;
	 }
      }
      strcat(&pcmd[0], "\\\"");
      code = Tcl_GlobalEval(interp, &pcmd[0]);
      Tk_DoOneEvent(TK_DONT_WAIT);
      Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
      Tk_DoOneEvent(TK_DONT_WAIT);
      Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
      Tk_DoOneEvent(TK_DONT_WAIT);
      Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
      if (TCL_OK != code) {
	 sprintf(pcmd, "sendName - return code %d", code);
	 alert(pcmd);
      }
      return code;
   }
}

int
resetStatus()
{
   if (displayExists) {
      sprintf(pcmd,
    "send %s inputMacroList delete 0 end\nsend %s  triggerList delete 0 end\
\nsend %s keywordList delete 0 end\nsend %s screenMacroList delete 0 end\
\nsend %s actionList delete 0 end",
	      chichotTkInterfaceName, chichotTkInterfaceName,
	      chichotTkInterfaceName, chichotTkInterfaceName,
	      chichotTkInterfaceName);
      code = Tcl_GlobalEval(interp, &pcmd[0]);
      Tk_DoOneEvent(TK_DONT_WAIT);
      Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
      Tk_DoOneEvent(TK_DONT_WAIT);
      Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
      if (TCL_OK != code) {
	 sprintf(pcmd, "resetStatus - return code %d", code);
	 alert(pcmd);
      }
      return code;
   }
}

int
reqAltAction()
{
   if (displayExists) {
      sprintf(pcmd,
"send %s wm deiconify .top13\nsend %s pack .top13.frame3\nsend %s  grab set .top13",
	      chichotTkInterfaceName, chichotTkInterfaceName,
	      chichotTkInterfaceName);
      code = Tcl_GlobalEval(interp, &pcmd[0]);
      Tk_DoOneEvent(TK_DONT_WAIT);
      Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
      Tk_DoOneEvent(TK_DONT_WAIT);
      Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
      Tk_DoOneEvent(TK_DONT_WAIT);
      Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
      if (TCL_OK != code) {
	 sprintf(pcmd, "reqAltAction - return code %d", code);
	 alert(pcmd);
      }
      return code;
   }
}

int
deactActMB()
{
   if (displayExists) {
      sprintf(pcmd, "send %s actionMenubutton configure -fg black",
	      chichotTkInterfaceName);
      code = Tcl_GlobalEval(interp, &pcmd[0]);
      Tk_DoOneEvent(TK_DONT_WAIT);
      Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
      if (TCL_OK != code) {
	 sprintf(pcmd, "deactActMB - return code %d", code);
	 alert(pcmd);
      }
      return code;
   }
}

void
discardMeta()
{
   bufftail = buffhead = buffcount = 0;
}

void
alert(char* message)
{
   char buf[BUFFER_LEN_EXTRA];
   sprintf(buf, "send %s set dummy AlertBox %s",
	   chichotTkInterfaceName, message);
   code = Tcl_GlobalEval(interp, &buf[0]);
   Tk_DoOneEvent(TK_DONT_WAIT);
   Tk_DoOneEvent(TK_IDLE_EVENTS || TK_DONT_WAIT);
   if (TCL_OK != code) {
      /*fprintf(stderr, "%s", interp->result);*/
   }
   
}
