

/*
 * Copyright (c) 1983, 1988 The Regents of the University of California.
 * All rights reserved
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */


#include "systype.h"

#ifdef BSD

/*
 * Pseudo-terminal routines for 4.3BSD.
 */

#include        <unistd.h>
#include        <string.h>
#include        <sys/types.h>
#include        <sys/stat.h>
#include        <sys/file.h>

/*
 * The name of the pty master device is stored here by pty_master().
 * The next call to pty_slave() uses this name for the slave.
 */

static char     pty_name[12];   /* "/dev/[t]tyXY" = 10 chars + null byte */

int                     /* returns the file descriptor, or -1 on error */
     pty_master()
{
     int             i, master_fd;
     char            *ptr;
     struct stat     statbuff;
     static char     ptychar[] = "pqrs";                      /* X */
     static char     hexdigit[] = "0123456789abcdef";          /* Y */
     
     /*
      * Open the master half - "/dev/pty[pqrs][0-9a-f]".
      * There is no easy way to obtain an available minor device
      * (similar to a streams clone open) - we have to try them
      * all until we find an unused one.
      */
     
     for (ptr = ptychar; *ptr != 0; ptr++) {
	  strcpy(pty_name, "/dev/ptyXY");
	  pty_name[8] = *ptr;     /* X */
	  pty_name[9] = '0';      /* Y */
	  
	  /*
	   * If this name, "/dev/ptyX0" doesn't even exist,
	   * then we can quit now. It means the sysytem doesn't
	   * have /dev entries for this group of 16 tys.
	   */
	  
	  if (stat(pty_name, &statbuff) < 0)
	       break;
	  for (i = 0; i < 16; i++) {
	       pty_name[9] = hexdigit[i];      /* 0-15 -> 0-9a-f */
	       if ( (master_fd = open(pty_name, O_RDWR)) >= 0)
		    return(master_fd);      /* got it, done */
	  }
     }
     return(-1);     /* couldn't open master, assume all pty's are in use */
}

/* Open the slave half of a pseudo-terminal.
 * Note that the master half of a pty is a single-open device,
 * so there isn't a race condition between opening the master
 * above and opening the slave below.  The only way the slave
 * open will fail is if someone has opened the slave without
 * first opening the master.
 */

int                     /* returns the file descriptor, or -1 on error */
     pty_slave(master_fd)
int     master_fd;              /* from pty_master */
{
     int      slave_fd;
     
     pty_name[5] = 't';      /* change "/dev/ptyXY" to "/dev/ttyXY" */
     if ( (slave_fd = open(pty_name, O_RDWR)) < 0) {
	  close(master_fd);
	  return(-1);
     }
     
     return(slave_fd);
}

#else

#include <stdio.h>
#include <fcntl.h>

#ifndef PTY_FIRST_CHARS
#define PTY_FIRST_CHARS "qpr"
#endif

#ifndef PTY_SECOND_CHARS
#define PTY_SECOND_CHARS "0123456789abcdef"
#endif

static char PtyProto[] = "/dev/ptyXY";
static char TtyProto[] = "/dev/ttyXY";

static char PtyName[32], TtyName[32];


int                     /* returns the file descriptor, or -1 on error */
pty_master()
{
  int fd;
  register char *p, *q, *l, *d;

  strcpy(PtyName, PtyProto);
  strcpy(TtyName, TtyProto);
  for (p = PtyName; *p != 'X'; ++p)
    ;
  for (q = TtyName; *q != 'X'; ++q)
    ;
  for (l = PTY_FIRST_CHARS; (*p = *l) != '\0'; ++l)
    {
      for (d = PTY_SECOND_CHARS; (p[1] = *d) != '\0'; ++d)
	{
	  if ((fd = open(PtyName, O_RDWR)) != -1) {
	      q[0] = *l;
	      q[1] = *d;
	      return fd;
	    }
	}
    }
  return -1;
}

int                     /* returns the file descriptor, or -1 on error */
pty_slave()
{
  int fd;

  if ((fd = open(TtyName, O_RDWR)) != -1) {
    return fd;
  }
  return -1;
}


#endif
