#ifndef lint
static char RCSid[] = 
"$Id: signals.c,v 6.2 1993/05/04 18:21:37 mcooper Exp mcooper $";

static char copyright[] =
"@(#) Copyright (c) 1990-1993 Michael A. Cooper.\n\
 All rights reserved.\n";
#endif

/*
 * Copyright (c) 1990-1993 Michael A. Cooper.
 * This software may be freely distributed provided it is not sold for 
 * profit and the author is credited appropriately.
 */

#include "config.h"
#include "qterm.h"
#include <stdio.h>
#include <signal.h>

#if	SIG_TYPE == SIGTYPE_POSIX
void SetupSignals(func)
    void		       (*func)();
{
    struct sigaction		act;

    sigemptyset(&act.sa_mask);
    act.sa_flags = 0;
    act.sa_handler = func;

    (void) sigaction(SIGINT, &act, (struct sigaction *)NULL);
    (void) sigaction(SIGHUP, &act, (struct sigaction *)NULL);
    (void) sigaction(SIGTERM, &act, (struct sigaction *)NULL);
}
#endif	/* SIGTYPE_POSIX */

#if	SIG_TYPE == SIGTYPE_UNIX
void SetupSignals(func)
    void		       (*func)();
{
    (void) signal(SIGINT, func);
    (void) signal(SIGHUP, func);
    (void) signal(SIGTERM, func);
}
#endif	/* SIGTYPE_UNIX */

/*
 * Turn off alarm
 */
void AlarmOff()
{
    (void) alarm((unsigned) 0);
}

#if	SIG_TYPE == SIGTYPE_POSIX
/*
 * POSIX turn on alarm
 */
void AlarmOn(timeout, func)
    int				timeout;
    void		       (*func)();
{
    struct sigaction		act;

    AlarmOff();

    sigemptyset(&act.sa_mask);
    act.sa_flags = 0;
    act.sa_handler = func;
    if (sigaction(SIGALRM, &act, (struct sigaction *)NULL) != 0)
	Error("sigaction failed to set SIGALRM: %s.", SYSERR);

    (void) alarm(timeout);
}
#endif	/* SIGTYPE_POSIX */

#if	SIG_TYPE == SIGTYPE_UNIX
/*
 * Unix turn on alarm
 */
void AlarmOn(timeout, func)
    int				timeout;
    void		      (*func)();
{
    AlarmOff();

    (void) signal(SIGALRM, func);
    (void) alarm(timeout);
}
#endif	/* SIGTYPE_UNIX */
