/* Motorola 68k series support for 32-bit ELF
   Copyright 1993 Free Software Foundation, Inc.

This file is part of BFD, the Binary File Descriptor library.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include "bfd.h"
#include "sysdep.h"
#include "libbfd.h"
#include "libelf.h"

/* elf32 m68k code, generated by elf.el */
enum reloc_type {
  R_68K_NONE        =   0,
  R_68K_32          =   1,
  R_68K_16          =   2,
  R_68K_8           =   3,
  R_68K_PC32        =   4,
  R_68K_PC16        =   5,
  R_68K_PC8         =   6,
  R_68K_GOT32       =   7,
  R_68K_GOT16       =   8,
  R_68K_GOT8        =   9,
  R_68K_GOT32O      =  10,
  R_68K_GOT16O      =  11,
  R_68K_GOT8O       =  12,
  R_68K_PLT32       =  13,
  R_68K_PLT16       =  14,
  R_68K_PLT8        =  15,
  R_68K_PLT32O      =  16,
  R_68K_PLT16O      =  17,
  R_68K_PLT8O       =  18,
  R_68K_COPY        =  19,
  R_68K_GLOB_DAT    =  20,
  R_68K_JMP_SLOT    =  21,
  R_68K_RELATIVE    =  22,
  R_68K__max
};

static reloc_howto_type howto_table[] = {
  HOWTO(R_68K_NONE,       0, 0, 0, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_NONE",      true,  0x00000000, 0x00000000,false),
  HOWTO(R_68K_32,         0, 2,32, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_32",        true,  0xffffffff, 0xffffffff,false),
  HOWTO(R_68K_16,         0, 1,16, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_16",        true,  0x0000ffff, 0x0000ffff,false),
  HOWTO(R_68K_8,          0, 0, 8, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_8",         true,  0x000000ff, 0x000000ff,false),
  HOWTO(R_68K_PC32,       0, 2,32, true, 0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_PC32",      true,  0xffffffff, 0xffffffff,false),
  HOWTO(R_68K_PC16,       0, 1,16, true, 0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_PC16",      true,  0x0000ffff, 0x0000ffff,false),
  HOWTO(R_68K_PC8,        0, 0, 8, true, 0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_PC8",       true,  0x000000ff, 0x000000ff,false),
  HOWTO(R_68K_GOT32,      0, 2,32, true, 0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_GOT32",     true,  0xffffffff, 0xffffffff,false),
  HOWTO(R_68K_GOT16,      0, 1,16, true, 0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_GOT16",     true,  0x0000ffff, 0x0000ffff,false),
  HOWTO(R_68K_GOT8,       0, 0, 8, true, 0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_GOT8",      true,  0x000000ff, 0x000000ff,false),
  HOWTO(R_68K_GOT32O,     0, 2,32, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_GOT32O",    true,  0xffffffff, 0xffffffff,false),
  HOWTO(R_68K_GOT16O,     0, 1,16, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_GOT16O",    true,  0x0000ffff, 0x0000ffff,false),
  HOWTO(R_68K_GOT8O,      0, 0, 8, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_GOT8O",     true,  0x000000ff, 0x000000ff,false),
  HOWTO(R_68K_PLT32,      0, 2,32, true, 0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_PLT32",     true,  0xffffffff, 0xffffffff,false),
  HOWTO(R_68K_PLT16,      0, 1,16, true, 0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_PLT16",     true,  0x0000ffff, 0x0000ffff,false),
  HOWTO(R_68K_PLT8,       0, 0, 8, true, 0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_PLT8",      true,  0x000000ff, 0x000000ff,false),
  HOWTO(R_68K_PLT32O,     0, 2,32, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_PLT32O",    true,  0xffffffff, 0xffffffff,false),
  HOWTO(R_68K_PLT16O,     0, 1,16, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_PLT16O",    true,  0x0000ffff, 0x0000ffff,false),
  HOWTO(R_68K_PLT8O,      0, 0, 8, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_PLT8O",     true,  0x000000ff, 0x000000ff,false),
  HOWTO(R_68K_COPY,       0, 0, 0, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_COPY",      true,  0xffffffff, 0xffffffff,false),
  HOWTO(R_68K_GLOB_DAT,   0, 2,32, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_GLOB_DAT",  true,  0xffffffff, 0xffffffff,false),
  HOWTO(R_68K_JMP_SLOT,   0, 2,32, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_JMP_SLOT",  true,  0xffffffff, 0xffffffff,false),
  HOWTO(R_68K_RELATIVE,   0, 2,32, false,0, complain_overflow_dont,     bfd_elf_generic_reloc, "R_68K_RELATIVE",  true,  0xffffffff, 0xffffffff,false),
};

static void
rtype_to_howto (abfd, cache_ptr, dst)
     bfd *abfd;
     arelent *cache_ptr;
     Elf_Internal_Rel *dst;
{
  BFD_ASSERT (ELF32_R_TYPE(dst->r_info) < (unsigned int) R_68K__max);
  cache_ptr->howto = &howto_table[ELF32_R_TYPE(dst->r_info)];
}

#define elf_info_to_howto 0
#define elf_info_to_howto_rel rtype_to_howto

static const struct { unsigned char bfd_val, elf_val; } reloc_map[] = {
  { BFD_RELOC_NONE, R_68K_NONE },
  { BFD_RELOC_32, R_68K_32 },
  { BFD_RELOC_16, R_68K_16 },
  { BFD_RELOC_8, R_68K_8 },
  { BFD_RELOC_32_PCREL, R_68K_PC32 },
  { BFD_RELOC_16_PCREL, R_68K_PC16 },
  { BFD_RELOC_8_PCREL, R_68K_PC8 },
  { BFD_RELOC_32_GOT_PCREL, R_68K_GOT32 },
  { BFD_RELOC_16_GOT_PCREL, R_68K_GOT16 },
  { BFD_RELOC_8_GOT_PCREL, R_68K_GOT8 },
  { BFD_RELOC_32_GOTOFF, R_68K_GOT32O },
  { BFD_RELOC_16_GOTOFF, R_68K_GOT16O },
  { BFD_RELOC_8_GOTOFF, R_68K_GOT8O },
  { BFD_RELOC_32_PLT_PCREL, R_68K_PLT32 },
  { BFD_RELOC_16_PLT_PCREL, R_68K_PLT16 },
  { BFD_RELOC_8_PLT_PCREL, R_68K_PLT8 },
  { BFD_RELOC_32_PLTOFF, R_68K_PLT32O },
  { BFD_RELOC_16_PLTOFF, R_68K_PLT16O },
  { BFD_RELOC_8_PLTOFF, R_68K_PLT8O },
  { BFD_RELOC_NONE, R_68K_COPY },
  { BFD_RELOC_68K_GLOB_DAT, R_68K_GLOB_DAT },
  { BFD_RELOC_68K_JMP_SLOT, R_68K_JMP_SLOT },
  { BFD_RELOC_68K_RELATIVE, R_68K_RELATIVE },
  { BFD_RELOC_CTOR, R_68K_32 },
};

static reloc_howto_type *
reloc_type_lookup (abfd, code)
     bfd *abfd;
     bfd_reloc_code_real_type code;
{
  int i;
  for (i = 0; i < sizeof (reloc_map) / sizeof (reloc_map[0]); i++)
    {
      if (reloc_map[i].bfd_val == code)
	return &howto_table[(int) reloc_map[i].elf_val];
    }
  return 0;
}

#define bfd_elf32_bfd_reloc_type_lookup reloc_type_lookup
#define ELF_ARCH bfd_arch_m68k
/* end code generated by elf.el */

#define USE_REL

static boolean
elf_no_size_dynamic_sections (output_bfd, info)
     bfd *output_bfd;
     struct bfd_link_info *info;
{
  return true;
}

#define elf_backend_size_dynamic_sections \
					elf_no_size_dynamic_sections

#define TARGET_BIG_SYM	bfd_elf32_m68k_vec
#define TARGET_BIG_NAME	"elf32-m68k"
#define ELF_MACHINE_CODE EM_68K
#define ELF_MAXPAGESIZE		0x2000

#include "elf32-target.h"
