# $Id: makefile.sol,v 1.26 1996/06/05 17:14:43 mikes Exp $
#
#            T H E    P I N E    M A I L   S Y S T E M
#
#   Laurence Lundblade and Mike Seibel
#   Networks and Distributed Computing
#   Computing and Communications
#   University of Washington
#   Administration Building, AG-44
#   Seattle, Washington, 98195, USA
#   Internet: lgl@CAC.Washington.EDU
#             mikes@CAC.Washington.EDU
#
#   Please address all bugs and comments to "pine-bugs@cac.washington.edu"
#
#
#   Pine and Pico are registered trademarks of the University of Washington.
#   No commercial use of these trademarks may be made without prior written
#   permission of the University of Washington.
#
#   Pine, Pico, and Pilot software and its included text are Copyright
#   1989-1996 by the University of Washington.
#
#   The full text of our legal notices is contained in the file called
#   CPYRIGHT, included with this distribution.
#
#
#   Pine is in part based on The Elm Mail System:
#    ***********************************************************************
#    *  The Elm Mail System  -  Revision: 2.13                             *
#    *                                                                     *
#    * 			Copyright (c) 1986, 1987 Dave Taylor               *
#    * 			Copyright (c) 1988, 1989 USENET Community Trust    *
#    ***********************************************************************
#
#


#
#     Make file for the Pine mail system for Solaris 2.2
#      (this is very similar to the generic SV4 port)
#
#
#   Most commonly fiddled flags for compiler.
#   Uncomment the setttings desired here
#
RM=          rm -f
LN=          ln -s
MAKE=        make
OPTIMIZE=    # -O
PROFILE=     # -pg
DEBUG=       -g -DDEBUG

IMAPDIR=     ../c-client
PICODIR=     ../pico

STDLIBES=    -ltermlib -lsocket -lnsl -lgen
LOCLIBES=    $(PICODIR)/libpico.a $(IMAPDIR)/c-client.a
LIBES=       $(EXTRALIBES) $(LOCLIBES) $(STDLIBES)

# Use these for the Solaris C compiler
STDCFLAGS=   -Dconst= -DSV4 -DSYSTYPE=\"SOL\" -DMOUSE
# LDCC= /usr/bin/cc
# If you don't have /usr/bin/cc (our Solaris 2.2 doesn't seem to have it,
# it only has /usr/ucb/cc) then change LDCC to the following line and
# give that a try.  This is still using the Solaris compiler but
# leaving out the UCB compatibility includes and libraries.
LDCC= $(PICODIR)/cc5.sol

# Use these for the gcc compiler
# CC=	gcc
#  STDCFLAGS=   -DSV4 -ansi -DANSI
# LDCC=	gcc
CFLAGS=      $(OPTIMIZE) $(PROFILE) $(DEBUG) $(EXTRACFLAGS) $(STDCFLAGS)

obj=    addrbook.o adrbklib.o args.o context.o filter.o \
	folder.o help.o helptext.o imap.o init.o mailcap.o mailcmd.o \
	mailindx.o mailpart.o mailview.o newmail.o other.o pine.o \
	reply.o screen.o send.o signals.o status.o strings.o ttyin.o \
	ttyout.o os.o

cfiles= addrbook.c adrbklib.c args.c context.c filter.c \
	folder.c help.c helptext.c imap.c init.c mailcap.c mailcmd.c \
	mailindx.c mailpart.c mailview.c newmail.c other.c pine.c \
	reply.c screen.c send.c signals.c status.c strings.c ttyin.c \
	ttyout.c os.c

pine:  $(obj) $(LOCLIBES)
	echo "char datestamp[]="\"`date`\"";" > date.c
	echo "char hoststamp[]="\"`hostname`\"";" >> date.c
	$(LDCC) $(LDFLAGS) $(CFLAGS) -o pine $(obj) date.c $(LIBES)

# this is not part of pine
pine-use:	pine-use.c
	$(CC) -o pine-use pine-use.c

clean:
	$(RM) *.o os.h os.c helptext.c helptext.h
	cd osdep; make clean; cd ..


HEADERS= headers.h pine.h os.h helptext.h context.h \
	  $(IMAPDIR)/mail.h $(IMAPDIR)/osdep.h

addrbook.o:	addrbook.c  $(HEADERS) adrbklib.h $(PICODIR)/pico.h
adrbklib.o: 	adrbklib.c  $(HEADERS) adrbklib.h
args.o:		args.c      $(HEADERS)
context.o:	context.c   $(HEADERS) $(IMAPDIR)/misc.h
filter.o:	filter.c    $(HEADERS) $(PICODIR)/pico.h
folder.o:	folder.c    $(HEADERS)
help.o:		help.c      $(HEADERS)
helptext.o:	helptext.c
imap.o:	        imap.c      $(HEADERS)
init.o:		init.c      $(HEADERS)
mailcap.o:	mailcap.c   $(HEADERS)
mailcmd.o:	mailcmd.c   $(HEADERS) $(PICODIR)/pico.h
mailindx.o:	mailindx.c  $(HEADERS)
mailpart.o:	mailpart.c  $(HEADERS)
mailview.o:	mailview.c  $(HEADERS)
newmail.o:	newmail.c   $(HEADERS)
os.o:		os.c 	    $(HEADERS)
other.o:	other.c     $(HEADERS) $(PICODIR)/pico.h
pine.o:		pine.c      $(HEADERS)
reply.o:	reply.c     $(HEADERS)
screen.o:	screen.c    $(HEADERS)
send.o:	        send.c      $(HEADERS) $(IMAPDIR)/smtp.h $(PICODIR)/pico.h
signals.o:	signals.c   $(HEADERS)
status.o:	status.c    $(HEADERS)
strings.o:	strings.c   $(HEADERS)
ttyin.o:	ttyin.c     $(HEADERS)
ttyout.o:	ttyout.c    $(HEADERS)

os.h:	osdep/os-sol.h
	$(RM) os.h
	$(LN) osdep/os-sol.h os.h

helptext.c:	pine.hlp
		./cmplhelp.sh  < pine.hlp > helptext.c

helptext.h:	pine.hlp
		./cmplhlp2.sh  < pine.hlp > helptext.h

os.c:	osdep/os-sv4.c
	$(RM) os.c
	$(LN) osdep/os-sv4.c os.c

osdep/os-sv4.c:	osdep/bld_path osdep/canacces osdep/canonicl \
		osdep/chnge_pw osdep/coredump osdep/creatdir \
		osdep/diskquot.sv4 osdep/domnames osdep/err_desc \
		osdep/expnfldr osdep/fgetpos osdep/filesize osdep/fltrname \
		osdep/fnexpand osdep/header osdep/hostname.una \
		osdep/jobcntrl osdep/lstcmpnt osdep/mimedisp osdep/pipe \
		osdep/print osdep/pw_stuff osdep/readfile osdep/debuging \
		osdep/rename osdep/srandom.dum osdep/tempfile osdep/tempnam \
		osdep/writ_dir osdep/sunquota osdep/sendmail osdep/execview \
		osdep/os-sv4.ic
	cd osdep; $(MAKE) includer os-sv4.c; cd ..
