% Java mode is just a superset of C mode so make sure it is loaded.
!if (keymap_p ("C")) () = evalfile ("cmode");

$1 = "java";

create_syntax_table ($1);
define_syntax ("/*", "*/", '%', $1);
define_syntax ("([{", ")]}", '(', $1);
define_syntax ('"', '"', $1);
define_syntax ('\'', '\'', $1);
define_syntax ('\\', '\\', $1);
define_syntax ("0-9a-zA-Z_", 'w', $1);        % words
define_syntax ("-+0-9a-fA-F.xXL", '0', $1);   % Numbers
define_syntax (",;.?:", ',', $1);
define_syntax ('#', '#', $1);
define_syntax ("%-+/&*=<>|!~^", '+', $1);
set_syntax_flags ($1, 4);

() = define_keywords_n ($1, "doif", 2, 0);
() = define_keywords_n ($1, "forintnewtry", 3, 0);
() = define_keywords_n ($1, "bytecasecharelselongthisvoid", 4, 0);
() = define_keywords_n ($1, "breakcatchclassfinalfloatshortsuperthrowwhile", 5, 0);
() = define_keywords_n ($1, "doubleimportnativepublicreturnstaticswitchthrows", 6, 0);
() = define_keywords_n ($1, "booleandefaultextendsfinallypackageprivatevirtual", 7, 0);
() = define_keywords_n ($1, "abstractcontinuevolatile", 8, 0);
() = define_keywords_n ($1, "interfaceprotected", 9, 0);
() = define_keywords_n ($1, "implementsinstanceof", 10, 0);
() = define_keywords_n ($1, "synchronized", 12, 0);

() = define_keywords_n ($1, "var", 3, 1);
() = define_keywords_n ($1, "castgotonullresttrue", 4, 1);
() = define_keywords_n ($1, "constfalseinnerouter", 5, 1);
() = define_keywords_n ($1, "future", 6, 1);
() = define_keywords_n ($1, "byvaluegeneric", 7, 1);
() = define_keywords_n ($1, "finalizeoperator", 8, 1);
() = define_keywords_n ($1, "transient", 9, 1);

define java_mode ()
{
   variable java = "java";
   c_mode ();
   set_mode (java, 2);
   use_syntax_table (java);
   runhooks("java_mode_hook");
}
