/***************************************************************************
                            kde_HTMLOptionElement.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLOPTIONELEMENT
#define KDE_HTMLOPTIONELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 A selectable choice. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-OPTION">
 OPTION element definition </a> in HTML 4.0.

 
 @short 
 A selectable choice.
*/
kde_HTMLOptionElement * kde_new_HTMLOptionElement();
kde_HTMLOptionElement * kde_new_HTMLOptionElement1(kde_HTMLOptionElement* other);
kde_HTMLOptionElement * kde_new_HTMLOptionElement2(kde_DOMNode* other);
void kde_del_HTMLOptionElement( kde_HTMLOptionElement* p );

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
kde_HTMLFormElement* kde_HTMLOptionElement_form(kde_HTMLOptionElement* instPointer);

/** 
 Stores the initial value of the <code> selected </code>
 attribute.

     
*/
int kde_HTMLOptionElement_defaultSelected(kde_HTMLOptionElement* instPointer);

/** 
 see @ref defaultSelected
     
*/
void kde_HTMLOptionElement_setDefaultSelected(kde_HTMLOptionElement* instPointer,int arg1);

/** 
 The text contained within the option element.

     
*/
kde_DOMString* kde_HTMLOptionElement_text(kde_HTMLOptionElement* instPointer);

/** 
 The index of this <code> OPTION </code> in its parent <code>
 SELECT </code> .

     
*/
long kde_HTMLOptionElement_index(kde_HTMLOptionElement* instPointer);

/** 
 see @ref index

 This function is obsolete - the index property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
void kde_HTMLOptionElement_setIndex(kde_HTMLOptionElement* instPointer,long arg1);

/** 
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLOptionElement_disabled(kde_HTMLOptionElement* instPointer);

/** 
 see @ref disabled
     
*/
void kde_HTMLOptionElement_setDisabled(kde_HTMLOptionElement* instPointer,int arg1);

/** 
 Option label for use in hierarchical menus. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-label-OPTION">
 label attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLOptionElement_label(kde_HTMLOptionElement* instPointer);

/** 
 see @ref label
     
*/
void kde_HTMLOptionElement_setLabel(kde_HTMLOptionElement* instPointer,kde_DOMString* arg1);

/** 
 Means that this option is initially selected. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-selected">
 selected attribute definition </a> in HTML 4.0.

     
*/
int kde_HTMLOptionElement_selected(kde_HTMLOptionElement* instPointer);

/** 
 see @ref selected
     
*/
void kde_HTMLOptionElement_setSelected(kde_HTMLOptionElement* instPointer,int arg1);

/** 
 The current form control value. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-value-OPTION">
 value attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLOptionElement_value(kde_HTMLOptionElement* instPointer);

/** 
 see @ref value
     
*/
void kde_HTMLOptionElement_setValue(kde_HTMLOptionElement* instPointer,kde_DOMString* arg1);

#endif
