/***************************************************************************
                            kde_Range.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_RANGE
#define KDE_RANGE

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*/
#define RANGE_START_TO_START	0
#define RANGE_START_TO_END	1
#define RANGE_END_TO_END	2
#define RANGE_END_TO_START	3
kde_Range * kde_new_Range();
kde_Range * kde_new_Range1(kde_DOMDocument* rootContainer);
kde_Range * kde_new_Range2(kde_Range* other);
kde_Range * kde_new_Range3(kde_DOMNode* startContainer, long startOffset, kde_DOMNode* endContainer, long endOffset);
void kde_del_Range( kde_Range* p );

/** 
 Node within which the range begins

     
*/
kde_DOMNode* kde_Range_startContainer(kde_Range* instPointer);

/** 
 Offset within the starting node of the range.

     
*/
long kde_Range_startOffset(kde_Range* instPointer);

/** 
 Node within which the range ends

     
*/
kde_DOMNode* kde_Range_endContainer(kde_Range* instPointer);

/** 
 Offset within the ending node of the range.

     
*/
long kde_Range_endOffset(kde_Range* instPointer);

/** 
 TRUE if the range is collapsed

     
*/
int kde_Range_collapsed(kde_Range* instPointer);

/** 
 Gets the common ancestor container of the range's two end-points.
 Also sets it.

     
*/
kde_DOMNode* kde_Range_commonAncestorContainer(kde_Range* instPointer);

/** 
 Sets the attributes describing the start of the range.

  INVALID_NODE_TYPE_ERR: Raised if <code> refNode </code> or an
 ancestor of <code> refNode </code> is an Attr, Entity,
 Notation, or DocumentType node.

  If an offset is out-of-bounds, should it just be fixed up or
 should an exception be raised.

     
*/
void kde_Range_setStart(kde_Range* instPointer,kde_DOMNode* refNode, long offset);

/** 
 Sets the attributes describing the end of a range.

  INVALID_NODE_TYPE_ERR: Raised if <code> refNode </code> or an
 ancestor of <code> refNode </code> is an Attr, Entity,
 Notation, or DocumentType node.

     
*/
void kde_Range_setEnd(kde_Range* instPointer,kde_DOMNode* refNode, long offset);

/** 
 Sets the start position to be before a node

     
*/
void kde_Range_setStartBefore(kde_Range* instPointer,kde_DOMNode* refNode);

/** 
 Sets the start position to be after a node

     
*/
void kde_Range_setStartAfter(kde_Range* instPointer,kde_DOMNode* refNode);

/** 
 Sets the end position to be before a node.

     
*/
void kde_Range_setEndBefore(kde_Range* instPointer,kde_DOMNode* refNode);

/** 
 Sets the end of a range to be after a node

     
*/
void kde_Range_setEndAfter(kde_Range* instPointer,kde_DOMNode* refNode);

/** 
 Collapse a range onto one of its end-points

     
*/
void kde_Range_collapse(kde_Range* instPointer,int toStart);

/** 
 Select a node and its contents

     
*/
void kde_Range_selectNode(kde_Range* instPointer,kde_DOMNode* refNode);

/** 
 Select the contents within a node

     
*/
void kde_Range_selectNodeContents(kde_Range* instPointer,kde_DOMNode* refNode);

/** 
 Compare the end-points of two ranges in a document.

     
*/
short kde_Range_compareBoundaryPoints(kde_Range* instPointer,int how, kde_Range* sourceRange);

/** 

 not part of the DOM

 Compare the boundary-points of a range.

 Return true if the startContainer is before the endContainer,
 or if they are equal.
 Return false if the startContainer is after the endContainer.

     
*/
int kde_Range_boundaryPointsValid(kde_Range* instPointer);

/** 
 Removes the contents of a range from the containing document or
 document fragment without returning a reference to the removed
 content.

     
*/
void kde_Range_deleteContents(kde_Range* instPointer);

/** 
 Moves the contents of a range from the containing document or
 document fragment to a new DocumentFragment.

  HIERARCHY_REQUEST_ERR: Raised if a DocumentType node would be
 extracted into the new DocumentFragment.

     
*/
kde_DocumentFragment* kde_Range_extractContents(kde_Range* instPointer);

/** 
 Duplicates the contents of a range

     
*/
kde_DocumentFragment* kde_Range_cloneContents(kde_Range* instPointer);

/** 
 Inserts a node into the document or document fragment at the
 start of the range.

  WRONG_DOCUMENT_ERR: Raised if <code> newNode </code> and the
 container of the start of the Range were not created from the
 same document.

  HIERARCHY_REQUEST_ERR: Raised if the container of the start of
 the Range is of a type that does not allow children of the type
 of <code> newNode </code> or if <code> newNode </code> is an
 ancestor of the container .

     
*/
void kde_Range_insertNode(kde_Range* instPointer,kde_DOMNode* newNode);

/** 
 Reparents the contents of the range to the given node and
 inserts the node at the position of the start of the range.

  WRONG_DOCUMENT_ERR: Raised if <code> newParent </code> and the
 container of the start of the Range were not created from the
 same document.

  HIERARCHY_REQUEST_ERR: Raised if the container of the start of
 the Range is of a type that does not allow children of the type
 of <code> newParent </code> or if <code> newParent </code> is
 an ancestor of the container or if <code> node </code> would
 end up with a child node of a type not allowed by the type of
 <code> node </code> .

  INVALID_NODE_TYPE_ERR: Raised if <code> node </code> is an
 Attr, Entity, DocumentType, Notation, Document, or
 DocumentFragment node.

     
*/
void kde_Range_surroundContents(kde_Range* instPointer,kde_DOMNode* newParent);

/** 
 Produces a new range whose end-points are equal to the
 end-points of the range.

     
*/
kde_Range* kde_Range_cloneRange(kde_Range* instPointer);

/** 
 Returns the contents of a range as a string.

     
*/
kde_DOMString* kde_Range_toString(kde_Range* instPointer);

/** 

     
*/
kde_DOMString* kde_Range_toHTML(kde_Range* instPointer);

/** 
 Called to indicate that the range is no longer in use and that
 the implementation may relinquish any resources associated with
 this range. Subsequent calls to any methods or attribute getters
 on this range will result in a DOMException being thrown with an
 error code of INVALID_STATE_ERR.

     
*/
void kde_Range_detach(kde_Range* instPointer);

/** 
 not part of the DOM
 TRUE if the range is detached

     
*/
int kde_Range_isDetached(kde_Range* instPointer);

/** 

 not part of the DOM
     
*/
//kde_RangeImpl* kde_Range_handle(kde_Range* instPointer);
int kde_Range_isNull(kde_Range* instPointer);

#endif
