/***************************************************************************
                            KDateTable.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Date selection table.
 This is a support class for the KDatePicker class.  It just
 draws the calender table without titles, but could theoretically
 be used as a standalone.

 When a date is selected by the user, it emits a signal:
 dateSelected(QDate)

 See {@link KDateTableSignals} for signals emitted by KDateTable.

 See {@link KDateTableEventHandling} for event handlers to override in subclasses of KDateTable.

 @author Tim Gilman, Mirko Boehm
 
 @version $Id: KDateTable.java,v 1.6 2002/01/31 04:48:56 rdale Exp $

 @short 
 Date selection table.
*/
public class KDateTable extends QGridView  {
	protected KDateTable(Class dummy){super((Class) null);}

	private native void newKDateTable( QWidget parent, Calendar date, String name, int f);

/**  The constructor. 
*/
	public KDateTable( QWidget parent, Calendar date, String name, int f) {
		super((Class) null);
		newKDateTable( parent, date, name, f);
	}
	private native void newKDateTable();
	public KDateTable() {
		super((Class) null);
		newKDateTable();
	}

/**  Returns a recommended size for the widget.
	To save some time, the size of the largest used cell content is
	calculated in each paintCell() call, since all calculations have
	to be done there anyway. The size is stored in maxCell. The
	sizeHint() simply returns a multiple of maxCell. 
*/
	public native QSize sizeHint();

/**  Set the font size of the date table. 
*/
	public native void setFontSize( int size);

/**  Select and display this date. 
*/
	public native boolean setDate( Calendar arg1);
	public native Calendar getDate();

/**  Paint a cell. 
*/
	protected native void paintCell( QPainter arg1, int arg2, int arg3);

/**  Handle the resize events. 
*/
	protected native void viewportResizeEvent( QResizeEvent arg1);

/**  React on mouse clicks that select a date. 
*/
	protected native void contentsMousePressEvent( QMouseEvent arg1);
	protected native void keyPressEvent( QKeyEvent e);
	protected native void focusInEvent( QFocusEvent e);
	protected native void focusOutEvent( QFocusEvent e);
}
