package org.kde.koala;
import org.kde.qt.*;


/** {@link KDirWatch} emits these signals */
public interface KDirWatchSignals {

/** 
 Emitted when a watched file is created.
    
*/
	void fileCreated( String arg1 );
	void destroyed( QObject obj );

/** 
 Emitted when a watched directory is created.
    
*/
	void created( String arg1 );

/** 
 Emitted when a watched file is deleted.
    
*/
	void fileDeleted( String arg1 );

/** 
 Emitted when KDirWatch learns that the file
 <code>_file</code> has changed.

 This happens for instance when a .desktop file 
 gets a new icon. One has to call 
 {@link KDirWatch#setFileDirty} or watch the file for changes
 for this signal to be emitted.

 Note that KDirNotify is network transparent and
 broadcasts to all processes, so it sort of supersedes this.
    
*/
	void fileDirty( String arg1 );

/** 
 Emitted when a watched directory is deleted.

 The directory is still watched for new creation.
    
*/
	void deleted( String arg1 );

/** 
 Emitted when a watched directory is changed, i.e. files
 therein are created or deleted.

 The new ctime is set
 before the signal is emitted.
    
*/
	void dirty( String arg1 );
}

