/***************************************************************************
                            KFileTreeBranch.java -  description
                             -------------------
    begin                : Fri Mar 15 15:14:30 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar 15 15:14:30 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is the branch class of the KFileTreeView, which represents one
 branch in the treeview. Every branch has a root which is an url. The branch lists
 the files unter the root. Every branch uses its own dirlister and can have
 its own filter etc.

 
 See {@link KFileTreeBranchSignals} for signals emitted by KFileTreeBranch.

 @short Branch object for @ref KFileTreeView object.

*/
public class KFileTreeBranch extends KDirLister  {
	protected KFileTreeBranch(Class dummy){super((Class) null);}

	private native void newKFileTreeBranch( KFileTreeView arg1, KURL url, String name, QPixmap pix, boolean showHidden, KFileTreeViewItem branchRoot);

/** 
 constructs a branch for KFileTreeView. Does not yet start to list it.

*/
	public KFileTreeBranch( KFileTreeView arg1, KURL url, String name, QPixmap pix, boolean showHidden, KFileTreeViewItem branchRoot) {
		super((Class) null);
		newKFileTreeBranch( arg1, url, name, pix, showHidden, branchRoot);
	}
	private native void newKFileTreeBranch( KFileTreeView arg1, KURL url, String name, QPixmap pix);
	public KFileTreeBranch( KFileTreeView arg1, KURL url, String name, QPixmap pix) {
		super((Class) null);
		newKFileTreeBranch( arg1, url, name, pix);
	}

/** 

*/
	public native KURL rootUrl();

/** 
 sets a {@link KFileTreeViewItem} as root widget for the branch.
 That must be created outside of the branch. All KFileTreeViewItems
 the branch is allocating will become children of that object.

*/
	public native void setRoot( KFileTreeViewItem r);

/** 

*/
	public native KFileTreeViewItem root();

/** 

*/
	public native String name();

/** 
 sets the name of the branch.
    
*/
	public native void setName( String n);
	public native QPixmap pixmap();
	public native QPixmap openPixmap();

/** 

*/
	public native boolean showExtensions();

/** 
 sets the root of the branch open or closed.
    
*/
	public native void setOpen( boolean setopen);
	public native void setOpen();

/** 
 sets if children recursion is wanted or not. If this is switched off, the
 child directories of a just opened directory are not listed internally.
 That means that it can not be determined if the sub directories are
 expandable or not. If this is switched off there will be no call to
 {@link setExpandable}.

*/
	public native void setChildRecurse( boolean t);
	public native void setChildRecurse();

/** 

*/
	public native boolean childRecurse();

/** 
 populates a branch. This method must be called after a branch was added
 to  a {@link KFileTreeView} using method {@link addBranch}.

*/
	public native boolean populate( KURL url, KFileTreeViewItem currItem);

/** 
 sets printing of the file extensions on or off. If you pass false to this
 slot, all items of this branch will not show their file extensions in the
 tree.

*/
	public native void setShowExtensions( boolean visible);
	public native void setShowExtensions();
	public native void setOpenPixmap( QPixmap pix);

/** 
 allocates a {@link KFileTreeViewItem} for the branch
 for new items.
    
*/
	protected native KFileTreeViewItem createTreeViewItem( KFileTreeViewItem parent, KFileItem fileItem);

/** 
 find the according KFileTreeViewItem by an url 
    
*/
	protected native KFileTreeViewItem findTVIByURL( KURL arg1);
}
