/***************************************************************************
                            KJavaAppletServer.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**
 See {@link KJavaAppletServerSignals} for signals emitted by KJavaAppletServer.

 See {@link KJavaAppletServerEventHandling} for event handlers to override in subclasses of KJavaAppletServer.

*/
public class KJavaAppletServer extends QObject  {
	protected KJavaAppletServer(Class dummy){super((Class) null);}

	private native void newKJavaAppletServer();

/** 
 Create the applet server.  These shouldn't be used directly,
 use allocateJavaServer instead
     
*/
	public KJavaAppletServer() {
		super((Class) null);
		newKJavaAppletServer();
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Create an applet context with the specified id.
     
*/
	public native void createContext( int contextId, KJavaAppletContext context);

/** 
 Destroy the applet context with the specified id. All the applets in the
 context will be destroyed as well.
     
*/
	public native void destroyContext( int contextId);

/** 
 Create an applet in the specified context with the specified id. The applet
 name, class etc. are specified in the same way as in the HTML APPLET tag.
     
*/
	public native void createApplet( int contextId, int appletId, String name, String clazzName, String baseURL, String codeBase, String jarFile, QSize size, String arg1, String params, String windowTitle);

/** 
 This should be called by the KJavaAppletWidget
     
*/
	public native void initApplet( int contextId, int appletId);

/** 
 Destroy an applet in the specified context with the specified id.
     
*/
	public native void destroyApplet( int contextId, int appletId);

/** 
 Start the specified applet.
     
*/
	public native void startApplet( int contextId, int appletId);

/** 
 Stop the specified applet.
     
*/
	public native void stopApplet( int contextId, int appletId);

/** 
 Send data we got back from a KJavaDownloader back to the appropriate
 class loader.
 (This is currently unimplemented on the java side.
     
*/
	public native void sendURLData( String loaderID, String url, byte[] data);

/** 
 Shut down the KJAS server.
     
*/
	public native void quit();
	public native String appletLabel();

/** 
 A factory method that returns the default server. This is the way this
 class is usually instantiated.
     
*/
	public static native KJavaAppletServer allocateJavaServer();

/** 
 When you are done using your reference to the AppletServer,  you must
 dereference it by calling freeJavaServer().
     
*/
	public static native void freeJavaServer();

/** 
 This allows the KJavaAppletWidget to display some feedback in a QLabel
 while the applet is being loaded.  If the java process could not be
 started, an error message is displayed instead.
     
*/
	public static native String getAppletLabel();
	protected native void setupJava( KJavaProcess p);
	protected native void slotJavaRequest( byte[] qb);
	protected native void checkShutdown();
}
