/***************************************************************************
                            DCOPStub.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef DCOPSTUB_H
#define DCOPSTUB_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Abstract base class for dcop stubs as created by the
 dcopidl2cpp compiler

 @short 
 Abstract base class for dcop stubs as created by the
 dcopidl2cpp compiler

*/
@class DCOPClient; 

@interface  DCOPStub : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
       Creates a DCOPStub for application @p app and object @p obj
     
*/
- initWithText: (NSString *)app obj: (NSString *)obj;

/**  
      Creates a DCOPStub for application @p app and object @p obj
       that operates on the DCOPClient @p client
     
*/
- initWithDCOPClient: (DCOPClient*)client app: (NSString *)app obj: (NSString *)obj;
- (void) dealloc;

/** 
       Return the application id.
     
*/
- (NSString *) app;

/** 
       Return the object  id.
     
*/
- (NSString *) obj;

/** 
 Return the status of the last call, either @p CallSucceeded or
 @p CallFailed

See @ref -ok;
     
*/
- (int) status;

/** 
Return whether no error occured

 See @ref -status;
     
*/
- (BOOL) ok;

/** 
       Sets the status to status. Possible values are 'CallSucceeded' and 'CallFailed'
     
*/
- setStatus: (int)_status;

/** 
      Invoked whenever a call fails.  The default implementation
      sets the status to CallFailed.
     
*/
- callFailed;

/**  
      The dcopClient this stub operates on. Either the specific one
       specified in the constructor or -[DCOPClient mainClient].
    
*/
- (DCOPClient*) dcopClient;
+ (int) CallSucceeded;
+ (int) CallFailed;
@end

#endif
