/***************************************************************************
                            HTMLObjectElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLOBJECTELEMENT_H
#define HTMLOBJECTELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Generic embedded object. Note. In principle, all properties on the
 object element are read-write but in some environments some
 properties may be read-only once the underlying object is
 instantiated. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html edef]-OBJECT">
 OBJECT element definition </a> in HTML 4.0.

 
 @short 
 Generic embedded object.
*/
@class HTMLFormElement; 

@interface HTMLObjectElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
- (HTMLFormElement*) form;

/** 
 Applet class file. See the <code> code </code> attribute for
 HTMLAppletElement.

     
*/
- (NSString *) code;

/** 
 see @ref code
     
*/
- setCode: (NSString *)arg1;

/** 
 Aligns this object (vertically or horizontally) with respect to
 its surrounding text. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-align-IMG">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;

/** 
 Space-separated list of archives. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-archive-OBJECT">
 archive attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) archive;

/** 
 see @ref archive
     
*/
- setArchive: (NSString *)arg1;

/** 
 Width of border around the object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-border">
 border attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) border;

/** 
 see @ref border
     
*/
- setBorder: (NSString *)arg1;

/** 
 Base URI for <code> classid </code> , <code> data </code> , and
 <code> archive </code> attributes. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-codebase-OBJECT">
 codebase attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) codeBase;

/** 
 see @ref codeBase
     
*/
- setCodeBase: (NSString *)arg1;

/** 
 Content type for data downloaded via <code> classid </code>
 attribute. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-codetype">
 codetype attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) codeType;

/** 
 see @ref codeType
     
*/
- setCodeType: (NSString *)arg1;

/** 
 A URI specifying the location of the object's data. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-data">
 data attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) data;

/** 
 see @ref data
     
*/
- setData: (NSString *)arg1;

/** 
 Declare (for future reference), but do not instantiate, this
 object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-declare">
 declare attribute definition </a> in HTML 4.0.

     
*/
- (BOOL) declare;

/** 
 see @ref declare
     
*/
- setDeclare: (BOOL)arg1;

/** 
 Override height. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-height-IMG">
 height attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) height;

/** 
 see @ref height
     
*/
- setHeight: (NSString *)arg1;

/** 
 Horizontal space to the left and right of this image, applet,
 or object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-hspace">
 hspace attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) hspace;

/** 
 see @ref hspace
     
*/
- setHspace: (NSString *)arg1;

/** 
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-name-INPUT">
 name attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) name;

/** 
 see @ref name
     
*/
- setName: (NSString *)arg1;

/** 
 Message to render while loading the object. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-standby">
 standby attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) standby;

/** 
 see @ref standby
     
*/
- setStandby: (NSString *)arg1;

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.-[html adef]-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
- (long) tabIndex;

/** 
 see @ref tabIndex
     
*/
- setTabIndex: (long)arg1;

/** 
 Content type for data downloaded via <code> data </code>
 attribute. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-type-OBJECT">
 type attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) type;

/** 
 see @ref type
     
*/
- setType: (NSString *)arg1;

/** 
 Use client-side image map. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-usemap">
 usemap attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) useMap;

/** 
 see @ref useMap
     
*/
- setUseMap: (NSString *)arg1;

/** 
 Vertical space above and below this image, applet, or object.
 See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-vspace">
 vspace attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
- (NSString *) vspace;

/** 
 see @ref vspace
     
*/
- setVspace: (NSString *)arg1;

/** 
 Override width. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/objects.-[html adef]-width-IMG">
 width attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) width;

/** 
 see @ref width
     
*/
- setWidth: (NSString *)arg1;

/** 
 Introduced in DOM Level 2

 Returns the document this iframe contains, if there is any and
 it is available, a Null document otherwise. The attribute is
 read-only.

*/
- (DOMDocument*) contentDocument;
@end

#endif
