/***************************************************************************
                            KCompletionBox.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KCOMPLETIONBOX_H
#define KCOMPLETIONBOX_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KListBox.h>

/**

 A little utility class for "completion-widgets", like @ref KLineEdit or
 @ref KComboBox. KCompletionBox is a listbox, displayed as a rectangle without
 any window decoration, usually directly under the lineedit or combobox.
 It is filled with all possible matches for a completion, so the user
 can select the one he wants.

 It is used when -[KGlobalSettings Completion]== CompletionPopup.

 @author Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A helper widget for "completion-widgets" (KLineEdit, KComboBox)).
*/
@interface KCompletionBox : KListBox 

/** 
 Constructs a KCompletionBox.

 Notice: the parent needs to be always 0L,
 so you can't specify it in the constructor. Because of that, Qt's
 auto-deletion does not take place, so you have to explicitly delete
 this widget when you don't need it anymore.

 The parent widget is used to give the focus back when pressing the
 up-button on the very first item.
     
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- initWithWidget: (QWidget *)parent ;

/** 
 Destroys the box
     
*/
- (void) dealloc;
- (QSize*) sizeHint;

/** 
 Returns a list of all items currently in the box.
     
*/
- (NSArray *) items;

/** 
 Inserts @p items into the box. Does not clear the items before.
 @p index determines at which position @p items will be inserted.
 (defaults to appending them at the end)
     
*/
- insertItems: (NSArray *)items index: (int)index;
- insertItems: (NSArray *)items ;

/** 
 Adjusts the size of the box to fit the width of the parent given in the
 constructor and pops it up at the most appropriate place, relative to
 the parent.

 Depending on the screensize and the position of the parent, this may
 be a different place, however the default is to pop it up and the
 lower left corner of the parent.

 Make sure to -hide the box when appropriate.
     
*/
- popup;

/** 
 Makes this widget (when visible) capture Tab-key events to traverse the
 items in the dropdown list.

 Default off, as it conflicts with the usual behavior of Tab to traverse
 widgets. It is useful for cases like Konqueror's Location Bar, though.

*/
- setTabHandling: (BOOL)enable;

/** 

 Default is false.

*/
- (BOOL) isTabHandling;

/** 
 Sets the text to be emitted if the user chooses not to
 pick from the available matches.

 If the cancelled text is not set through this function, the
 @ref userCancelled signal will not be emitted.

*/
- setCancelledText: (NSString *)arg1;

/** 

*/
- (NSString *) cancelledText;

/** 
 Moves the selection one line down or select the first item if nothing is selected yet.
     
*/
- down;

/** 
 Moves the selection one line up or select the first item if nothing is selected yet.
     
*/
- up;

/** 
 Moves the selection one page down.
     
*/
- pageDown;

/** 
 Moves the selection one page up.
     
*/
- pageUp;

/** 
 Moves the selection up to the first item.
     
*/
- home;

/** 
 Moves the selection down to the last item.
     
*/
- end;

/** 
 Re-implemented for internal reasons.  API is unaffected.
     
*/
- show;

/** 
 Re-implemented for internal reasons.  API is unaffected.
     
*/
- hide;

/** 
 Reimplemented from KListBox to get events from the viewport (to hide
 this widget on mouse-click, Escape-presses, etc.
     
*/
- (BOOL) eventFilter: (QObject *)arg1 event: (QEvent *)arg2;

/** 
 Called when an item was activated. Emits
 @ref -activated with the item.
     
*/
- slotActivated: (QListBoxItem *)arg1;
@end

/** Override these methods in subclasses of KCompletionBox to customise event handling behaviour */
@protocol KCompletionBoxEventHandling

/** 

   
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;

/** 

   
*/
- focusOutEvent:(QFocusEvent*) fe;
- childEvent:(QChildEvent*) arg1;
- viewportDragMoveEvent:(QDragMoveEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- contentsWheelEvent:(QWheelEvent*) arg1;

/** 

   
*/
- leaveEvent:(QEvent*) e;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contentsContextMenuEvent:(QContextMenuEvent*) arg1;
- viewportContextMenuEvent:(QContextMenuEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- viewportMousePressEvent:(QMouseEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- viewportMouseReleaseEvent:(QMouseEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- viewportMouseDoubleClickEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- viewportDragLeaveEvent:(QDragLeaveEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- contentsDropEvent:(QDropEvent*) arg1;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- contentsDragLeaveEvent:(QDragLeaveEvent*) arg1;
- viewportDropEvent:(QDropEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;

/** 

   
*/
- contentsMouseDoubleClickEvent:(QMouseEvent*) e;
- viewportDragEnterEvent:(QDragEnterEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- viewportMouseMoveEvent:(QMouseEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- contentsDragMoveEvent:(QDragMoveEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- contentsMouseReleaseEvent:(QMouseEvent*) arg1;
- viewportWheelEvent:(QWheelEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- contentsDragEnterEvent:(QDragEnterEvent*) arg1;
- contentsMouseMoveEvent:(QMouseEvent*) arg1;

/** 

   
*/
- contentsMousePressEvent:(QMouseEvent*) e;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- viewportResizeEvent:(QResizeEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
