/***************************************************************************
                            KDockWidget.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDOCKWIDGET_H
#define KDOCKWIDGET_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 Floatable widget that can be dragged around with the mouse and
 encapsulate the actual widgets (and member of the dockwidget class
 set).

 You just grip the double-lined panel, tear it off its parent
 widget, drag it somewhere and let it loose. Depending on the
 position where you leave it, the dockwidget becomes a toplevel
 window on the desktop (floating mode) or docks to a new widget
 (dock mode). Note: A KDockWidget can only be docked to a
 KDockWidget.

 If you want to use this kind of widget, your main application
 window has to be a @ref KDockMainWindow.  That is because it has
 got several additional dock management features, for instance a
 @ref KDockManager that has an overview over all dockwidgets and and
 a dockmovemanager (internal class) that handles the dock process.

 Usually you create an KDockWidget that covers the actual widget in this way:
 <PRE>
 ...
 KDockMainWindow* mainWidget;
 ...
 KDockWidget* dock = 0L;
 dock = -[mainWidget createDockWidget]( "Any window caption", nicePixmap, 0L, i18n("window caption")); // 0L==no parent
 QWidget* actualWidget = new QWidget( dock);
 -[dock setWidget]( actualWidget); // embed it
 -[dock setToolTipString](i18n("That's me")); // available when appearing as tab page
 ...
 </PRE>

 See @ref KDockMainWindow how a dockwidget is docked in.

 @author Max Judin (documentation: Falk Brettschneider).
 
 @short 
 Floatable widget that can be dragged around with the mouse and
 encapsulate the actual widgets (and member of the dockwidget class
 set).
*/
@class KDockManager; 
@class KDockTabGroup; 
@class KDockWidgetAbstractHeader; 

@interface KDockWidget : QWidget 

/** 
 Construct a dockwidget.

 Initially, docking to another and docking to this is allowed for
 every @p DockPosition.  It is supposed to be no (tab) group. It will
 taken under control of its dockmanager.

*/
- initWithDockManager: (KDockManager*)dockManager name: (NSString *)name pixmap: (QPixmap *)pixmap parent: (QWidget *)parent strCaption: (NSString *)strCaption strTabPageLabel: (NSString *)strTabPageLabel f: (int)f;
- initWithDockManager: (KDockManager*)dockManager name: (NSString *)name pixmap: (QPixmap *)pixmap ;

/** 
 Destructs a dockwidget.
   
*/
- (void) dealloc;

/** 
 This is a key method of this class! Use it to dock dockwidgets to
 another dockwidget at the right position within its
 @ref KDockMainWindow or a toplevel dockwidget.

 If the target is null, it will become a toplevel dockwidget at position pos;
 Note: Docking to another dockwidget means exactly:
 A new parent dockwidget will be created, that replaces the target dockwidget and contains another single helper widget (tab widget or panner)
 which contains both dockwidgets, this and the target dockwidget. So consider parent<->child relationships change completely during such actions.

*/
- (KDockWidget*) manualDock: (KDockWidget*)target dockPos: (int)dockPos spliPos: (int)spliPos point: (QPoint *) pos check: (BOOL)check tabIndex: (int)tabIndex;
- (KDockWidget*) manualDock: (KDockWidget*)target dockPos: (int)dockPos ;

/** 
 Specify where it is either possible or impossible for this to dock to another dockwidget.

*/
- setEnableDocking: (int)pos;

/** 

*/
- (int) enableDocking;

/** 
 Specify where it is either possible or impossible for another dockwidget to dock to this.

*/
- setDockSite: (int)pos;

/** 

*/
- (int) dockSite;

/** 
 Sets the embedded widget.

 A QLayout takes care about proper resizing, automatically.

*/
- setWidget: (QWidget *)w;

/** 
 Get the embedded widget.

*/
- (QWidget*) getWidget;

/** 
 Sets the header of this dockwidget.

 A @ref QLayout takes care about proper resizing, automatically.
 The header contains the drag panel, the close button and the stay button.

*/
- setHeader: (KDockWidgetAbstractHeader*)ah;

/** 
 Normally it simply shows the dockwidget.

 But additionally, if it is docked to a tab widget (@p DockCenter), it is set as the active (visible) tab page.
   
*/
- makeDockVisible;

/** 

 There are reasons that it's impossible:

*/
- (BOOL) mayBeHide;

/** 

*/
- (BOOL) mayBeShow;

/** 

*/
- (KDockManager*) dockManager;

/** 
 Stores a string for a tooltip.

 That tooltip string has only a meaning when this dockwidget is shown as tab page.
 In this case the tooltip is shown when one holds the mouse cursor on the tab page header.
 Such tooltip will for instance be useful, if you use only icons there.
 Note: Setting an empty string switches the tooltip off.

*/
- setToolTipString: (NSString *)ttStr;

/** 

*/
- (NSString *) toolTipString;

/** 

*/
- (BOOL) isDockBackPossible;

/** 
 Sets a string that is used for the label of the tab page when in tab page mode

*/
- setTabPageLabel: (NSString *)label;

/** 

*/
- (NSString *) tabPageLabel;

/** 
 Catches and processes some @ref QWidget events that are interesting for dockwidgets.
   
*/
- (BOOL) event: (QEvent *)arg1;

/** 
 Add dockwidget management actions to @ref -[QWidget show].
   
*/
- show;

/** 

*/
- (KDockTabGroup*) parentDockTabGroup;

/** 
 Sets the type of the dock window

*/
- setDockWindowType: (int)windowType;

/** 
 Sets the type of the dock window

*/
- setDockWindowTransient: (QWidget *)parent transientEnabled: (BOOL)transientEnabled;

/** 
 Docks a dockwidget back to the dockwidget that was the neighbor
   widget before the current dock position.
  
*/
- dockBack;

/** 
 Toggles the visibility state of the dockwidget if it is able to be shown or to be hidden.
   
*/
- changeHideShowState;

/** 
 Undocks this. It means it becomes a toplevel widget framed by the system window manager.
 A small panel at the top of this undocked widget gives the possibility to drag it into
 another dockwidget by mouse (docking).
   
*/
- undock;

/** 
 Checks some conditions and shows or hides the dockwidget header (drag panel).
 The header is hidden if:

*/
- updateHeader;

/**  Does several things here when it has noticed that the former brother widget (closest neighbor) gets lost.
 The former brother widget is needed for a possible dockback action, to speak with the Beatles:
 "To get back to where you once belonged" ;-)
   
*/
- loseFormerBrotherDockWidget;
+ (int) DockNone;
+ (int) DockTop;
+ (int) DockLeft;
+ (int) DockRight;
+ (int) DockBottom;
+ (int) DockCenter;
+ (int) DockDesktop;
+ (int) DockCorner;
+ (int) DockFullSite;
+ (int) DockFullDocking;
@end

/** Override these methods in subclasses of KDockWidget to customise event handling behaviour */
@protocol KDockWidgetEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
