/***************************************************************************
                            KIconEffect.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KICONEFFECT_H
#define KICONEFFECT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 Applies effects to icons.
 
 @short 
 Applies effects to icons.
*/
@class QImage; 
@class QPixmap; 
@class QWidget;
@class QColor;
@class QRect;

@interface  KIconEffect : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- (void) dealloc;

/** 
 Rereads configuration.
     
*/
- init;

/**  

*/
- (BOOL) hasEffect: (int)group state: (int)state;

/** 
 Returns a fingerprint for the effect selected by 
 [@p group, @p state]. This is useful for caching.
     
*/
- (NSString *) fingerprint: (int)group state: (int)state;

/** 
 Applies an effect to an image. The effect to apply depends on the
 @p group and @p state parameters, and is configured by the user.

*/
- (QImage*) applyToImage: (QImage *)src group: (int)group state: (int)state;

/** 
 Applies an effect to an image.

*/
- (QImage*) applyToImage: (QImage *)src effect: (int)effect value: (float)value rgb: (QColor *)rgb trans: (BOOL)trans;

/** 
 Applies an effect to a pixmap.
     
*/
- (QPixmap*) applyToPixmap: (QPixmap *)src group: (int)group state: (int)state;

/** 
 Applies an effect to a pixmap.
     
*/
- (QPixmap*) applyToPixmap: (QPixmap *)src effect: (int)effect value: (float)value rgb: (QColor *)rgb trans: (BOOL)trans;

/** 
 Returns an image twice as large, consisting of 2x2 pixels.
     
*/
- (QImage*) doublePixels: (QImage *)src;

/** 
 Provides visual feedback to show activation of an icon on a widget.

 Not strictly an 'icon effect', but in practice that's what it looks
 like.
     
*/
+ visualActivate: (QWidget *)arg1 rect: (QRect*)arg2;
+ toGray: (QImage *)image value: (float)value;
+ colorize: (QImage *)image col: (QColor *)col value: (float)value;
+ deSaturate: (QImage *)image value: (float)value;
+ toGamma: (QImage *)image value: (float)value;
+ semiTransparentImage: (QImage *)image;
+ semiTransparentPixmap: (QPixmap *)pixmap;
+ overlay: (QImage *)src overlay: (QImage *)overlay;
+ (int) NoEffect;
+ (int) ToGray;
+ (int) Colorize;
+ (int) ToGamma;
+ (int) DeSaturate;
+ (int) LastEffect;
@end

#endif
