/* The GIMP -- an image manipulation program
 * Copyright (C) 1995 Spencer Kimball and Peter Mattis
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __PALETTE_ENTRIES_H__
#define __PALETTE_ENTRIES_H__

#include "gtk/gtk.h"  /*  eeek  */


typedef struct _PaletteEntries PaletteEntries;

struct _PaletteEntries
{
  gchar     *name;
  gchar     *filename;
  GSList    *colors;
  gint       n_colors;
  gboolean   changed;
  GdkPixmap *pixmap;
};

typedef struct _PaletteEntry PaletteEntry;

struct _PaletteEntry
{
  guchar  color[3];
  gchar  *name;
  gint    position;
};

extern GSList * palette_entries_list;

#endif /* __PALETTE_ENTRIES_H__ */
