/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.net.InetAddress;
import java.net.SocketPermission;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.Permission;
import org.kde.kjas.server.KJASAppletClassLoader;
import org.kde.kjas.server.Main;

public class KJASSecurityManager
extends SecurityManager {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disabled___checkPermission(Permission permission) throws SecurityException, NullPointerException {
        Object object = this.getSecurityContext();
        Thread thread = Thread.currentThread();
        if (permission instanceof SocketPermission) {
            block7: {
                Main.debug("*** checkPermission " + permission + " in context=" + object + " Thread=" + thread);
                ClassLoader classLoader = thread.getContextClassLoader();
                Main.debug("*   ClassLoader=" + classLoader);
                try {
                    KJASAppletClassLoader kJASAppletClassLoader = (KJASAppletClassLoader)classLoader;
                    URL uRL = kJASAppletClassLoader.getCodeBase();
                    URL uRL2 = kJASAppletClassLoader.getDocBase();
                    Main.debug("*   Class Loader docbase=" + uRL2 + " codebase=" + uRL);
                    String string = permission.getName();
                    int n = string.indexOf(58);
                    if (n > 0) {
                        string = string.substring(0, n);
                    }
                    if (KJASSecurityManager.hostsAreEqual(string, uRL.getHost())) {
                        String string2 = permission.getActions();
                        if (string2 != null && string2.indexOf("listen") >= 0) {
                            Main.debug("*   Listen is not allowed.");
                            break block7;
                        } else {
                            Main.debug("*   Hostname equals. Permission granted.");
                            return;
                        }
                    }
                    Main.info("Host mismatch: " + permission + " != " + uRL.getHost());
                }
                catch (ClassCastException classCastException) {
                    Main.debug("*   ClassLoader is not a KJASAppletClassLoader");
                }
            }
            Main.debug("*   Fall through to super.checkPermission()");
        }
        super.checkPermission(permission);
    }

    private static final boolean hostsAreEqual(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (string.length() == 0 || string2.length() == 0) {
            return false;
        }
        if (string.equalsIgnoreCase(string2)) {
            return true;
        }
        if (Main.proxyHost != null && Main.proxyPort != 0) {
            return false;
        }
        InetAddress inetAddress = null;
        InetAddress inetAddress2 = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            Main.kjas_err("Unknown host:" + string, unknownHostException);
            return false;
        }
        try {
            inetAddress2 = InetAddress.getByName(string2);
        }
        catch (UnknownHostException unknownHostException) {
            Main.kjas_err("Unknown host:" + string2, unknownHostException);
            return false;
        }
        return inetAddress.equals(inetAddress2);
    }
}

