/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.graph.BulkUpdateHandler;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.TransactionHandler;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.impl.ModelCom;
import com.hp.hpl.jena.shared.AddDeniedException;
import com.hp.hpl.jena.shared.DeleteDeniedException;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import virtuoso.jdbc4.VirtuosoConnectionPoolDataSource;
import virtuoso.jdbc4.VirtuosoDataSource;
import virtuoso.jena.driver.VirtBulkUpdateHandler;
import virtuoso.jena.driver.VirtPrefixMapping;
import virtuoso.jena.driver.VirtResSetIter;
import virtuoso.jena.driver.VirtTransactionHandler;
import virtuoso.jena.driver.VirtuosoQueryEngine;
import virtuoso.sql.ExtendedString;
import virtuoso.sql.RdfBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtGraph
extends GraphBase {
    public static final String DEFAULT = "virt:DEFAULT";
    protected String graphName;
    protected boolean readFromAllGraphs = false;
    protected String url_hostlist;
    protected String user;
    protected String password;
    protected boolean roundrobin = false;
    protected int prefetchSize = 200;
    protected Connection connection = null;
    protected String ruleSet = null;
    protected boolean useSameAs = false;
    protected int queryTimeout = 0;
    static final String S_TTLP_INSERT = "DB.DBA.TTLP(?,'',?,255)";
    static final String sinsert = "sparql insert into graph iri(??) { `iri(??)` `iri(??)` `bif:__rdf_long_from_batch_params(??,??,??)` }";
    static final String sdelete = "sparql delete from graph iri(??) {`iri(??)` `iri(??)` `bif:__rdf_long_from_batch_params(??,??,??)`}";
    static final int BATCH_SIZE = 5000;
    static final int MAX_CMD_SIZE = 36000;
    static final String utf8 = "charset=utf-8";
    static final String charset = "UTF-8";
    private VirtuosoConnectionPoolDataSource pds = new VirtuosoConnectionPoolDataSource();
    private DataSource ds;
    protected VirtPrefixMapping m_prefixMapping = null;

    public VirtGraph() {
        this(null, "jdbc:virtuoso://localhost:1111/charset=UTF-8", null, null, false);
    }

    public VirtGraph(String string) {
        this(string, "jdbc:virtuoso://localhost:1111/charset=UTF-8", null, null, false);
    }

    public VirtGraph(String string, String string2, String string3, String string4) {
        this(string, string2, string3, string4, false);
    }

    public VirtGraph(String string, String string2, String string3) {
        this(null, string, string2, string3, false);
    }

    public VirtGraph(String string, DataSource dataSource) {
        VirtuosoDataSource virtuosoDataSource;
        if (dataSource instanceof VirtuosoDataSource) {
            virtuosoDataSource = (VirtuosoDataSource)dataSource;
            this.url_hostlist = virtuosoDataSource.getServerName();
            this.graphName = string;
            this.user = virtuosoDataSource.getUser();
            this.password = virtuosoDataSource.getPassword();
        }
        if (this.graphName == null) {
            this.graphName = DEFAULT;
        }
        try {
            this.connection = dataSource.getConnection();
            this.ds = dataSource;
            virtuosoDataSource = new ModelCom((Graph)this);
            TypeMapper typeMapper = TypeMapper.getInstance();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public VirtGraph(DataSource dataSource) {
        this(null, dataSource);
    }

    public VirtGraph(String string, ConnectionPoolDataSource connectionPoolDataSource) {
        VirtuosoDataSource virtuosoDataSource;
        if (connectionPoolDataSource instanceof VirtuosoConnectionPoolDataSource) {
            virtuosoDataSource = (VirtuosoDataSource)connectionPoolDataSource;
            this.url_hostlist = virtuosoDataSource.getServerName();
            this.graphName = string;
            this.user = virtuosoDataSource.getUser();
            this.password = virtuosoDataSource.getPassword();
        }
        if (this.graphName == null) {
            this.graphName = DEFAULT;
        }
        try {
            this.connection = connectionPoolDataSource.getPooledConnection().getConnection();
            virtuosoDataSource = new ModelCom((Graph)this);
            TypeMapper typeMapper = TypeMapper.getInstance();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public VirtGraph(ConnectionPoolDataSource connectionPoolDataSource) {
        this(null, connectionPoolDataSource);
    }

    public VirtGraph(String string, String string2, String string3, String string4, boolean bl) {
        this.url_hostlist = string2.trim();
        this.roundrobin = bl;
        this.graphName = string;
        this.user = string3;
        this.password = string4;
        if (this.graphName == null) {
            this.graphName = DEFAULT;
        }
        try {
            Object object;
            if (this.url_hostlist.startsWith("jdbc:virtuoso://")) {
                object = this.url_hostlist;
                if (((String)object).toLowerCase().indexOf(utf8) == -1) {
                    object = ((String)object).charAt(((String)object).length() - 1) != '/' ? (String)object + "/charset=UTF-8" : (String)object + "charset=UTF-8";
                }
                if (this.roundrobin && ((String)object).toLowerCase().indexOf("roundrobin=") == -1) {
                    object = ((String)object).charAt(((String)object).length() - 1) != '/' ? (String)object + "/roundrobin=1" : (String)object + "roundrobin=1";
                }
                Class.forName("virtuoso.jdbc4.Driver");
                this.connection = DriverManager.getConnection((String)object, string3, string4);
            } else {
                this.pds.setServerName(this.url_hostlist);
                this.pds.setUser(string3);
                this.pds.setPassword(string4);
                this.pds.setCharset(charset);
                this.pds.setRoundrobin(this.roundrobin);
                object = this.pds.getPooledConnection();
                this.connection = object.getConnection();
                this.ds = this.pds;
            }
            object = new ModelCom((Graph)this);
            TypeMapper typeMapper = TypeMapper.getInstance();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public DataSource getDataSource() {
        return this.ds;
    }

    public String getGraphName() {
        return this.graphName;
    }

    protected void setGraphName(String string) {
        this.graphName = string;
    }

    public String getGraphUrl() {
        return this.url_hostlist;
    }

    public String getGraphUser() {
        return this.user;
    }

    public String getGraphPassword() {
        return this.password;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public int getFetchSize() {
        return this.prefetchSize;
    }

    public void setFetchSize(int n) {
        this.prefetchSize = n;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public int getCount() {
        return this.size();
    }

    public void remove(List list) {
        this.delete(list.iterator(), null);
    }

    public void remove(Triple triple) {
        this.delete(triple);
    }

    public boolean getReadFromAllGraphs() {
        return this.readFromAllGraphs;
    }

    public void setReadFromAllGraphs(boolean bl) {
        this.readFromAllGraphs = bl;
    }

    public String getRuleSet() {
        return this.ruleSet;
    }

    public void setRuleSet(String string) {
        this.ruleSet = string;
    }

    public boolean getSameAs() {
        return this.useSameAs;
    }

    public void setSameAs(boolean bl) {
        this.useSameAs = bl;
    }

    public void createRuleSet(String string, String string2) {
        this.checkOpen();
        try {
            Statement statement = this.createStatement();
            statement.execute("rdfs_rule_set('" + string + "', '" + string2 + "')");
            statement.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public void removeRuleSet(String string, String string2) {
        this.checkOpen();
        try {
            Statement statement = this.createStatement();
            statement.execute("rdfs_rule_set('" + string + "', '" + string2 + "', 1)");
            statement.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    private static String escapeString(String string) {
        StringBuilder stringBuilder = new StringBuilder(string.length());
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = c = string.charAt(i);
            if (c == '\\') {
                stringBuilder.append("\\\\");
                continue;
            }
            if (c == '\"') {
                stringBuilder.append("\\\"");
                continue;
            }
            if (c == '\n') {
                stringBuilder.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuilder.append("\\r");
                continue;
            }
            if (c == '\t') {
                stringBuilder.append("\\t");
                continue;
            }
            if (c2 >= '\u0000' && c2 <= '\b' || c2 == '\u000b' || c2 == '\f' || c2 >= '\u000e' && c2 <= '\u001f' || c2 >= '\u007f' && c2 <= '\uffff') {
                stringBuilder.append("\\u");
                stringBuilder.append(VirtGraph.toHexString(c2, 4));
                continue;
            }
            if (c2 >= '\u10000' && c2 <= '\u10ffff') {
                stringBuilder.append("\\U");
                stringBuilder.append(VirtGraph.toHexString(c2, 8));
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static String toHexString(int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder(n2);
        String string = Integer.toHexString(n).toUpperCase();
        int n3 = n2 - string.length();
        for (int i = 0; i < n3; ++i) {
            stringBuilder.append('0');
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    protected Statement createStatement() throws SQLException {
        this.checkOpen();
        Statement statement = this.connection.createStatement();
        if (this.queryTimeout > 0) {
            statement.setQueryTimeout(this.queryTimeout);
        }
        statement.setFetchSize(this.prefetchSize);
        return statement;
    }

    protected PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkOpen();
        PreparedStatement preparedStatement = this.connection.prepareStatement(string);
        if (this.queryTimeout > 0) {
            preparedStatement.setQueryTimeout(this.queryTimeout);
        }
        preparedStatement.setFetchSize(this.prefetchSize);
        return preparedStatement;
    }

    public static String Node2Str(Node node) {
        if (node.isURI()) {
            return "<" + node + ">";
        }
        if (node.isBlank()) {
            return "_:" + node;
        }
        if (node.isLiteral()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("\"");
            stringBuffer.append(VirtGraph.escapeString(node.getLiteralLexicalForm()));
            stringBuffer.append("\"");
            String string = node.getLiteralLanguage();
            if (string != null && string.length() > 0) {
                stringBuffer.append("@");
                stringBuffer.append(string);
            }
            if ((string = node.getLiteralDatatypeURI()) != null && string.length() > 0) {
                stringBuffer.append("^^<");
                stringBuffer.append(string);
                stringBuffer.append(">");
            }
            return stringBuffer.toString();
        }
        return "<" + node + ">";
    }

    void bindSubject(PreparedStatement preparedStatement, int n, Node node) throws SQLException {
        if (node == null) {
            return;
        }
        if (node.isURI()) {
            preparedStatement.setString(n, node.toString());
        } else if (node.isBlank()) {
            preparedStatement.setString(n, "_:" + node.toString());
        } else {
            throw new SQLException("Only URI or Blank nodes can be used as subject");
        }
    }

    void bindPredicate(PreparedStatement preparedStatement, int n, Node node) throws SQLException {
        if (node == null) {
            return;
        }
        if (!node.isURI()) {
            throw new SQLException("Only URI nodes can be used as predicate");
        }
        preparedStatement.setString(n, node.toString());
    }

    void bindObject(PreparedStatement preparedStatement, int n, Node node) throws SQLException {
        if (node == null) {
            return;
        }
        if (node.isURI()) {
            preparedStatement.setInt(n, 1);
            preparedStatement.setString(n + 1, node.toString());
            preparedStatement.setNull(n + 2, 12);
        } else if (node.isBlank()) {
            preparedStatement.setInt(n, 1);
            preparedStatement.setString(n + 1, "_:" + node.toString());
            preparedStatement.setNull(n + 2, 12);
        } else if (node.isLiteral()) {
            String string = node.getLiteralLanguage();
            String string2 = node.getLiteralDatatypeURI();
            if (string != null && string.length() > 0) {
                preparedStatement.setInt(n, 5);
                preparedStatement.setString(n + 1, node.getLiteralValue().toString());
                preparedStatement.setString(n + 2, node.getLiteralLanguage());
            } else if (string2 != null && string2.length() > 0) {
                preparedStatement.setInt(n, 4);
                preparedStatement.setString(n + 1, node.getLiteralValue().toString());
                preparedStatement.setString(n + 2, node.getLiteralDatatypeURI());
            } else {
                preparedStatement.setInt(n, 3);
                preparedStatement.setString(n + 1, node.getLiteralValue().toString());
                preparedStatement.setNull(n + 2, 12);
            }
        } else {
            preparedStatement.setInt(n, 3);
            preparedStatement.setString(n + 1, node.toString());
            preparedStatement.setNull(n + 2, 12);
        }
    }

    public void performAdd(Triple triple) {
        this.performAdd(null, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    protected void performAdd(String string, Triple triple) {
        this.performAdd(string, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    protected void performAdd(String string, Node node, Node node2, Node node3) {
        try {
            PreparedStatement preparedStatement = this.prepareStatement(sinsert);
            preparedStatement.setString(1, string != null ? string : this.graphName);
            this.bindSubject(preparedStatement, 2, node);
            this.bindPredicate(preparedStatement, 3, node2);
            this.bindObject(preparedStatement, 4, node3);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (Exception exception) {
            throw new AddDeniedException(exception.toString());
        }
    }

    public void performDelete(Triple triple) {
        this.performDelete(null, triple.getSubject(), triple.getPredicate(), triple.getObject());
    }

    protected void performDelete(String string, Node node, Node node2, Node node3) {
        try {
            PreparedStatement preparedStatement = this.prepareStatement(sdelete);
            preparedStatement.setString(1, string != null ? string : this.graphName);
            this.bindSubject(preparedStatement, 2, node);
            this.bindPredicate(preparedStatement, 3, node2);
            this.bindObject(preparedStatement, 4, node3);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (Exception exception) {
            throw new DeleteDeniedException(exception.toString());
        }
    }

    protected int graphBaseSize() {
        StringBuffer stringBuffer = new StringBuffer("select count(*) from (sparql define input:storage \"\" ");
        if (this.ruleSet != null) {
            stringBuffer.append(" define input:inference '" + this.ruleSet + "'\n ");
        }
        if (this.useSameAs) {
            stringBuffer.append(" define input:same-as \"yes\"\n ");
        }
        if (this.readFromAllGraphs) {
            stringBuffer.append(" select * where {?s ?p ?o })f");
        } else {
            stringBuffer.append(" select * where { graph `iri(??)` { ?s ?p ?o }})f");
        }
        ResultSet resultSet = null;
        int n = 0;
        this.checkOpen();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(stringBuffer.toString());
            if (!this.readFromAllGraphs) {
                preparedStatement.setString(1, this.graphName);
            }
            if ((resultSet = preparedStatement.executeQuery()).next()) {
                n = resultSet.getInt(1);
            }
            resultSet.close();
            preparedStatement.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
        return n;
    }

    protected boolean graphBaseContains(Triple triple) {
        return this.graphBaseContains(null, triple);
    }

    protected boolean graphBaseContains(String string, Triple triple) {
        ResultSet resultSet = null;
        StringBuffer stringBuffer = new StringBuffer("sparql define input:storage \"\" ");
        this.checkOpen();
        String string2 = " ?s ";
        String string3 = " ?p ";
        String string4 = " ?o ";
        if (!Node.ANY.equals((Object)triple.getSubject())) {
            string2 = VirtGraph.Node2Str(triple.getSubject());
        }
        if (!Node.ANY.equals((Object)triple.getPredicate())) {
            string3 = VirtGraph.Node2Str(triple.getPredicate());
        }
        if (!Node.ANY.equals((Object)triple.getObject())) {
            string4 = VirtGraph.Node2Str(triple.getObject());
        }
        if (this.ruleSet != null) {
            stringBuffer.append(" define input:inference '" + this.ruleSet + "'\n ");
        }
        if (this.useSameAs) {
            stringBuffer.append(" define input:same-as \"yes\"\n ");
        }
        if (this.readFromAllGraphs && string != null) {
            stringBuffer.append(" select * where { " + string2 + " " + string3 + " " + string4 + " } limit 1");
        } else {
            stringBuffer.append(" select * where { graph <" + (string != null ? string : this.graphName) + "> { " + string2 + " " + string3 + " " + string4 + " }} limit 1");
        }
        try {
            Statement statement = this.createStatement();
            resultSet = statement.executeQuery(stringBuffer.toString());
            boolean bl = resultSet.next();
            resultSet.close();
            statement.close();
            return bl;
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public ExtendedIterator<Triple> graphBaseFind(TripleMatch tripleMatch) {
        return this.graphBaseFind(null, tripleMatch);
    }

    protected ExtendedIterator<Triple> graphBaseFind(String string, TripleMatch tripleMatch) {
        StringBuffer stringBuffer = new StringBuffer("sparql ");
        this.checkOpen();
        String string2 = " ?s ";
        String string3 = " ?p ";
        String string4 = " ?o ";
        if (tripleMatch.getMatchSubject() != null) {
            string2 = VirtGraph.Node2Str(tripleMatch.getMatchSubject());
        }
        if (tripleMatch.getMatchPredicate() != null) {
            string3 = VirtGraph.Node2Str(tripleMatch.getMatchPredicate());
        }
        if (tripleMatch.getMatchObject() != null) {
            string4 = VirtGraph.Node2Str(tripleMatch.getMatchObject());
        }
        if (this.ruleSet != null) {
            stringBuffer.append(" define input:inference '" + this.ruleSet + "'\n ");
        }
        if (this.useSameAs) {
            stringBuffer.append(" define input:same-as \"yes\"\n ");
        }
        if (this.readFromAllGraphs && string == null) {
            stringBuffer.append(" select * where { " + string2 + " " + string3 + " " + string4 + " }");
        } else {
            stringBuffer.append(" select * from <" + (string != null ? string : this.graphName) + "> where { " + string2 + " " + string3 + " " + string4 + " }");
        }
        try {
            PreparedStatement preparedStatement = this.prepareStatement(stringBuffer.toString());
            return new VirtResSetIter(this, preparedStatement.executeQuery(), tripleMatch);
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public void close() {
        try {
            super.close();
            this.connection.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public void clear() {
        this.clearGraph(this.graphName);
        this.getEventManager().notifyEvent((Graph)this, (Object)GraphEvents.removeAll);
    }

    public void read(String string, String string2) {
        String string3 = "sparql load \"" + string + "\" into graph <" + this.graphName + ">";
        this.checkOpen();
        try {
            Statement statement = this.createStatement();
            statement.execute(string3);
            statement.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    void add(String string, Iterator<Triple> iterator, List<Triple> list) {
        try {
            PreparedStatement preparedStatement = this.prepareStatement(S_TTLP_INSERT);
            StringBuilder stringBuilder = new StringBuilder(256);
            int n = 0;
            while (iterator.hasNext()) {
                Triple triple = iterator.next();
                if (list != null) {
                    list.add(triple);
                }
                stringBuilder.append(VirtGraph.Node2Str(triple.getSubject()));
                stringBuilder.append(' ');
                stringBuilder.append(VirtGraph.Node2Str(triple.getPredicate()));
                stringBuilder.append(' ');
                stringBuilder.append(VirtGraph.Node2Str(triple.getObject()));
                stringBuilder.append(" .\n");
                if (++n <= 5000) continue;
                preparedStatement.setString(1, stringBuilder.toString());
                preparedStatement.setString(2, string != null ? string : this.graphName);
                preparedStatement.executeUpdate();
                stringBuilder.setLength(0);
                n = 0;
            }
            if (n > 0) {
                preparedStatement.setString(1, stringBuilder.toString());
                preparedStatement.setString(2, string != null ? string : this.graphName);
                preparedStatement.executeUpdate();
            }
            preparedStatement.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    void delete(Iterator<Triple> iterator, List<Triple> list) {
        String string = "sparql define output:format '_JAVA_' DELETE FROM <";
        Statement statement = null;
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append(string);
        stringBuilder.append(this.graphName);
        stringBuilder.append("> { ");
        try {
            statement = this.createStatement();
            while (iterator.hasNext()) {
                Triple triple = iterator.next();
                if (list != null) {
                    list.add(triple);
                }
                StringBuilder stringBuilder2 = new StringBuilder(256);
                stringBuilder2.append(VirtGraph.Node2Str(triple.getSubject()));
                stringBuilder2.append(' ');
                stringBuilder2.append(VirtGraph.Node2Str(triple.getPredicate()));
                stringBuilder2.append(' ');
                stringBuilder2.append(VirtGraph.Node2Str(triple.getObject()));
                stringBuilder2.append(" .\n");
                if (n > 0 && stringBuilder.length() + stringBuilder2.length() > 36000) {
                    stringBuilder.append(" }");
                    statement.execute(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    stringBuilder.append(string);
                    stringBuilder.append(this.graphName);
                    stringBuilder.append("> { ");
                    n = 0;
                }
                stringBuilder.append((CharSequence)stringBuilder2);
                ++n;
            }
            if (n > 0) {
                stringBuilder.append(" }");
                statement.execute(stringBuilder.toString());
            }
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    void delete_match(TripleMatch tripleMatch) {
        this.delete_match(null, tripleMatch);
    }

    void delete_match(String string, TripleMatch tripleMatch) {
        this.checkOpen();
        String string2 = "?s";
        String string3 = "?p";
        String string4 = "?o";
        Node node = tripleMatch.getMatchSubject();
        Node node2 = tripleMatch.getMatchPredicate();
        Node node3 = tripleMatch.getMatchObject();
        try {
            if (node == null && node2 == null && node3 == null) {
                this.clearGraph(string != null ? string : this.graphName);
            } else if (node != null && node2 != null && node3 != null) {
                PreparedStatement preparedStatement = this.prepareStatement(sdelete);
                preparedStatement.setString(1, string != null ? string : this.graphName);
                this.bindSubject(preparedStatement, 2, node);
                this.bindPredicate(preparedStatement, 3, node2);
                this.bindObject(preparedStatement, 4, node3);
                preparedStatement.execute();
                preparedStatement.close();
            } else {
                if (node != null) {
                    string2 = VirtGraph.Node2Str(node);
                }
                if (node2 != null) {
                    string3 = VirtGraph.Node2Str(node2);
                }
                if (node3 != null) {
                    string4 = VirtGraph.Node2Str(node3);
                }
                String string5 = "sparql delete from <" + (string != null ? string : this.graphName) + "> { " + string2 + " " + string3 + " " + string4 + " } where { " + string2 + " " + string3 + " " + string4 + " }";
                Statement statement = this.createStatement();
                statement.execute(string5);
                statement.close();
            }
        }
        catch (Exception exception) {
            throw new DeleteDeniedException(exception.toString());
        }
    }

    void clearGraph(String string) {
        String string2 = "sparql clear graph iri(??)";
        this.checkOpen();
        try {
            PreparedStatement preparedStatement = this.prepareStatement(string2);
            preparedStatement.setString(1, string);
            preparedStatement.execute();
            preparedStatement.close();
        }
        catch (Exception exception) {
            throw new JenaException((Throwable)exception);
        }
    }

    public ExtendedIterator reifierTriples(TripleMatch tripleMatch) {
        return NiceIterator.emptyIterator();
    }

    public int reifierSize() {
        return 0;
    }

    public TransactionHandler getTransactionHandler() {
        return new VirtTransactionHandler(this);
    }

    public BulkUpdateHandler getBulkUpdateHandler() {
        if (this.bulkHandler == null) {
            this.bulkHandler = new VirtBulkUpdateHandler(this);
        }
        return this.bulkHandler;
    }

    public PrefixMapping getPrefixMapping() {
        if (this.m_prefixMapping == null) {
            this.m_prefixMapping = new VirtPrefixMapping(this);
        }
        return this.m_prefixMapping;
    }

    public static Node Object2Node(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof ExtendedString) {
            ExtendedString extendedString = (ExtendedString)object;
            if (extendedString.getIriType() == 1 && (extendedString.getStrType() & 1) == 1) {
                if (extendedString.toString().indexOf("_:") == 0) {
                    return Node.createAnon((AnonId)AnonId.create((String)extendedString.toString().substring(2)));
                }
                return Node.createURI((String)extendedString.toString());
            }
            if (extendedString.getIriType() == 2) {
                return Node.createAnon((AnonId)AnonId.create((String)extendedString.toString().substring(9)));
            }
            return Node.createLiteral((String)extendedString.toString());
        }
        if (object instanceof RdfBox) {
            RdfBox rdfBox = (RdfBox)object;
            String string = rdfBox.getType();
            RDFDatatype rDFDatatype = null;
            if (string != null) {
                rDFDatatype = TypeMapper.getInstance().getSafeTypeByName(string);
            }
            return Node.createLiteral((String)rdfBox.toString(), (String)rdfBox.getLang(), (RDFDatatype)rDFDatatype);
        }
        if (object instanceof Integer) {
            RDFDatatype rDFDatatype = null;
            rDFDatatype = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#integer");
            return Node.createLiteral((String)object.toString(), null, (RDFDatatype)rDFDatatype);
        }
        if (object instanceof Short) {
            RDFDatatype rDFDatatype = null;
            rDFDatatype = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#integer");
            return Node.createLiteral((String)object.toString(), null, (RDFDatatype)rDFDatatype);
        }
        if (object instanceof Float) {
            RDFDatatype rDFDatatype = null;
            rDFDatatype = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#float");
            return Node.createLiteral((String)object.toString(), null, (RDFDatatype)rDFDatatype);
        }
        if (object instanceof Double) {
            RDFDatatype rDFDatatype = null;
            rDFDatatype = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#double");
            return Node.createLiteral((String)object.toString(), null, (RDFDatatype)rDFDatatype);
        }
        if (object instanceof BigDecimal) {
            RDFDatatype rDFDatatype = null;
            rDFDatatype = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#decimal");
            return Node.createLiteral((String)object.toString(), null, (RDFDatatype)rDFDatatype);
        }
        if (object instanceof Blob) {
            RDFDatatype rDFDatatype = null;
            rDFDatatype = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#hexBinary");
            return Node.createLiteral((String)object.toString(), null, (RDFDatatype)rDFDatatype);
        }
        if (object instanceof Date) {
            RDFDatatype rDFDatatype = null;
            rDFDatatype = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#date");
            return Node.createLiteral((String)object.toString(), null, (RDFDatatype)rDFDatatype);
        }
        if (object instanceof Timestamp) {
            RDFDatatype rDFDatatype = null;
            rDFDatatype = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#dateTime");
            return Node.createLiteral((String)VirtGraph.Timestamp2String((Timestamp)object), null, (RDFDatatype)rDFDatatype);
        }
        if (object instanceof Time) {
            RDFDatatype rDFDatatype = null;
            rDFDatatype = TypeMapper.getInstance().getSafeTypeByName("http://www.w3.org/2001/XMLSchema#time");
            return Node.createLiteral((String)object.toString(), null, (RDFDatatype)rDFDatatype);
        }
        return Node.createLiteral((String)object.toString());
    }

    private static String Timestamp2String(Timestamp timestamp) {
        String string;
        String string2;
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(timestamp);
        int n = gregorianCalendar.get(1);
        int n2 = gregorianCalendar.get(2) + 1;
        int n3 = gregorianCalendar.get(5);
        int n4 = gregorianCalendar.get(11);
        int n5 = gregorianCalendar.get(12);
        int n6 = gregorianCalendar.get(13);
        int n7 = timestamp.getNanos();
        String string3 = "000000000";
        String string4 = "0000";
        if (n < 1000) {
            string2 = "" + n;
            string2 = string4.substring(0, 4 - string2.length()) + string2;
        } else {
            string2 = "" + n;
        }
        String string5 = n2 < 10 ? "0" + n2 : Integer.toString(n2);
        String string6 = n3 < 10 ? "0" + n3 : Integer.toString(n3);
        String string7 = n4 < 10 ? "0" + n4 : Integer.toString(n4);
        String string8 = n5 < 10 ? "0" + n5 : Integer.toString(n5);
        String string9 = n6 < 10 ? "0" + n6 : Integer.toString(n6);
        if (n7 == 0) {
            string = "0";
        } else {
            string = Integer.toString(n7);
            string = string3.substring(0, 9 - string.length()) + string;
            char[] cArray = new char[string.length()];
            string.getChars(0, string.length(), cArray, 0);
            int n8 = 8;
            while (cArray[n8] == '0') {
                --n8;
            }
            string = new String(cArray, 0, n8 + 1);
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string2);
        stringBuffer.append("-");
        stringBuffer.append(string5);
        stringBuffer.append("-");
        stringBuffer.append(string6);
        stringBuffer.append("T");
        stringBuffer.append(string7);
        stringBuffer.append(":");
        stringBuffer.append(string8);
        stringBuffer.append(":");
        stringBuffer.append(string9);
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    static {
        VirtuosoQueryEngine.register();
    }
}

